/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.datacontrol.service;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.adf.share.logging.ADFLogger;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.client.ICaseManagementServiceClient;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.client.BPMServiceClientFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceFactory {
    private static final String ACTIVITY_FORM = "Activity";
    public static final String LOGGER = "oracle.adf.model.adapter.bean";
    private static ADFLogger _logger = ADFLogger.createADFLogger((String)"oracle.adf.model.adapter.bean");

    public static Object getObject(String className, String objectId, String contextId, String formType, String objectName, String elementName, String objectNameSpace) {
        try {
            Element node = null;
            Document payload = null;
            if (formType != null && formType.equals(ACTIVITY_FORM)) {
                String packageName = Class.forName(className).getPackage().getName();
                String objFactory = packageName + ".ObjectFactory";
                Class<?> objFactoryCls = Class.forName(objFactory);
                Class[] noParams = new Class[]{};
                Object obj = objFactoryCls.newInstance();
                Method method = objFactoryCls.getDeclaredMethod("createActivityInputsType", noParams);
                Object activityInputs = method.invoke(obj, null);
                new ServiceFactory().instantiate(className, activityInputs);
                return activityInputs;
            }
            try {
                HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
                properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
                BPMServiceClientFactory factory = BPMServiceClientFactory.getInstance(properties, null, null);
                ICaseManagementServiceClient m_client = factory.getCaseManagementServiceClient();
                IWorkflowServiceClient m_wfsvc = factory.getWorkflowServiceClient();
                ITaskQueryService querySvc = m_wfsvc.getTaskQueryService();
                IBPMContext context = null;
                if (contextId != null) {
                    context = (IBPMContext)querySvc.getWorkflowContext(contextId);
                }
                ICaseService caseService = m_client.getCaseService();
                CaseIdentifier caseId = new CaseIdentifier(objectId, null, null);
                CaseData caseData = null;
                try {
                    caseData = caseService.getCaseDataByName(context, caseId, objectName);
                }
                catch (Exception e) {
                    _logger.warning("Failed to fetch case data from backend case service");
                }
                payload = caseData.fetchDataAsDOM();
                node = payload.getDocumentElement();
            }
            catch (Exception e) {
                _logger.warning("failed to load data");
            }
            if (payload == null) {
                Object payloadObj = Class.forName(className).newInstance();
                new ServiceFactory().instantiate(className, payloadObj);
                return payloadObj;
            }
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Class.forName(className)});
            Unmarshaller u = jc.createUnmarshaller();
            if (!ServiceFactory.isXmlRootElement(Class.forName(className))) {
                JAXBElement obj = u.unmarshal(payload, Class.forName(className));
                return obj.getValue();
            }
            return u.unmarshal(payload);
        }
        catch (Exception exc) {
            _logger.warning("Failed to load data in case form");
            return null;
        }
    }

    public static Element setObject(String className, String objectName, String objectNameSpace, String elementName, Object dataObj) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Class.forName(className)});
            Marshaller m = jc.createMarshaller();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            if (!ServiceFactory.isXmlRootElement(Class.forName(className))) {
                m.marshal((Object)new JAXBElement(new QName(objectNameSpace, elementName), Class.forName(className), dataObj), (Node)doc);
            } else {
                m.marshal(dataObj, (Node)doc);
            }
            return doc.getDocumentElement();
        }
        catch (Exception exc) {
            _logger.warning("Failed to mashal case data from form. See log for more details");
            return null;
        }
    }

    public static void main(String[] args) {
    }

    private static boolean isXmlRootElement(Class classT) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = classT.getAnnotations()) {
            if (!(annotation instanceof XmlRootElement)) continue;
            return true;
        }
        return false;
    }

    private void instantiate(String className, Object activityInputs) throws Exception {
        Field[] fields;
        Class<?> activityInputsClass = Class.forName(className);
        for (Field field : fields = activityInputsClass.getDeclaredFields()) {
            String getMethod = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            String setMethod = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            Class[] noParams = new Class[]{};
            try {
                Method setM;
                Method getM;
                if (field.getType().getName().equals("java.lang.Boolean")) {
                    Boolean boolParam = false;
                    Class[] boolParamCls = new Class[]{Class.forName("java.lang.Boolean")};
                    Method setM2 = activityInputsClass.getDeclaredMethod(setMethod, boolParamCls);
                    setM2.invoke(activityInputs, boolParam);
                }
                if ((getM = activityInputsClass.getDeclaredMethod(getMethod, noParams)).getReturnType().getName().equals("java.lang.Object")) {
                    String stringParam = new String("");
                    Class[] stringParamCls = new Class[]{Class.forName("java.lang.Object")};
                    setM = activityInputsClass.getDeclaredMethod(setMethod, stringParamCls);
                    setM.invoke(activityInputs, stringParam);
                    continue;
                }
                if (getM.getReturnType().isPrimitive()) continue;
                Object setParam = getM.getReturnType().newInstance();
                Class[] setParamCls = new Class[]{setParam.getClass()};
                this.instantiate(setParamCls[0].getName(), setParam);
                setM = activityInputsClass.getDeclaredMethod(setMethod, setParamCls);
                setM.invoke(activityInputs, setParam);
            }
            catch (Exception e) {
                _logger.fine("failed to instantiate method " + setMethod);
            }
        }
        if (activityInputsClass.getSuperclass() != null) {
            Field[] inheritedFields;
            Class<?> superClass = activityInputsClass.getSuperclass();
            for (Field field : inheritedFields = superClass.getDeclaredFields()) {
                String superGetMethod = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                String superSetMethod = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                Class[] noParams = new Class[]{};
                try {
                    Method setM;
                    Method getM;
                    if (field.getType().getName().equals("java.lang.Boolean")) {
                        Boolean boolParam = false;
                        Class[] boolParamCls = new Class[]{Class.forName("java.lang.Boolean")};
                        Method setM3 = activityInputsClass.getDeclaredMethod(superSetMethod, boolParamCls);
                        setM3.invoke(activityInputs, boolParam);
                    }
                    if ((getM = superClass.getDeclaredMethod(superGetMethod, noParams)).getReturnType().getName().equals("java.lang.Object")) {
                        String stringParam = new String("");
                        Class[] stringParamCls = new Class[]{Class.forName("java.lang.Object")};
                        setM = superClass.getDeclaredMethod(superSetMethod, stringParamCls);
                        setM.invoke(activityInputs, stringParam);
                        continue;
                    }
                    if (getM.getReturnType().isPrimitive()) continue;
                    Object setParam = getM.getReturnType().newInstance();
                    Class[] setParamCls = new Class[]{setParam.getClass()};
                    this.instantiate(setParamCls[0].getName(), setParam);
                    setM = superClass.getDeclaredMethod(superSetMethod, setParamCls);
                    setM.invoke(activityInputs, setParam);
                }
                catch (Exception e) {
                    _logger.fine("failed to instantiate method " + superSetMethod);
                }
            }
        }
    }
}

