/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.datacontrol.definition;

import oracle.adf.model.adapter.bean.BeanDefinition;
import oracle.adf.model.adapter.generic.DataControlStructure;
import oracle.adf.share.logging.ADFLogger;
import oracle.binding.DataControl;
import oracle.bpm.datacontrol.BPMBeanDataControl;
import oracle.jbo.common.JBOClass;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BPMBeanDefinition
extends BeanDefinition {
    private ADFLogger _logger = ADFLogger.createADFLogger((String)"oracle.adf.model.adapter.bean");
    private String dataObject;
    private String dataObjNS;
    private String serviceType;
    private String formType;
    private String element;
    public static final String BEAN_DEFINITION = "bpm-bean-definition";
    public static final String BEAN_XMLNS = "xmlns";
    public static final String BEAN_DEFINITION_URI = "http://xmlns.oracle.com/adfm/adapter/bean/bpm";
    private static final String ADAPTER_TYPE = "oracle.bpm.datacontrol.BPMBeanDataControl";
    public static final String LOGGER = "oracle.adf.model.adapter.bean";
    public static final String SERVICE_TYPE = "serviceType";
    public static final String FORM_TYPE = "formType";
    public static final String DATA_OBJECT = "dataObject";
    public static final String DATA_OBJECT_NAMESPACE = "dataObjectNamespace";
    public static final String ELEMENT = "element";

    public BPMBeanDefinition() {
    }

    public BPMBeanDefinition(DataControlStructure definition) {
        super(definition);
    }

    public BPMBeanDefinition(String dataObject, String dataObjNS, String serviceType, String formType) {
        this.element = this.element;
        this.dataObject = dataObject;
        this.dataObjNS = dataObjNS;
        this.serviceType = serviceType;
        this.formType = formType;
    }

    public DataControl createDataControl() {
        return new BPMBeanDataControl(this);
    }

    public String getAdapterType() {
        return ADAPTER_TYPE;
    }

    protected void initDefinition() {
        NamedNodeMap beanDefAttrs;
        Node beanDefNode;
        NodeList childList;
        this._logger.fine("Loading bean-definition.");
        Node node = this.getRuntimeMetaData();
        if (node != null && (childList = node.getChildNodes()) != null && childList.getLength() == 1 && (beanDefNode = childList.item(0)) != null && (beanDefAttrs = beanDefNode.getAttributes()) != null) {
            Node attr = beanDefAttrs.getNamedItem("BeanClass");
            if (attr != null) {
                this.setProperty("BeanClass", attr.getNodeValue());
            }
            if ((attr = beanDefAttrs.getNamedItem(SERVICE_TYPE)) != null) {
                this.setProperty(SERVICE_TYPE, attr.getNodeValue());
            }
            if ((attr = beanDefAttrs.getNamedItem(FORM_TYPE)) != null) {
                this.setProperty(FORM_TYPE, attr.getNodeValue());
            }
            if ((attr = beanDefAttrs.getNamedItem(DATA_OBJECT)) != null) {
                this.setProperty(DATA_OBJECT, attr.getNodeValue());
            }
            if ((attr = beanDefAttrs.getNamedItem(ELEMENT)) != null) {
                this.setProperty(ELEMENT, attr.getNodeValue());
            }
            if ((attr = beanDefAttrs.getNamedItem(DATA_OBJECT_NAMESPACE)) != null) {
                this.setProperty(DATA_OBJECT_NAMESPACE, attr.getNodeValue());
            }
            if ((attr = beanDefAttrs.getNamedItem("AccessMode")) != null) {
                this.setProperty("AccessMode", attr.getNodeValue());
            }
            if ((attr = beanDefAttrs.getNamedItem("DataControlHandler")) != null) {
                this.setProperty("DataControlHandler", attr.getNodeValue());
                try {
                    Class clz = JBOClass.forName((String)attr.getNodeValue());
                    if (clz.getName().endsWith(JPQLDataControlHandlerName) || clz.getSuperclass().getName().endsWith(JPQLDataControlHandlerName)) {
                        this.setProperty("_SupportsCriteria", true);
                    }
                }
                catch (ClassNotFoundException e) {
                    this._logger.severe("Exception occurred at forName(" + attr.getNodeValue() + ")");
                }
            }
        }
    }
}

