/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.datacontrol.adapter;

import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import oracle.adf.model.adapter.DTContext;
import oracle.adf.model.adapter.bean.BeanDefinition;
import oracle.adf.model.adapter.dataformat.AccessorDef;
import oracle.adf.model.adapter.dataformat.MethodDef;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adf.model.adapter.generic.DataControlStructure;
import oracle.adf.share.logging.ADFLogger;
import oracle.adfdtinternal.model.adapter.generic.BeanDataControlProvider;
import oracle.adfinternal.model.adapter.generic.DataControlStructureImpl;
import oracle.adfinternal.model.adapter.generic.DataControlStructureProvider;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.ejb.EjbAppManager;
import oracle.jdeveloper.ejb.EjbEngine;
import oracle.jdeveloper.ejb.EjbModuleEngine;
import oracle.jdeveloper.engine.ClassEngine;
import oracle.jdeveloper.engine.EngineUtils;
import oracle.jdeveloper.engine.MethodInfo;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BpmBeanDataControlProviderImpl
extends BeanDataControlProvider
implements DataControlStructureProvider {
    private boolean _isJPA = false;
    private boolean _setIgnoredClasses = false;
    private final String ACTIVITY_FORM = "Activity";
    private String beanDefinitionClassName = "oracle.bpm.datacontrol.definition.BPMBeanDefinition";
    private final String DATA_FORM = "Data";
    private String datacontrolName;
    private String dataObject;
    private String dataObjNS;
    private String elementName;
    private String formType;
    private ADFLogger mLogger = DTContext.getInstance().getLogger();
    private String serviceType;
    private static final String TransactionalDataControl = "TransactionalDataControl";

    public BpmBeanDataControlProviderImpl(String datacontrolName, String dataObject, String elementName, String dataObjNS, String serviceType, String formType) {
        this.dataObject = dataObject;
        this.elementName = elementName;
        this.dataObjNS = dataObjNS;
        this.serviceType = serviceType;
        this.formType = formType;
        this.datacontrolName = datacontrolName;
    }

    public DataControlStructure createDefinition(Object sourceObj, DTContext ctx) {
        this.mLogger.fine("Creating BPM BeanDataControl definition");
        Context context = (Context)ctx.get((Object)"jdev_context");
        if (context == null) {
            return null;
        }
        Project project = context.getProject();
        oracle.ide.model.Element node = context.getElement();
        String packageName = ((JavaSourceNode)node).getPackage();
        String className = URLFileSystem.getName((URL)((JavaSourceNode)node).getURL());
        className = packageName + "." + className;
        ClassEngine classEngine = new ClassEngine(project, className);
        this._isJPA = this.containsJPA(classEngine.getJavaClass());
        Node rtSettings = this.getRuntimeSettings(classEngine);
        StructureDefinition structureDef = this.buildStructure(project, classEngine);
        boolean supportTxn = EngineUtils.isInterfaceImplemented((SourceClass)classEngine.getSourceClass(), (String)TransactionalDataControl);
        if (supportTxn) {
            structureDef.getProperties().put("_SupportsTransaction", supportTxn);
        }
        this.configureClientProject(sourceObj, ctx);
        return new DataControlStructureImpl(this.datacontrolName, rtSettings, structureDef);
    }

    public boolean canCreateDefinition(Object source) {
        boolean canCreate = this.isBeanSource(source);
        return canCreate;
    }

    public boolean isBeanSource(Object source) {
        return source instanceof JavaSourceNode && !this.isEJBSource(source) && !this.isWebServiceSource(source);
    }

    public void configureClientProject(Object sourceObj, DTContext ctx) {
        this.mLogger.fine("Configuring BPM BeanDataControl client project");
        super.configureClientProject(sourceObj, ctx);
        Context context = (Context)ctx.get((Object)"jdev_context");
        if (context != null) {
            this.addLibrariesToProject(context.getProject(), new String[]{"Oracle JDBC"});
        }
    }

    public void addLibrariesToProject(final Project project, final String[] libraries) {
        if (libraries == null || libraries.length == 0) {
            return;
        }
        project.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                JProjectLibraries libs = JProjectLibraries.getInstance((PropertyStorage)project);
                String projName = project.getShortLabel();
                StringBuffer strBuf = new StringBuffer();
                for (int i = 0; i < libraries.length; ++i) {
                    if (!libs.addLibrary((Object)libraries[i])) continue;
                    strBuf.setLength(0);
                    strBuf.append("Added '");
                    strBuf.append(libraries[i]);
                    strBuf.append("' library to project '");
                    strBuf.append(projName);
                    strBuf.append('\'');
                    BpmBeanDataControlProviderImpl.this.mLogger.fine(strBuf.toString());
                }
            }
        });
    }

    public StructureDefinition buildStructure(Project project, ClassEngine classEngine) {
        StructureDef structureDef = (StructureDef)super.buildStructure(project, classEngine);
        MethodDef saveObjectMethod = this.formType == "Activity" ? new MethodDef("initiate", (StructureDefinition)structureDef, false) : new MethodDef("save", (StructureDefinition)structureDef, false);
        structureDef.addMethod((OperationDefinition)saveObjectMethod);
        return structureDef;
    }

    protected void addUpdateableCollectionOperations(AccessorDef accessorDef) {
        super.addUpdateableCollectionOperations(accessorDef);
    }

    protected void addTransactionalOperations(StructureDef structureDef) {
        super.addTransactionalOperations(structureDef);
    }

    protected Set getIgnoredClasses() {
        if (!this._setIgnoredClasses) {
            this.setIgnoredClass("oracle.binding.OperationBinding");
            this._setIgnoredClasses = true;
        }
        return super.getIgnoredClasses();
    }

    protected boolean ignoredMethod(MethodInfo mi) {
        return this._isJPA && !mi.type.equals("void") && Pattern.matches("queryByRange", mi.getName());
    }

    private Node getRuntimeSettings(ClassEngine engine) {
        XMLDocument xmlDoc = new XMLDocument();
        Element metaData = xmlDoc.createElementNS("http://xmlns.oracle.com/adfm/adapter/bean/bpm", "bpm-bean-definition");
        this.assignAttr(metaData, "BeanClass", engine.getClassName());
        this.assignAttr(metaData, "dataObject", this.dataObject);
        this.assignAttr(metaData, "element", this.elementName);
        this.assignAttr(metaData, "dataObjectNamespace", this.dataObjNS);
        this.assignAttr(metaData, "serviceType", this.serviceType);
        this.assignAttr(metaData, "formType", this.formType);
        this.assignAttr(metaData, "DataControlHandler", BeanDefinition.JPQLDataControlHandlerName);
        metaData.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://xmlns.oracle.com/adfm/adapter/bean/bpm");
        return metaData;
    }

    private void assignAttr(Element metaData, String key, String val) {
        if (ModelUtil.hasLength((String)val)) {
            metaData.setAttributeNS(null, key, val);
        }
    }

    private boolean isEJBSource(Object source) {
        EjbModuleEngine eme;
        if (source instanceof JavaSourceNode && (eme = EjbAppManager.getEjbModuleEngine((Project)Ide.getActiveProject())) != null) {
            EjbEngine ejbEngine = eme.getEjb30Engine((JavaSourceNode)source);
            return ejbEngine != null;
        }
        return false;
    }

    private boolean isWebServiceSource(Object source) {
        return false;
    }

    private boolean containsJPA(JavaClass javaClass) {
        Collection fs;
        if (javaClass != null && (fs = javaClass.getDeclaredFields()) != null) {
            for (JavaField f : fs) {
                if (!f.getResolvedType().getQualifiedName().startsWith("javax.persistence")) continue;
                return true;
            }
        }
        return false;
    }
}

