/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.datacontrol;

import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import oracle.adf.model.DataControl;
import oracle.adf.model.ManagedDataControl;
import oracle.adf.model.adapter.AdapterException;
import oracle.adf.model.adapter.bean.BeanDCInvocationHandler;
import oracle.adf.model.adapter.bean.JavaBeanDataControl;
import oracle.binding.DefinitionProviderDataControl;
import oracle.binding.OperationBinding;
import oracle.binding.TransactionalDataControl;
import oracle.binding.UpdateableDataControl;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.client.ICaseManagementServiceClient;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.datacontrol.beans.CaseManagementBean;
import oracle.bpm.datacontrol.definition.BPMBeanDefinition;
import oracle.bpm.datacontrol.service.ServiceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BPMBeanDataControl
extends JavaBeanDataControl
implements TransactionalDataControl,
ManagedDataControl {
    final String beanClass;
    private Object _dataProvider;
    private DefinitionProviderDataControl _definitionAdapter;
    private oracle.binding.DataControl _mAdapter;
    private oracle.binding.ManagedDataControl _managedAdapter;
    private TransactionalDataControl _txnAdapter;
    private UpdateableDataControl _updateAdapter;
    private String activityName;
    private String caseDefId;
    private String CASEID_PARAMETER_NAME = "caseId";
    private Object cmt = null;
    private String contextId = null;
    private String dataObjectName = null;
    private String dataObjectNamespace = null;
    private String element = null;
    private String formType = null;
    private String objectId;
    private String parentKey = null;
    private Object parentObject = null;
    private String serviceType = null;

    public BPMBeanDataControl(BPMBeanDefinition beanDefinition) {
        this.formType = (String)beanDefinition.getProperty("formType");
        this.serviceType = (String)beanDefinition.getProperty("serviceType");
        this.element = (String)beanDefinition.getProperty("element");
        this.dataObjectName = (String)beanDefinition.getProperty("dataObject");
        this.dataObjectNamespace = (String)beanDefinition.getProperty("dataObjectNamespace");
        this.beanClass = (String)beanDefinition.getProperty("BeanClass");
        this._dataProvider = this.loadProvider(this.beanClass);
        String handlerName = (String)beanDefinition.getProperty("DataControlHandler");
        this._dcHandler = this.getDCHandler(handlerName);
        this.setAccessMode((String)beanDefinition.getProperty("AccessMode"));
        this.setDataControlHandler(this._dcHandler);
        this.initDCProperties(this._dataProvider);
    }

    public String getName() {
        String name = null;
        if (this._mAdapter != null) {
            name = this._mAdapter.getName();
        }
        return name != null ? name : super.getName();
    }

    public void release() {
        if (this._mAdapter != null) {
            this._mAdapter.release();
        }
        super.release();
    }

    public Object getDataProvider() {
        Object provider = null;
        if (this._mAdapter != null) {
            provider = this._mAdapter.getDataProvider();
        }
        return provider != null ? provider : this._dataProvider;
    }

    public boolean invokeOperation(Map bindingContext, OperationBinding action) {
        Boolean result;
        Map params = action.getParamsMap();
        if (action.getName().equals("save")) {
            String caseId = this.objectId;
            Element data = ServiceFactory.setObject(this.beanClass, this.dataObjectName, this.dataObjectNamespace, this.element, this._dataProvider);
            if (data == null) {
                this._logger.warning("Failed to invoke operation Save. Case payload must not be null ");
                return true;
            }
            try {
                HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
                properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
                BPMServiceClientFactory factory = BPMServiceClientFactory.getInstance(properties, null, null);
                IWorkflowServiceClient m_wfsvc = factory.getWorkflowServiceClient();
                ITaskQueryService queryService = m_wfsvc.getTaskQueryService();
                IBPMContext context = this.contextId != null ? (IBPMContext)queryService.getWorkflowContext(this.contextId) : null;
                ICaseManagementServiceClient m_client = factory.getCaseManagementServiceClient();
                ICaseService caseService = m_client.getCaseService();
                CaseData caseData = new CaseData();
                caseData.setObjectName(this.dataObjectName);
                caseData.setObjectType(ICaseConstants.CaseObjectType.DATA.name());
                caseData.setCaseId(caseId);
                caseData.setData(XMLUtil.toString((Node)data));
                caseService.uploadCaseData(context, caseData);
            }
            catch (Exception e) {
                this._logger.warning("Failed to invoke operation Save ");
            }
            return true;
        }
        if (action.getName().equals("initiate")) {
            String caseId = this.objectId;
            CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
            String caseActivityDefinitionId = this.caseDefId;
            Element data = ServiceFactory.setObject(this.beanClass, this.dataObjectName, this.dataObjectNamespace, this.element, this._dataProvider);
            try {
                String commentStr;
                CaseManagementBean cmBean;
                HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
                properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
                BPMServiceClientFactory factory = BPMServiceClientFactory.getInstance(properties, null, null);
                IWorkflowServiceClient m_wfsvc = factory.getWorkflowServiceClient();
                ITaskQueryService queryService = m_wfsvc.getTaskQueryService();
                IBPMContext context = this.contextId != null ? (IBPMContext)queryService.getWorkflowContext(this.contextId) : null;
                ICaseManagementServiceClient m_client = factory.getCaseManagementServiceClient();
                ICaseService caseService = m_client.getCaseService();
                HashMap<String, String> payload = new HashMap<String, String>();
                payload.put("ActivityInputs", XMLUtil.toString((Node)data));
                Comment comment = null;
                FacesContext facesContext = FacesContext.getCurrentInstance();
                if (facesContext != null && (cmBean = (CaseManagementBean)this.getValueExpression("#{pageFlowScope.caseManagementBean}", CaseManagementBean.class)) != null && (commentStr = cmBean.getComment()) != null && commentStr != "") {
                    comment = new Comment();
                    comment.setCaseId(caseId);
                    comment.setObjectType(ICaseConstants.CaseInfo.COMMENT.name());
                    comment.setUpdatedDate(Calendar.getInstance());
                    comment.setUpdatedBy(context.getUser());
                    comment.setCaseObjectComment(commentStr);
                    comment.setIsSystemComment("F");
                }
                caseService.initiateCaseActivity(context, caseIdentifier, caseActivityDefinitionId, payload, comment);
            }
            catch (Exception e) {
                this._logger.fine("Failed to invoke operation initiate");
                return true;
            }
            return true;
        }
        Object handler = this.getDataControlHandler();
        if (handler != null && (result = (Boolean)new BeanDCInvocationHandler(handler).invokeMethod("invokeOperation", new Class[]{Map.class, OperationBinding.class}, new Object[]{bindingContext, action})) != null && result.booleanValue()) {
            return true;
        }
        if (this._mAdapter != null) {
            return this._mAdapter.invokeOperation(bindingContext, action);
        }
        return super.invokeOperation(bindingContext, action);
    }

    public void beginRequest(HashMap requestCtx) {
        if (this._managedAdapter != null) {
            this._managedAdapter.beginRequest(requestCtx);
        }
    }

    public void endRequest(HashMap requestCtx) {
        if (this._managedAdapter != null) {
            this._managedAdapter.endRequest(requestCtx);
        }
    }

    public boolean resetState() {
        if (this._managedAdapter != null) {
            return this._managedAdapter.resetState();
        }
        return false;
    }

    public Serializable createSnapshot() {
        if (this._managedAdapter != null && this._managedAdapter instanceof ManagedDataControl) {
            return ((ManagedDataControl)this._managedAdapter).createSnapshot();
        }
        return null;
    }

    public void restoreSnapshot(Serializable handle) {
        if (this._managedAdapter != null && this._managedAdapter instanceof ManagedDataControl) {
            ((ManagedDataControl)this._managedAdapter).restoreSnapshot(handle);
        }
    }

    public void removeSnapshot(Serializable handle) {
        if (this._managedAdapter != null && this._managedAdapter instanceof ManagedDataControl) {
            ((ManagedDataControl)this._managedAdapter).removeSnapshot(handle);
        }
    }

    public boolean isTransactionDirty() {
        if (this._txnAdapter != null) {
            return this._txnAdapter.isTransactionDirty();
        }
        return false;
    }

    public void rollbackTransaction() {
        if (this._txnAdapter != null) {
            this._txnAdapter.rollbackTransaction();
        }
    }

    public void commitTransaction() {
        if (this._txnAdapter != null) {
            this._txnAdapter.commitTransaction();
        }
    }

    public void release(int flags) {
        if (this._mAdapter instanceof DataControl) {
            ((DataControl)this._mAdapter).release(flags);
        }
    }

    public Object getValueExpression(String expression, Class objClass) {
        FacesContext facesContext;
        if (!expression.startsWith("#{")) {
            expression = "#{" + expression + "}";
        }
        if ((facesContext = FacesContext.getCurrentInstance()) == null) {
            return null;
        }
        ELContext elContext = facesContext.getELContext();
        ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(elContext, expression, objClass);
        return ve.getValue(elContext);
    }

    protected void initDCProperties(Object instance) {
        super.initDCProperties(instance);
        if (instance instanceof oracle.binding.DataControl) {
            oracle.binding.DataControl adapter;
            this._mAdapter = adapter = (oracle.binding.DataControl)instance;
            if (adapter instanceof TransactionalDataControl) {
                this._txnAdapter = (TransactionalDataControl)adapter;
            }
            if (adapter instanceof UpdateableDataControl) {
                this._updateAdapter = (UpdateableDataControl)adapter;
            }
            if (adapter instanceof oracle.binding.ManagedDataControl) {
                this._managedAdapter = (oracle.binding.ManagedDataControl)adapter;
            }
            if (adapter instanceof DefinitionProviderDataControl) {
                this._definitionAdapter = (DefinitionProviderDataControl)adapter;
            }
        }
    }

    private Object loadProvider(String beanClass) throws AdapterException {
        try {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Attempting to load provider : " + beanClass);
            }
            HttpServletRequest req = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
            this.objectId = req.getParameter("objId");
            if (req.getRemoteUser() == null || req.getParameter("activityDefinitionId") != null) {
                this.contextId = req.getParameter("bpmWorklistContext");
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Object Id is : " + this.objectId);
                this._logger.fine("context is : " + this.contextId);
            }
            if (req.getParameter("activityDefinitionId") != null) {
                this.caseDefId = req.getParameter("activityDefinitionId");
            }
            return ServiceFactory.getObject(beanClass, this.objectId, this.contextId, this.formType, this.dataObjectName, this.element, this.dataObjectNamespace);
        }
        catch (Exception e) {
            this._logger.severe("Failed to load the provider: " + beanClass);
            throw new AdapterException((Throwable)e);
        }
    }
}

