/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.util.swing;

import java.util.List;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.Configuration;
import oracle.bpm.configuration.ConfigurationManager;
import oracle.bpm.configuration.impl.swing.Utils;
import oracle.bpm.connector.msg.ConnectorMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;

class ConfigStepPanel
extends WizardStepPanel {
    private ConfigurationManager configManager_d;
    private TextField configNameTextField_d;
    private ComboBox configsComboBox_d;
    private String configWizardProperty;
    private RadioButton createNewRadioButton_d;
    private Msg instructions;
    private boolean newConfig_d = false;
    private ConfigType type_d;
    private RadioButton useExistingRadioButton_d;
    private boolean useSubType;

    public ConfigStepPanel(UiContainer parent, WizardStep wizardStep, ConfigType type) {
        this(parent, wizardStep, type, null);
    }

    public ConfigStepPanel(UiContainer parent, WizardStep wizardStep, ConfigType type, boolean useSubType) {
        this(parent, wizardStep, type, null, useSubType);
    }

    public ConfigStepPanel(UiContainer parent, WizardStep wizardStep, ConfigType type, Msg instructions) {
        this(parent, wizardStep, type, instructions, "configName");
    }

    public ConfigStepPanel(UiContainer parent, WizardStep wizardStep, ConfigType type, Msg instructions, boolean useSubType) {
        this(parent, wizardStep, type, instructions, "configName", useSubType);
    }

    public ConfigStepPanel(UiContainer parent, WizardStep wizardStep, ConfigType type, Msg instructions, String configWizardProperty) {
        this(parent, wizardStep, type, instructions, configWizardProperty, false);
    }

    public ConfigStepPanel(UiContainer parent, WizardStep wizardStep, ConfigType type, Msg instructions, String configWizardProperty, boolean useSubType) {
        super(parent, wizardStep);
        this.configWizardProperty = configWizardProperty;
        this.type_d = type;
        this.instructions = instructions;
        this.useSubType = useSubType;
        if (this.instructions == null) {
            this.instructions = ConnectorMsg.SELECT_CONFIGURATION_TEXTAREA;
        }
    }

    public String getConfigName() {
        if (!this.isNewConfig()) {
            Configuration conf = (Configuration)this.configsComboBox_d.getSelectedItem();
            if (conf != null) {
                return conf.getName();
            }
            return null;
        }
        return this.configNameTextField_d.getText();
    }

    public String getConfigWizardProperty() {
        return this.configWizardProperty;
    }

    public boolean isNewConfig() {
        return this.newConfig_d;
    }

    @Override
    public boolean validateInput() {
        String newConfigName = this.configNameTextField_d.getText();
        if (this.createNewRadioButton_d.isSelected()) {
            if (Str.isEmpty(newConfigName)) {
                MessageDialog.showError(ConnectorMsg.CONFIGURATION_NAME_REQUIRED);
                return false;
            }
            if (this.configManager_d.contains(newConfigName)) {
                MessageDialog.showError(ConnectorMsg.CONFIGURATION_ALREADY_EXISTS(newConfigName));
                return false;
            }
        } else if (this.configsComboBox_d.getSelectedItem() == null) {
            MessageDialog.showError(ConnectorMsg.CONFIGURATION_REQUIRED);
            return false;
        }
        return true;
    }

    public boolean isUseSubType() {
        return this.useSubType;
    }

    @Override
    protected UiComponent createCenterPage(UiContainer parent) {
        this.setPageTitle(ConnectorMsg.CONFIGURATION_MSG);
        this.setPageDesc(ConnectorMsg.CONFIGURATION_DESC_MSG);
        Panel centerPanel = new Panel(parent);
        String cols = "15dlu, 20dlu, pref:grow, pref:grow, 5dlu";
        String rows = "5dlu, pref, 20dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout formLayout = new FormLayout(cols, rows);
        CellConstraints cc = formLayout.createCellConstraints();
        centerPanel.setLayout(formLayout);
        this.configManager_d = (ConfigurationManager)this.getWizardStep().getWizard().getProperty("configurationManager");
        boolean reintrospecting = this.getWizardStep().getWizard().getProperty("reintrospecting") != null;
        List configurations = this.configManager_d.getConfigurations(this.getType(), this.isUseSubType());
        this.configsComboBox_d = Utils.createConfigurationsCombo(centerPanel, configurations);
        this.useExistingRadioButton_d = new RadioButton((UiContainer)centerPanel, ConnectorMsg.EXISTING_CONFIGURATION);
        this.createNewRadioButton_d = new RadioButton((UiContainer)centerPanel, ConnectorMsg.NEW_CONFIGURATION);
        this.createNewRadioButton_d.setEnabled(!this.configManager_d.isReadOnly());
        this.configNameTextField_d = new TextField((UiContainer)centerPanel, this.getNewConfigName());
        ButtonGroup<RadioButton> buttonGroup = new ButtonGroup<RadioButton>();
        buttonGroup.add(this.useExistingRadioButton_d);
        buttonGroup.add(this.createNewRadioButton_d);
        LabelMultiline msgTextArea = ConfigStepPanel.createTextArea((UiContainer)centerPanel, this.instructions);
        centerPanel.add(msgTextArea, cc.xyw(2, 2, 3));
        centerPanel.add(this.useExistingRadioButton_d, cc.xyw(2, 4, 3));
        centerPanel.add(this.configsComboBox_d, cc.xy(3, 6));
        centerPanel.add(this.createNewRadioButton_d, cc.xyw(2, 8, 3));
        centerPanel.add(this.configNameTextField_d, cc.xy(3, 10));
        this.useExistingRadioButton_d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigStepPanel.this.checkConfigCombo();
            }
        });
        this.createNewRadioButton_d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigStepPanel.this.checkConfigCombo();
            }
        });
        this.initFields();
        if (reintrospecting) {
            this.useExistingRadioButton_d.setEnabled(!reintrospecting);
            this.configsComboBox_d.setEnabled(!reintrospecting);
            this.createNewRadioButton_d.setEnabled(!reintrospecting);
            this.configNameTextField_d.setEnabled(!reintrospecting);
        }
        return centerPanel;
    }

    private String getNewConfigName() {
        return this.configManager_d.getNewConfigurationName(ConnectorMsg.NEW_CONFIGURATION_NAME.getString());
    }

    private ConfigType getType() {
        return this.type_d;
    }

    private String getWizardProperty(String key) {
        return (String)this.getWizardStep().getWizard().getProperty(key);
    }

    private void checkConfigCombo() {
        this.newConfig_d = this.createNewRadioButton_d.isSelected();
        this.configsComboBox_d.setEnabled(!this.newConfig_d);
        this.configNameTextField_d.setEnabled(this.newConfig_d);
    }

    private void initFields() {
        if (this.configsComboBox_d.getItemCount() != 0) {
            this.useExistingRadioButton_d.setSelected(true);
            String configName = this.getWizardProperty(this.getConfigWizardProperty());
            if (configName != null) {
                for (int i = 0; i < this.configsComboBox_d.getItemCount(); ++i) {
                    Configuration configuration = (Configuration)this.configsComboBox_d.getItemAt(i);
                    if (!configuration.getName().equals(configName)) continue;
                    this.configsComboBox_d.setSelectedItem(configuration);
                }
            }
        } else {
            this.useExistingRadioButton_d.setSelected(false);
            this.useExistingRadioButton_d.setEnabled(false);
            this.configNameTextField_d.setEnabled(false);
            this.createNewRadioButton_d.setSelected(true);
        }
        this.checkConfigCombo();
    }
}

