/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.ui.table.AbstractTableModel;

public class JarLibraryComponentModel
extends AbstractTableModel {
    private boolean enabled;
    private final String[] headers = new String[]{LibMsg.JCLEDITOR_JAR_NAME.getString()};
    private Map<String, Item> items;
    private List<Item> itemsList;
    static final int HEADER_JAR = 0;

    public JarLibraryComponentModel() {
        this.setEnabled(false);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class getColumnClass(int column) {
        Class<String> clazz = null;
        if (column <= this.getColumnCount()) {
            clazz = String.class;
        }
        return clazz;
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.headers[column];
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.rebuild();
        }
    }

    public void setExistence(String jar, boolean exists) {
        Item item = this.getItem(jar);
        if (item != null) {
            item.setExists(exists);
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getRowCount() {
        return this.itemsList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String object = null;
        Item item = this.getItem(rowIndex);
        if (item != null) {
            object = item.jar;
        }
        return object;
    }

    public boolean addItem(String jar, boolean exists) {
        if (!this.hasItem(jar)) {
            Item item = new Item(jar, exists);
            this.items.put(item.jar, item);
            if (this.enabled) {
                this.itemsList.add(item);
                this.rebuild();
            }
            return true;
        }
        return false;
    }

    public boolean exists(int index) {
        Item item = this.getItem(index);
        return item != null && item.exists;
    }

    public boolean hasItem(String jar) {
        return this.getItem(jar) != null;
    }

    public Item removeItem(String jar) {
        Item item = this.getItem(jar);
        if (item != null) {
            this.items.remove(jar);
            if (this.enabled) {
                this.itemsList.remove(item);
                this.rebuild();
            }
            return item;
        }
        return null;
    }

    public void reset() {
        this.itemsList = new ArrayList<Item>();
        this.items = new HashMap<String, Item>();
    }

    private Item getItem(String jar) {
        return this.items.get(jar);
    }

    private Item getItem(int index) {
        return this.enabled ? this.itemsList.get(index) : null;
    }

    private void rebuild() {
        this.itemsList.clear();
        this.itemsList.addAll(this.items.values());
        this.fireTableDataChanged();
    }

    static class Item {
        private boolean exists;
        private String jar;

        Item(String jar, boolean exists) {
            this.jar = jar;
            this.exists = exists;
        }

        public void setExists(boolean exists) {
            this.exists = exists;
        }

        public boolean getExists() {
            return this.exists;
        }

        public void setJar(String jar) {
            this.jar = jar;
        }

        public String getJar() {
            return this.jar;
        }

        public String toString() {
            return "jar: " + this.jar + " exists: " + this.exists;
        }
    }
}

