/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import oracle.bpm.configuration.editor.AbstractPoolConfigurationEditor;
import oracle.bpm.configuration.exception.InvalidConfigurationException;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.connector.impl.J2EEConfiguration;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.PasswordField;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.utils.Layout;

public class J2EEConfigurationEditor
extends AbstractPoolConfigurationEditor {
    private TextField contextField;
    private PasswordField credentialsField;
    private TextField principalField;
    private TextField transactionField;
    private TextField urlField;

    public J2EEConfigurationEditor(UiContainer parent) {
        super(parent);
        Panel panel = new Panel(this.tabbedPane);
        Panel advancedPanel = new Panel(this.tabbedPane);
        this.contextField = new TextField((UiContainer)panel, "com.sun.jndi.ldap.LdapCtxFactory");
        this.urlField = new TextField(panel);
        this.principalField = new TextField(panel);
        this.credentialsField = new PasswordField(panel);
        this.transactionField = new TextField(advancedPanel);
        DocumentListener documentListener = this.createDocumentListener();
        this.contextField.addDocumentListener(documentListener);
        this.urlField.addDocumentListener(documentListener);
        this.principalField.addDocumentListener(documentListener);
        this.credentialsField.addDocumentListener(documentListener);
        this.transactionField.addDocumentListener(documentListener);
        this.addTab(UIMsg.BASIC, this.getBasicPanel(panel));
        this.addTab(UIMsg.ADVANCED, this.getAdvancedPanel(advancedPanel));
        this.addPropertiesPanel();
        this.addRuntimeTab();
    }

    @Override
    public void setConfigurationEditorBean(ConfigurationEditorBean configurationEditorBean) {
        super.setConfigurationEditorBean(configurationEditorBean);
        J2EEConfiguration bean = (J2EEConfiguration)configurationEditorBean;
        this.databasePropertiesPanel.add(bean.getAdditionalProperties());
        this.databasePropertiesPanel.setDefaultProperties(bean.getDefaultConnectionProperties());
        this.contextField.setText(bean.getContextFactory());
        this.urlField.setText(bean.getUrl());
        this.principalField.setText(bean.getPrincipal());
        this.credentialsField.setText(bean.getCredentials());
        this.transactionField.setText(bean.getUserTransactionLookupName());
    }

    @Override
    public void synchronizeBean() {
        super.synchronizeBean();
        J2EEConfiguration bean = (J2EEConfiguration)this.getEditorBean();
        bean.setContextFactory(this.contextField.getText());
        bean.setUrl(this.urlField.getText());
        bean.setPrincipal(this.principalField.getText());
        bean.setCredentials(String.valueOf(this.credentialsField.getPassword()));
        bean.setUserTransactionLookupName(this.transactionField.getText());
        bean.getAdditionalProperties().clear();
        bean.setAdditionalProperties(this.databasePropertiesPanel.getVisualProperties());
    }

    @Override
    public void validateInput() throws InvalidConfigurationException {
        if ("".equals(this.contextField.getText().trim())) {
            throw InvalidConfigurationException.validationFailed(LibMsg.INITIAL_CONTEXT_FACTORY_EMPTY);
        }
        if ("".equals(this.urlField.getText().trim())) {
            throw InvalidConfigurationException.validationFailed(LibMsg.URL_EMPTY);
        }
    }

    private Panel getAdvancedPanel(Panel panel) {
        RelativeLayout layout = new RelativeLayout();
        panel.setLayout(layout);
        Label label = Label.create((UiContainer)panel, LibMsg.USER_TRANSACTION);
        panel.add(label, "label");
        panel.add(this.transactionField, "transactionField");
        Layout.fixToRoot(layout, "label", AttributeType.TOP, 5);
        Layout.fixToRoot(layout, "label", AttributeType.LEFT, 5);
        Layout.fixToRoot(layout, "transactionField", AttributeType.RIGHT, -5);
        Layout.fixToRoot(layout, "transactionField", AttributeType.LEFT, 5);
        Layout.fixToComp(layout, "transactionField", AttributeType.TOP, "label", AttributeType.BOTTOM, 5);
        return panel;
    }

    private UiComponent getBasicPanel(Panel panel) {
        RelativeLayout layout = new RelativeLayout();
        panel.setLayout(layout);
        Label factory = Label.create((UiContainer)panel, LibMsg.JNDI_CTX_FACTORY);
        Label url = Label.create((UiContainer)panel, LibMsg.JNDI_URL);
        Label principal = Label.create((UiContainer)panel, LibMsg.JNDI_PRINCIPAL);
        Label credentials = Label.create((UiContainer)panel, LibMsg.JNDI_CREDENTIALS);
        panel.add(factory, "factory");
        panel.add(url, "url");
        panel.add(principal, "principal");
        panel.add(credentials, "credentials");
        panel.add(this.contextField, "contextField");
        panel.add(this.urlField, "urlField");
        panel.add(this.principalField, "principalField");
        panel.add(this.credentialsField, "credentialsField");
        Layout.fixToComp(layout, "factory", AttributeType.VERTICAL_CENTER, "contextField");
        Layout.fixToRoot(layout, "factory", AttributeType.LEFT, 5);
        Layout.fixToRoot(layout, "contextField", AttributeType.TOP, 5);
        Layout.fixToRoot(layout, "contextField", AttributeType.RIGHT, -5);
        Layout.fixToComp(layout, "contextField", AttributeType.LEFT, "factory", AttributeType.RIGHT, 10);
        Layout.fixToRoot(layout, "url", AttributeType.LEFT, 5);
        Layout.fixToComp(layout, "url", AttributeType.VERTICAL_CENTER, "urlField");
        Layout.fixToComp(layout, "urlField", AttributeType.TOP, "contextField", AttributeType.BOTTOM, 10);
        Layout.fixToRoot(layout, "urlField", AttributeType.RIGHT, -5);
        Layout.fixToComp(layout, "urlField", AttributeType.LEFT, "url", AttributeType.RIGHT, 10);
        Layout.fixToRoot(layout, "principal", AttributeType.LEFT, 5);
        Layout.fixToComp(layout, "principal", AttributeType.VERTICAL_CENTER, "principalField");
        Layout.fixToComp(layout, "principalField", AttributeType.TOP, "urlField", AttributeType.BOTTOM, 10);
        Layout.fixToRoot(layout, "principalField", AttributeType.RIGHT, -5);
        Layout.fixToComp(layout, "principalField", AttributeType.LEFT, "principal", AttributeType.RIGHT, 10);
        Layout.fixToRoot(layout, "credentials", AttributeType.LEFT, 5);
        Layout.fixToComp(layout, "credentials", AttributeType.VERTICAL_CENTER, "credentialsField");
        Layout.fixToComp(layout, "credentialsField", AttributeType.TOP, "principalField", AttributeType.BOTTOM, 10);
        Layout.fixToRoot(layout, "credentialsField", AttributeType.RIGHT, -5);
        Layout.fixToComp(layout, "credentialsField", AttributeType.LEFT, "credentials", AttributeType.RIGHT, 10);
        Layout.fixToComp(layout, "url", AttributeType.WIDTH, "factory");
        Layout.fixToComp(layout, "principal", AttributeType.WIDTH, "factory");
        Layout.fixToComp(layout, "credentials", AttributeType.WIDTH, "factory");
        return panel;
    }
}

