/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.common.model.impl.io.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLVersionParser {
    public static Integer getVersion(@NotNull InputStream inputStream, @NotNull String versionElementUri, @NotNull String versionElementLocalName, @NotNull String versionAttribute) throws IOException {
        Integer result;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            XMLVersionParserHandler handler = new XMLVersionParserHandler(versionElementUri, versionElementLocalName, versionAttribute);
            saxParser.parse(inputStream, (DefaultHandler)handler);
            result = handler.getVersion();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return result;
    }

    private static class XMLVersionParserHandler
    extends DefaultHandler {
        private Integer version;
        private String versionAttribute;
        private String versionElementLocalName;
        private String versionElementUri;

        private XMLVersionParserHandler(@NotNull String versionElementUri, @NotNull String versionElementLocalName, @NotNull String versionAttribute) {
            this.versionElementUri = versionElementUri;
            this.versionElementLocalName = versionElementLocalName;
            this.versionAttribute = versionAttribute;
        }

        public Integer getVersion() {
            return this.version;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String version;
            if (localName != null && localName.equals(this.versionElementLocalName) && uri != null && uri.equals(this.versionElementUri) && (version = attributes.getValue(this.versionAttribute)) != null) {
                this.version = Integer.parseInt(version);
            }
        }
    }
}

