/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.common.model.impl.io.transformation;

import java.io.InputStream;
import java.util.SortedSet;
import oracle.bpm.common.model.impl.io.InputOutputStream;
import oracle.bpm.common.model.impl.io.transformation.Transformation;
import oracle.bpm.common.model.impl.io.transformation.TransformationException;
import oracle.bpm.io.StreamUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransformationManager {
    private SortedSet<Transformation> transformations;

    public TransformationManager(@NotNull SortedSet<Transformation> transformations) {
        this.transformations = transformations;
    }

    public InputStream transform(@NotNull InputStream inputStream, @Nullable Integer fromVersion, @NotNull Integer toVersion) throws TransformationException {
        InputStream inputStream2;
        try {
            InputOutputStream ioStream = new InputOutputStream();
            StreamUtils.copy(inputStream, ioStream);
            for (Transformation transformation : this.transformations) {
                if (fromVersion != null && transformation.getToVersion() <= fromVersion || transformation.getToVersion() > toVersion) continue;
                transformation.transform(ioStream);
            }
            inputStream2 = ioStream.getInputStream();
        }
        catch (Exception e) {
            try {
                throw TransformationException.createInvalidModel(e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
        }
        StreamUtils.close(inputStream);
        return inputStream2;
    }
}

