/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.common.model.impl.io.jaxb.normalization;

import java.util.SortedSet;
import oracle.bpm.common.model.impl.io.jaxb.normalization.Normalization;
import oracle.bpm.common.model.impl.io.jaxb.normalization.NormalizationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NormalizationManager<T> {
    private SortedSet<Normalization<T>> normalizations;

    public NormalizationManager(@NotNull SortedSet<Normalization<T>> normalizations) {
        this.normalizations = normalizations;
    }

    public void normalize(@NotNull T rootElement, @Nullable Integer fromVersion, @NotNull Integer toVersion) throws NormalizationException {
        try {
            for (Normalization normalization : this.normalizations) {
                if (fromVersion != null && normalization.getToVersion() <= fromVersion || normalization.getToVersion() > toVersion) continue;
                normalization.normalize(rootElement);
            }
        }
        catch (Exception e) {
            throw NormalizationException.createInvalidModel(e);
        }
    }
}

