/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.common.model.impl.io.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.impl.io.AbstractPersistenceManager;
import oracle.bpm.common.model.impl.io.jaxb.JAXBTranslator;
import oracle.bpm.common.model.impl.io.jaxb.normalization.Normalization;
import oracle.bpm.common.model.impl.io.jaxb.normalization.NormalizationManager;
import oracle.bpm.io.StreamUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJAXBPersistenceManager<E extends Entity, T>
extends AbstractPersistenceManager<E> {
    private NormalizationManager<T> normalizationManager;
    public static final String DEFAULT_ENCODING = "UTF-8";

    @Override
    public void save(@NotNull OutputStream stream, @NotNull E entity) throws IOException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(stream, DEFAULT_ENCODING);
            Marshaller marshaller = this.getMarshaller();
            marshaller.marshal(this.getTranslator().toJAXBObject(entity), (Writer)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    protected abstract JAXBTranslator<E, T> getTranslator();

    protected SortedSet<Normalization<T>> createNormalizationsSet() {
        return new TreeSet<Normalization<T>>();
    }

    @Override
    protected final E loadMigrated(@NotNull InputStream stream, @Nullable Integer fileVersion, @NotNull Integer currentVersion) throws IOException {
        E e;
        try {
            Object jaxbRootElement = this.getUnMarshaller().unmarshal(stream);
            if (fileVersion == null || currentVersion < fileVersion) {
                this.getNormalizationManager().normalize(jaxbRootElement, fileVersion, currentVersion);
            }
            e = this.getTranslator().toEntityObject(jaxbRootElement);
        }
        catch (Exception e2) {
            try {
                throw new IOException(e2);
            }
            catch (Throwable throwable) {
                StreamUtils.close(stream);
                throw throwable;
            }
        }
        StreamUtils.close(stream);
        return e;
    }

    private Unmarshaller getUnMarshaller() throws IOException {
        Class[] array = new Class[]{this.getTranslator().getJAXBFactory()};
        try {
            JAXBContext jaxbCtx = JAXBContext.newInstance((Class[])array);
            return jaxbCtx.createUnmarshaller();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private Marshaller getMarshaller() throws IOException {
        Class[] array = new Class[]{this.getTranslator().getJAXBFactory()};
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])array);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)DEFAULT_ENCODING);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            return marshaller;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private NormalizationManager<T> getNormalizationManager() {
        if (this.normalizationManager == null) {
            SortedSet<Normalization<T>> normalizationsSet = this.createNormalizationsSet();
            this.normalizationManager = new NormalizationManager<T>(normalizationsSet);
        }
        return this.normalizationManager;
    }
}

