/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.common.model.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.attributes.Attr;
import oracle.bpm.common.model.impl.EntityImpl;
import oracle.bpm.common.model.impl.events.EventManagerImpl;
import oracle.bpm.common.model.impl.transactions.ModelTransactionImpl;
import oracle.bpm.common.model.transactions.ModelTransaction;

public class TransactionManager {
    Map<TransactionInfo, Set<EventManagerImpl>> transactionsUnderCommit = new HashMap<TransactionInfo, Set<EventManagerImpl>>();
    private Map<EntityImpl, Queue<TransactionInfo>> transactions = new HashMap<EntityImpl, Queue<TransactionInfo>>();
    private static final TransactionManager INSTANCE = new TransactionManager();

    private TransactionManager() {
    }

    public static TransactionManager getInstance() {
        return INSTANCE;
    }

    public synchronized ModelTransaction beginTransaction(EntityImpl transactionRoot) {
        if (!this.isAvailableForTransaction(transactionRoot)) {
            return null;
        }
        LinkedList<TransactionInfo> transactionQueue = new LinkedList<TransactionInfo>();
        transactionQueue.add(new TransactionInfo(transactionRoot));
        this.transactions.put(transactionRoot, transactionQueue);
        return new ModelTransactionImpl(transactionRoot);
    }

    public synchronized ModelTransaction beginChildTransaction(EntityImpl newTransactionRoot) {
        return null;
    }

    public synchronized boolean isUnderCommit(Entity obj) {
        EntityImpl rootObject = this.getRootTransactionObject((EntityImpl)obj);
        for (TransactionInfo transaction : this.transactionsUnderCommit.keySet()) {
            if (!transaction.getRootObject().equals(rootObject)) continue;
            return true;
        }
        return false;
    }

    public void markAsEventBuffer(Entity changeSource, EventManagerImpl eventManager) {
        EntityImpl rootObject = this.getRootTransactionObject((EntityImpl)changeSource);
        for (TransactionInfo transaction : this.transactionsUnderCommit.keySet()) {
            if (!transaction.getRootObject().equals(rootObject)) continue;
            this.transactionsUnderCommit.get(transaction).add(eventManager);
        }
    }

    public synchronized boolean commit(EntityImpl rootObject) {
        Queue<TransactionInfo> queue = this.transactions.get(rootObject);
        boolean result = false;
        if (queue != null) {
            TransactionInfo commitInProgress = queue.poll();
            if (commitInProgress != null) {
                this.transactionsUnderCommit.put(commitInProgress, new HashSet());
                for (EntityImpl entityImpl : commitInProgress.getObjects()) {
                    Map<Attr<?>, Entity> changes = commitInProgress.getChanges(entityImpl);
                    for (Attr<?> f : changes.keySet()) {
                        entityImpl.setAttr(f, changes.get(f));
                    }
                }
                for (EventManagerImpl eventManagerImpl : this.transactionsUnderCommit.get(commitInProgress)) {
                    eventManagerImpl.releaseEvents();
                }
                result = true;
                this.transactionsUnderCommit.remove(commitInProgress);
            }
            if (queue.isEmpty()) {
                this.transactions.remove(rootObject);
            }
        }
        return result;
    }

    public synchronized boolean rollBack(EntityImpl rootObject) {
        Queue<TransactionInfo> queue = this.transactions.get(rootObject);
        boolean result = false;
        if (queue != null) {
            boolean bl = result = queue.poll() != null;
            if (queue.isEmpty()) {
                this.transactions.remove(rootObject);
            }
        }
        return result;
    }

    public synchronized boolean isInTransaction(EntityImpl obj) {
        return this.getRootTransactionObject(obj) != null;
    }

    public synchronized boolean isChangedObject(EntityImpl obj) {
        Queue<TransactionInfo> queue;
        EntityImpl rootObject = this.getRootTransactionObject(obj);
        if (rootObject != null && (queue = this.transactions.get(rootObject)) != null) {
            TransactionInfo transactionInfo = queue.peek();
            return transactionInfo != null && transactionInfo.isInTransaction(obj);
        }
        return false;
    }

    public synchronized EntityImpl getRootTransactionObject(EntityImpl obj) {
        for (EntityImpl transactionRoot : this.transactions.keySet()) {
            if (!obj.equals(transactionRoot) && !obj.isAncestor(transactionRoot)) continue;
            return transactionRoot;
        }
        return null;
    }

    public boolean setValue(EntityImpl obj, Attr<?> attr, Entity newValue) {
        TransactionInfo transactionInfo;
        Queue<TransactionInfo> queue;
        EntityImpl rootObject = this.getRootTransactionObject(obj);
        if (rootObject != null && (queue = this.transactions.get(rootObject)) != null && (transactionInfo = queue.peek()) != null) {
            if (!transactionInfo.isInTransaction(obj)) {
                transactionInfo.addEntity(obj);
            }
            transactionInfo.getChanges(obj).put(attr, newValue);
            return true;
        }
        return false;
    }

    public Entity getValue(EntityImpl obj, Attr<?> attr) {
        TransactionInfo transactionInfo;
        Queue<TransactionInfo> queue;
        EntityImpl rootObject = this.getRootTransactionObject(obj);
        if (rootObject != null && (queue = this.transactions.get(rootObject)) != null && (transactionInfo = queue.peek()) != null && transactionInfo.isInTransaction(obj)) {
            return transactionInfo.getChanges(obj).get(attr);
        }
        return null;
    }

    public Set<Attr<?>> getAttributesInTransaction(EntityImpl obj) {
        TransactionInfo transactionInfo;
        Queue<TransactionInfo> queue;
        EntityImpl rootObject = this.getRootTransactionObject(obj);
        if (rootObject != null && (queue = this.transactions.get(rootObject)) != null && (transactionInfo = queue.peek()) != null && transactionInfo.isInTransaction(obj)) {
            return transactionInfo.getChanges(obj).keySet();
        }
        return new HashSet();
    }

    private synchronized boolean isAvailableForTransaction(EntityImpl obj) {
        for (EntityImpl transactionRoot : this.transactions.keySet()) {
            if (!obj.equals(transactionRoot) && !obj.isAncestor(transactionRoot) && !transactionRoot.isAncestor(obj)) continue;
            return false;
        }
        return true;
    }

    private static class TransactionInfo {
        private Map<EntityImpl, Map<Attr<?>, Entity>> objects = new HashMap();
        private EntityImpl rootObject;
        private Map<Integer, List<EntityImpl>> treeInfo = new HashMap<Integer, List<EntityImpl>>();

        public TransactionInfo(EntityImpl rootObject) {
            this.rootObject = rootObject;
        }

        public Map<Attr<?>, Entity> getChanges(EntityImpl object) {
            return this.objects.get(object);
        }

        public boolean isInTransaction(EntityImpl object) {
            return this.objects.get(object) != null;
        }

        public void addEntity(EntityImpl object) {
            if (!this.isInTransaction(object)) {
                this.objects.put(object, new HashMap());
                int distance = this.getRootDistance(object);
                List<EntityImpl> list = this.treeInfo.get(distance);
                if (list == null) {
                    this.treeInfo.put(distance, new ArrayList());
                }
                this.treeInfo.get(distance).add(object);
            }
        }

        public List<EntityImpl> getObjects() {
            Object[] values = this.treeInfo.keySet().toArray(new Integer[0]);
            Arrays.sort(values);
            ArrayList<EntityImpl> result = new ArrayList<EntityImpl>();
            for (int i = 0; i < values.length; ++i) {
                result.addAll((Collection<EntityImpl>)this.treeInfo.get(values[i]));
            }
            return result;
        }

        public EntityImpl getRootObject() {
            return this.rootObject;
        }

        private int getRootDistance(EntityImpl object) {
            int result = 0;
            while (object != null) {
                if (object.equals(this.rootObject)) {
                    return result;
                }
                ++result;
                object = object.parentObject;
            }
            return result;
        }
    }
}

