/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.common.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.MetadataFactory;
import oracle.bpm.common.model.attributes.Attr;
import oracle.bpm.common.model.attributes.AttrType;
import oracle.bpm.common.model.attributes.ContentType;
import oracle.bpm.common.model.diff.DiffNode;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.common.model.impl.EntityImpl;
import oracle.bpm.common.model.impl.TransactionManager;
import oracle.bpm.common.model.impl.diff.DiffNodeImpl;
import oracle.bpm.common.model.impl.diff.DiffResult;
import oracle.bpm.common.model.impl.events.EventImpl;
import oracle.bpm.common.model.impl.wrappers.collections.MapEntity;

public class ModelMapCollection<K, V>
extends EntityImpl
implements Map<K, V> {
    private AttrType attrType;
    private static final InternalAttr<MapEntity> INTERNAL_ATTRIBUTE = new InternalAttr<MapEntity>(MapEntity.class);

    public ModelMapCollection() {
        super.setAttr(INTERNAL_ATTRIBUTE, new MapEntity(new LinkedHashMap()));
    }

    public void setAttrType(AttrType type) {
        this.attrType = type;
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.getMap().containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.getRightMap().containsValue(o);
    }

    @Override
    public Set<K> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.getRightMap().values();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        ArrayList<K> copy = new ArrayList<K>(this.keySet());
        for (Object key : copy) {
            this.remove(key);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getRightMap().entrySet();
    }

    @Override
    public V get(Object o) {
        return this.getRightMap().get(o);
    }

    @Override
    public V put(K k, V v) {
        V oldValue = this.get(k);
        EntityImpl value = this.getModelObject(v);
        if (this.attrType.equals((Object)AttrType.VALUE)) {
            value.setParent(this);
        }
        if (TransactionManager.getInstance().isInTransaction(this)) {
            if (!TransactionManager.getInstance().isChangedObject(this)) {
                super.setAttr(INTERNAL_ATTRIBUTE, new MapEntity((HashMap)this.getMap().clone()));
            }
            this.getMap().put(k, value);
        } else {
            this.getMap().put(k, value);
            if (this.parentObject != null) {
                this.parentObject.notifyChange(new EventImpl(oldValue == null ? EventType.ATTR_ADDED : EventType.ATTR_CHANGED, this, MetadataFactory.collectionKeyAttr(k.hashCode()), oldValue, v));
            }
        }
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        V oldValue = this.get(key);
        if (TransactionManager.getInstance().isInTransaction(this)) {
            if (!TransactionManager.getInstance().isChangedObject(this)) {
                super.setAttr(INTERNAL_ATTRIBUTE, new MapEntity((HashMap)this.getMap().clone()));
            }
            this.getMap().remove(key);
        } else {
            this.getMap().remove(key);
            if (oldValue != null && this.parentObject != null) {
                this.parentObject.notifyChange(new EventImpl(EventType.ATTR_REMOVED, this, MetadataFactory.collectionKeyAttr(key.hashCode()), oldValue, null));
            }
        }
        return oldValue;
    }

    @Override
    public <E> void setAttr(Attr<E> attr, E value) {
        if (attr.equals(INTERNAL_ATTRIBUTE)) {
            EntityImpl oldValue;
            HashMap localMap = this.getMap();
            if (localMap == null) {
                localMap = new HashMap();
            }
            HashMap newMap = ((MapEntity)value).getValue();
            Set both = localMap.keySet();
            both.retainAll(newMap.keySet());
            Set onlyInLocal = localMap.keySet();
            onlyInLocal.removeAll(newMap.keySet());
            Set onlyInNew = newMap.keySet();
            onlyInNew.removeAll(localMap.keySet());
            for (Object key : both) {
                if (((EntityImpl)localMap.get(key)).equals(newMap.get(key))) continue;
                oldValue = (EntityImpl)localMap.get(key);
                EntityImpl newValue = (EntityImpl)newMap.get(key);
                newValue.setParent(this);
                localMap.put(key, newValue);
                this.parentObject.notifyChange(new EventImpl(EventType.ATTR_CHANGED, this, MetadataFactory.collectionKeyAttr(key.hashCode()), this.getRealObject(oldValue), this.getRealObject(newValue)));
            }
            for (Object key : onlyInLocal) {
                oldValue = (EntityImpl)localMap.get(key);
                localMap.remove(key);
                this.parentObject.notifyChange(new EventImpl(EventType.ATTR_REMOVED, this, MetadataFactory.collectionKeyAttr(key.hashCode()), this.getRealObject(oldValue), null));
            }
            for (Object key : onlyInNew) {
                EntityImpl newValue = (EntityImpl)newMap.get(key);
                newValue.setParent(this);
                localMap.put(key, newValue);
                this.parentObject.notifyChange(new EventImpl(EventType.ATTR_ADDED, this, MetadataFactory.collectionKeyAttr(key.hashCode()), null, this.getRealObject(newValue)));
            }
        }
    }

    @Override
    protected DiffNodeImpl getDiff(Entity externalObject, List<DiffResult> alreadyProcessed) {
        DiffNodeImpl diff;
        ArrayList<DiffNode> featuresDiffs = new ArrayList<DiffNode>();
        ModelMapCollection external = (ModelMapCollection)externalObject;
        alreadyProcessed.add(new DiffResult(this, external));
        HashSet<K> both = new HashSet<K>(this.keySet());
        both.retainAll(external.keySet());
        HashSet<K> onlyInLocal = new HashSet<K>(this.keySet());
        onlyInLocal.removeAll(external.keySet());
        HashSet<K> onlyInNew = new HashSet<K>(external.keySet());
        onlyInNew.removeAll(this.keySet());
        for (Object key : both) {
            DiffNodeImpl childDiff;
            Entity externalFeature;
            EntityImpl localFeature = this.getMap().get(key);
            if (alreadyProcessed.contains(new DiffResult(localFeature, externalFeature = (Entity)external.getMap().get(key))) || (childDiff = localFeature.getDiff(externalFeature, alreadyProcessed)) == null) continue;
            childDiff.setAttribute(MetadataFactory.collectionKeyAttr(key.hashCode()));
            featuresDiffs.add(childDiff);
        }
        for (Object key : onlyInLocal) {
            diff = new DiffNodeImpl(this.getRealObject(this.getMap().get(key)), null);
            diff.setAttribute(MetadataFactory.collectionKeyAttr(key.hashCode()));
            featuresDiffs.add(diff);
        }
        for (Object key : onlyInNew) {
            diff = new DiffNodeImpl(null, this.getRealObject(external.getMap().get(key)));
            diff.setAttribute(MetadataFactory.collectionKeyAttr(key.hashCode()));
            featuresDiffs.add(diff);
        }
        if (!featuresDiffs.isEmpty()) {
            return new DiffNodeImpl(this, externalObject, featuresDiffs);
        }
        return null;
    }

    @Override
    protected EntityImpl clone(Map<Entity, EntityImpl> alreadyCloned) {
        ModelMapCollection<K, V> result = new ModelMapCollection<K, V>();
        alreadyCloned.put(this, result);
        for (Map.Entry<K, EntityImpl> entry : this.getMap().entrySet()) {
            EntityImpl clone = !alreadyCloned.containsKey(entry.getValue()) ? entry.getValue().clone(alreadyCloned) : alreadyCloned.get(entry.getValue());
            if (this.attrType.equals((Object)AttrType.VALUE)) {
                clone.setParent(result);
            }
            super.getMap().put(entry.getKey(), clone);
        }
        return result;
    }

    @Override
    void notifyChange(Event event) {
        Event clonedEvent = event.clone();
        Object key = null;
        for (Map.Entry<K, EntityImpl> entry : this.getMap().entrySet()) {
            if (!entry.getValue().equals(this.getModelObject(event.getNewValue()))) continue;
            key = entry.getKey();
            break;
        }
        if (key != null) {
            EventImpl result = new EventImpl(EventType.ATTR_CHANGED, this, MetadataFactory.collectionKeyAttr(key.hashCode()), event.getObject(), event.getObject(), clonedEvent);
            if (this.parentObject != null && this.attrType.equals((Object)AttrType.VALUE) && !event.containsObject(this)) {
                this.parentObject.notifyChange(result);
            }
            this.eventManager.notifyEventToListeners(result);
        }
    }

    private HashMap<K, EntityImpl> getMap() {
        MapEntity map = this.getAttr(INTERNAL_ATTRIBUTE);
        if (map != null) {
            return map.getValue();
        }
        return null;
    }

    private Map<K, V> getRightMap() {
        HashMap<K, Object> result = new HashMap<K, Object>();
        for (Map.Entry<K, EntityImpl> entry : this.getMap().entrySet()) {
            result.put(entry.getKey(), this.getRealObject(entry.getValue()));
        }
        return result;
    }

    private static class InternalAttr<K>
    implements Attr<K> {
        private Class<K> classType;
        private static final String ATTR_NAME = "map";

        public InternalAttr(Class<K> classType) {
            this.classType = classType;
        }

        @Override
        public String getId() {
            return ATTR_NAME;
        }

        @Override
        public AttrType getAttrType() {
            return AttrType.VALUE;
        }

        @Override
        public Class<K> getClassType() {
            return this.classType;
        }

        @Override
        public ContentType getContentType() {
            return ContentType.OBJECT;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }
}

