/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.common.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.ModelFactory;
import oracle.bpm.common.model.attributes.Attr;
import oracle.bpm.common.model.attributes.AttrType;
import oracle.bpm.common.model.attributes.ContentType;
import oracle.bpm.common.model.diff.DiffNode;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventListener;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.common.model.impl.TransactionManager;
import oracle.bpm.common.model.impl.diff.DiffNodeImpl;
import oracle.bpm.common.model.impl.diff.DiffResult;
import oracle.bpm.common.model.impl.events.EventImpl;
import oracle.bpm.common.model.impl.events.EventManagerImpl;
import oracle.bpm.common.model.impl.wrappers.ObjectEntity;
import oracle.bpm.common.model.transactions.ModelTransaction;

public abstract class EntityImpl
implements Entity {
    EventManagerImpl eventManager = new EventManagerImpl();
    EntityImpl parentObject = null;
    private Map<Attr<?>, EntityImpl> attributes = new HashMap();

    @Override
    public void addListener(EventListener listener, Attr<?> ... attributes) {
        this.eventManager.addListener(listener, attributes);
    }

    @Override
    public void removeListener(EventListener listener, Attr<?> ... attributes) {
        this.eventManager.removeListener(listener, attributes);
    }

    @Override
    public ModelTransaction beginTransaction() {
        return TransactionManager.getInstance().beginTransaction(this);
    }

    @Override
    public DiffNodeImpl getDiff(Entity externalObject) {
        return this.getDiff(externalObject, new ArrayList<DiffResult>());
    }

    @Override
    public Entity clone() {
        return this.clone(new HashMap<Entity, EntityImpl>());
    }

    protected <E> void setAttr(Attr<E> attr, E value) {
        EntityImpl oldValue = this.attributes.get(attr);
        EntityImpl newValue = this.getModelObject(value);
        if (newValue == null || oldValue == null || !newValue.equals(oldValue)) {
            if (newValue != null && (attr.getAttrType().equals((Object)AttrType.VALUE) || attr.getContentType().isCollection())) {
                newValue.setParent(this);
            }
            if (!TransactionManager.getInstance().setValue(this, attr, newValue)) {
                this.attributes.put(attr, newValue);
                if (!attr.getContentType().isCollection()) {
                    EventType eventType = oldValue != null ? EventType.ATTR_CHANGED : EventType.ATTR_ADDED;
                    EventImpl event = new EventImpl(eventType, this, attr, this.getRealObject(oldValue), this.getRealObject(newValue));
                    if (this.parentObject != null && attr.getAttrType().equals((Object)AttrType.VALUE)) {
                        this.parentObject.notifyChange(event);
                    }
                    this.eventManager.notifyEventToListeners(event);
                }
            }
        }
    }

    protected <E> E getAttr(Attr<E> attr) {
        return (E)this.getRealObject(this.getEntity(attr));
    }

    protected DiffNodeImpl getDiff(Entity targetObject, List<DiffResult> alreadyProcessed) {
        DiffNodeImpl diffNodeImpl;
        Object value;
        DiffNode diff;
        EntityImpl targetObjectImpl = (EntityImpl)targetObject;
        Set localAttributes = this.getAvailableAttributes();
        Set externalAttributes = targetObjectImpl.getAvailableAttributes();
        ArrayList<DiffNode> attributeDiffs = new ArrayList<DiffNode>();
        ArrayList attributesToRemove = new ArrayList();
        alreadyProcessed.add(new DiffResult(this, targetObjectImpl));
        for (Attr<?> attr : localAttributes) {
            if (!externalAttributes.contains(attr) && !attr.getContentType().isCollection()) continue;
            attributesToRemove.add(attr);
            diff = this.makeDiff(attr, targetObjectImpl, alreadyProcessed);
            if (diff == null) continue;
            attributeDiffs.add(diff);
        }
        for (Attr<?> attr : externalAttributes) {
            if (!attr.getContentType().isCollection() || attributesToRemove.contains(attr)) continue;
            attributesToRemove.add(attr);
            diff = this.makeDiff(attr, targetObjectImpl, alreadyProcessed);
            if (diff == null) continue;
            attributeDiffs.add(diff);
        }
        localAttributes.removeAll(attributesToRemove);
        externalAttributes.removeAll(attributesToRemove);
        for (Attr<?> attr : localAttributes) {
            value = this.getAttr(attr);
            if (attr.getContentType().equals((Object)ContentType.NATIVE_OBJECT) && attr.getDefaultValue().equals(value)) continue;
            diffNodeImpl = new DiffNodeImpl(value, null);
            diffNodeImpl.setAttribute(attr);
            attributeDiffs.add(diffNodeImpl);
        }
        for (Attr<?> attr : externalAttributes) {
            value = targetObjectImpl.getAttr(attr);
            if (attr.getContentType().equals((Object)ContentType.NATIVE_OBJECT) && attr.getDefaultValue().equals(value)) continue;
            diffNodeImpl = new DiffNodeImpl(null, value);
            diffNodeImpl.setAttribute(attr);
            attributeDiffs.add(diffNodeImpl);
        }
        if (!attributeDiffs.isEmpty()) {
            return new DiffNodeImpl(this, targetObject, attributeDiffs);
        }
        return null;
    }

    protected EntityImpl createNewInstance() {
        EntityImpl result = null;
        try {
            result = (EntityImpl)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected EntityImpl clone(Map<Entity, EntityImpl> alreadyCloned) {
        EntityImpl result = this.createNewInstance();
        if (result != null) {
            alreadyCloned.put(this, result);
            for (Map.Entry<Attr<?>, EntityImpl> entry : this.attributes.entrySet()) {
                EntityImpl object;
                if (!entry.getKey().getAttrType().equals((Object)AttrType.VALUE) || (object = !alreadyCloned.containsKey(entry.getValue()) ? entry.getValue().clone(alreadyCloned) : alreadyCloned.get(entry.getValue())) == null) continue;
                object.setParent(result);
                result.attributes.put(entry.getKey(), object);
            }
        }
        return result;
    }

    void setParent(EntityImpl parentObject) {
        this.parentObject = parentObject;
    }

    boolean isAncestor(EntityImpl obj) {
        if (this.parentObject == null) {
            return false;
        }
        return this.parentObject.equals(obj) || this.parentObject.isAncestor(obj);
    }

    void notifyChange(Event event) {
        Event clonedEvent = event.clone();
        Attr<?> attr = this.findAttr(event.getObject());
        EventImpl result = new EventImpl(EventType.ATTR_CHANGED, this, attr, event.getObject(), event.getObject(), clonedEvent);
        if (this.parentObject != null && !event.containsObject(this) && (attr.getAttrType().equals((Object)AttrType.VALUE) || clonedEvent.getChildEvent() == null && !attr.getContentType().isCollection())) {
            this.parentObject.notifyChange(result);
        }
        this.eventManager.notifyEventToListeners(result);
    }

    EntityImpl getModelObject(Object value) {
        if (value == null) {
            return null;
        }
        if (EntityImpl.class.isAssignableFrom(value.getClass())) {
            return (EntityImpl)value;
        }
        return new ObjectEntity(value);
    }

    Object getRealObject(Object object) {
        if (object != null && object instanceof ObjectEntity) {
            return ((ObjectEntity)object).getValue();
        }
        return object;
    }

    private Attr<?> findAttr(Entity obj) {
        for (Attr<?> attr : this.attributes.keySet()) {
            Entity value = this.attributes.get(attr);
            if (value == null || !value.equals(obj)) continue;
            return attr;
        }
        return null;
    }

    private DiffNode makeDiff(Attr<?> key, EntityImpl targetObjectImpl, List<DiffResult> alreadyProcessed) {
        EntityImpl localFeature = this.getEntity(key);
        EntityImpl externalFeature = targetObjectImpl.getEntity(key);
        if (key.getAttrType().equals((Object)AttrType.VALUE) && !alreadyProcessed.contains(new DiffResult(localFeature, externalFeature))) {
            DiffNodeImpl featureDiff = localFeature.getDiff(externalFeature, alreadyProcessed);
            if (featureDiff != null) {
                featureDiff.setAttribute(key);
            }
            return featureDiff;
        }
        return null;
    }

    private <E> EntityImpl getEntity(Attr<E> attr) {
        Entity obj = TransactionManager.getInstance().getValue(this, attr);
        if (obj == null) {
            obj = this.attributes.get(attr);
        }
        if (obj == null && attr.getContentType().isCollection()) {
            obj = ModelFactory.createCollectionAttr(attr);
            this.setAttr(attr, obj);
        } else if (obj == null && attr.getContentType().isNativeObject()) {
            obj = new ObjectEntity(attr.getDefaultValue());
        }
        return (EntityImpl)obj;
    }

    private Set<Attr<?>> getAvailableAttributes() {
        HashSet result = new HashSet();
        for (Attr<?> attr : this.attributes.keySet()) {
            if (this.attributes.get(attr) == null) continue;
            result.add(attr);
        }
        result.addAll(TransactionManager.getInstance().getAttributesInTransaction(this));
        return result;
    }
}

