/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.common.model;

import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.attributes.Attr;
import oracle.bpm.common.model.attributes.CollectionAttr;
import oracle.bpm.common.model.attributes.MapAttr;
import oracle.bpm.common.model.impl.ModelListCollection;
import oracle.bpm.common.model.impl.ModelMapCollection;

public class ModelFactory {
    public static Entity createCollectionAttr(Attr<?> attr) {
        switch (attr.getContentType()) {
            case LIST: {
                ModelListCollection<?> list = ModelFactory.createListCollection(((CollectionAttr)attr).getContentClassType());
                list.setAttrType(attr.getAttrType());
                return list;
            }
            case MAP: {
                ModelMapCollection<?, ?> map = ModelFactory.createMapCollection(((MapAttr)attr).getKeyClassType(), ((MapAttr)attr).getValueClassType());
                map.setAttrType(attr.getAttrType());
                return map;
            }
        }
        return null;
    }

    private static <E> ModelListCollection<E> createListCollection(Class<E> classType) {
        return new ModelListCollection();
    }

    private static <K, V> ModelMapCollection<K, V> createMapCollection(Class<K> keyClass, Class<V> valueClass) {
        return new ModelMapCollection();
    }
}

