/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.common.model;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.bpm.common.model.attributes.Attr;
import oracle.bpm.common.model.attributes.AttrType;
import oracle.bpm.common.model.attributes.CollectionAttr;
import oracle.bpm.common.model.attributes.ContentType;
import oracle.bpm.common.model.attributes.MapAttr;
import oracle.bpm.common.model.impl.ModelListCollection;
import oracle.bpm.common.model.impl.ModelMapCollection;

public class MetadataFactory {
    public static <T> Attr<T> valueAttr(Class<T> classType) {
        return new AttrImpl<T>(classType, AttrType.VALUE);
    }

    public static <T> Attr<T> refAttr(Class<T> classType) {
        return new AttrImpl<T>(classType, AttrType.REF);
    }

    public static <T> Attr<Collection<T>> valueCollectionAttr(Class<T> classType) {
        return new ListAttrImpl<Collection<T>>(ModelListCollection.class, AttrType.VALUE, classType);
    }

    public static <T> Attr<Collection<T>> reCollectionAttr(Class<T> classType) {
        return new ListAttrImpl<Collection<T>>(ModelListCollection.class, AttrType.REF, classType);
    }

    public static <T> Attr<List<T>> valueListAttr(Class<T> classType) {
        return new ListAttrImpl<List<T>>(ModelListCollection.class, AttrType.VALUE, classType);
    }

    public static <T> Attr<List<T>> refListAttr(Class<T> classType) {
        return new ListAttrImpl<List<T>>(ModelListCollection.class, AttrType.REF, classType);
    }

    public static <K, V> Attr<Map<K, V>> valueMapAttr(Class<K> keyClassType, Class<V> valueClassType) {
        return new MapAttrImpl<Map<K, V>>(ModelMapCollection.class, AttrType.VALUE, keyClassType, valueClassType);
    }

    public static <K, V> Attr<Map<K, V>> refMapAttr(Class<K> keyClassType, Class<V> valueClassType) {
        return new MapAttrImpl<Map<K, V>>(ModelMapCollection.class, AttrType.REF, keyClassType, valueClassType);
    }

    public static Attr<Integer> collectionKeyAttr(int id) {
        AttrImpl<Integer> result = new AttrImpl<Integer>(Integer.class, AttrType.VALUE);
        result.setId(String.valueOf(id));
        return result;
    }

    public static void init(Class<?> objectClass) {
        for (Field f : objectClass.getDeclaredFields()) {
            try {
                Object o = f.get(objectClass);
                if (!(o instanceof AttrImpl)) continue;
                AttrImpl attr = (AttrImpl)o;
                attr.setId(f.getName());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private static class MapAttrImpl<T>
    extends AttrImpl<T>
    implements MapAttr<T> {
        private Class<?> keyClassType;
        private Class<?> valueClassType;

        public MapAttrImpl(Class<T> classType, AttrType contentType, Class<?> keyClass, Class<?> valueClass) {
            super(classType, contentType);
            this.keyClassType = keyClass;
            this.valueClassType = valueClass;
        }

        @Override
        public Class<?> getKeyClassType() {
            return this.keyClassType;
        }

        @Override
        public Class<?> getValueClassType() {
            return this.valueClassType;
        }

        @Override
        public ContentType getContentType() {
            return ContentType.MAP;
        }
    }

    private static class ListAttrImpl<T>
    extends AttrImpl<T>
    implements CollectionAttr<T> {
        private Class<?> contentClassType;

        public ListAttrImpl(Class<T> classType, AttrType attrType, Class<?> contentClass) {
            super(classType, attrType);
            this.contentClassType = contentClass;
        }

        @Override
        public Class<?> getContentClassType() {
            return this.contentClassType;
        }

        @Override
        public ContentType getContentType() {
            return ContentType.LIST;
        }
    }

    public static class AttrImpl<T>
    implements Attr<T> {
        private AttrType attrType;
        private Class<T> classType;
        private boolean forceNonNative;
        private String id;

        public AttrImpl(Class<T> classType, AttrType attrType) {
            this(classType, attrType, false);
        }

        public AttrImpl(Class<T> classType, AttrType attrType, boolean forceNonNative) {
            this.classType = classType;
            this.attrType = attrType;
            this.forceNonNative = forceNonNative;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public AttrType getAttrType() {
            return this.attrType;
        }

        @Override
        public Class<T> getClassType() {
            return this.classType;
        }

        @Override
        public ContentType getContentType() {
            if (!this.forceNonNative && this.hasNativeObject()) {
                return ContentType.NATIVE_OBJECT;
            }
            return ContentType.OBJECT;
        }

        @Override
        public Object getDefaultValue() {
            if (this.hasNativeObject()) {
                if (Number.class.isAssignableFrom(this.getClassType())) {
                    if (this.getClassType().equals(Double.class)) {
                        return 0.0;
                    }
                    return 0;
                }
                if (this.getClassType().equals(Boolean.class)) {
                    return false;
                }
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            AttrImpl test = (AttrImpl)obj;
            if (test.getId() != null && this.getId() != null) {
                return test.getId().equals(this.getId());
            }
            throw new RuntimeException("Attribute without ID. Please check if every METADATA class calls the static init. Attribute type:" + test.getClassType().toString());
        }

        public int hashCode() {
            if (this.getId() == null) {
                throw new RuntimeException("Attribute without ID. Please check if every METADATA class calls the static init.Attribute type:" + this.getClassType().toString());
            }
            return this.getId().hashCode();
        }

        private boolean hasNativeObject() {
            return Number.class.isAssignableFrom(this.getClassType()) || this.getClassType().equals(Boolean.class);
        }
    }
}

