/*
 * Decompiled with CFR 0.152.
 */
package fuego.boot;

import fuego.boot.ByteArray;
import fuego.boot.CachedResource;
import fuego.boot.ClassCache;

public final class SharedBufferCachedResource
extends CachedResource {
    private final short nameLength;
    private final int nameOffset;
    private final short packageLength;
    private final int packageOffset;
    private final byte[] sharedBuffered;

    public SharedBufferCachedResource(ClassCache classCache, byte[] bytes, int packageOffset, short packageLength, int nameOffset, short nameLength, int codeSourceIndex, int byteCodeOffset, int byteCodeLength, int hashCode) {
        super(classCache, codeSourceIndex, byteCodeOffset, byteCodeLength);
        this.sharedBuffered = bytes;
        this.packageOffset = packageOffset;
        this.packageLength = packageLength;
        this.nameOffset = nameOffset;
        this.nameLength = nameLength;
        this.isClass = true;
        for (int i = 0; i < nameLength; ++i) {
            byte b = bytes[nameOffset + i];
            if (b != 46) continue;
            this.isClass = false;
        }
        this.hashcode = hashCode;
    }

    @Override
    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = this == o;
        if (!result) {
            if (o instanceof String) {
                int i;
                String str = (String)o;
                if (str.length() != this.length()) {
                    return false;
                }
                int strIndex = 0;
                int bufferOffset = this.packageOffset;
                if (this.packageLength > 0) {
                    for (i = 0; i < this.packageLength; ++i) {
                        if ((byte)str.charAt(strIndex++) == this.sharedBuffered[bufferOffset++]) continue;
                        return false;
                    }
                    if (str.charAt(strIndex++) != '.') {
                        return false;
                    }
                }
                bufferOffset = this.nameOffset;
                for (i = 0; i < this.nameLength; ++i) {
                    if ((byte)str.charAt(strIndex++) == this.sharedBuffered[bufferOffset++]) continue;
                    return false;
                }
                result = true;
            } else if (o instanceof CachedResource) {
                CachedResource that = (CachedResource)o;
                result = ByteArray.equals(this.getPkgBytes(), this.getPackageOffset(), this.getPackageLength(), that.getPkgBytes(), that.getPackageOffset(), that.getPackageLength());
                if (result) {
                    result = ByteArray.equals(this.getNameBytes(), this.getNameOffset(), this.getNameLength(), that.getNameBytes(), that.getNameOffset(), that.getNameLength());
                }
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    @Override
    protected char getNameCharAt(int i) {
        if (i < 0 || i >= this.nameLength) {
            throw new IndexOutOfBoundsException();
        }
        return (char)(this.sharedBuffered[this.nameOffset + i] & 0xFF);
    }

    @Override
    protected char getPackageCharAt(int i) {
        if (i < 0 || i >= this.packageLength) {
            throw new IndexOutOfBoundsException();
        }
        return (char)(this.sharedBuffered[this.packageOffset + i] & 0xFF);
    }

    @Override
    protected void calculateHash() {
        this.hashcode = ByteArray.computeHashCode(this.sharedBuffered, this.packageOffset, this.packageLength, 0);
        this.hashcode = ByteArray.computeHashCode((byte)46, this.hashcode);
        this.hashcode = ByteArray.computeHashCode(this.sharedBuffered, this.nameOffset, this.nameLength, this.hashcode);
    }

    @Override
    byte[] getNameBytes() {
        return this.sharedBuffered;
    }

    @Override
    int getNameLength() {
        return this.nameLength;
    }

    @Override
    int getNameOffset() {
        return this.nameOffset;
    }

    @Override
    int getPackageLength() {
        return this.packageLength;
    }

    @Override
    int getPackageOffset() {
        return this.packageOffset;
    }

    int length() {
        int result = this.nameLength;
        if (this.packageLength != 0) {
            result += this.packageLength + 1;
        }
        return result;
    }

    @Override
    byte[] getPkgBytes() {
        return this.sharedBuffered;
    }
}

