/*
 * Decompiled with CFR 0.152.
 */
package fuego.boot;

import fuego.boot.BaseClassLoader;
import fuego.boot.BootHashSet;
import fuego.boot.BuildCacheProgressMonitor;
import fuego.boot.CacheURLStreamHandler;
import fuego.boot.ClassCache;
import fuego.boot.ClassCacheWriteException;
import fuego.boot.ClassHelper;
import fuego.boot.ClassPath;
import fuego.boot.EclipseClasspath;
import fuego.boot.MultiplexingOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public final class Loader {
    private String applicationPrefix;
    private String[] arguments;
    private BootData bootData = null;
    private String cacheName;
    private boolean checkCache;
    private ClassLoader classLoader;
    private String classPath;
    private boolean debug;
    private String eclipseSearchPath;
    private final Object exitLock = new Object();
    private boolean forceRebuild = false;
    private boolean generateCache;
    private String initialCP;
    private final long initialTime;
    private String jarFile;
    private long lastMemory;
    private long lastTime;
    private String mainClass;
    private final Properties manifestProperties;
    private ClassLoader parentClassLoader;
    private boolean pluginsLoaded = false;
    private boolean restart;
    private int restartParentPort;
    private boolean specifyClass;
    private BufferedReader stdin;
    private boolean stepping;
    private File systemDir;
    private boolean useBuiltCache;
    private boolean usingCache = true;
    private boolean verbose;
    private static File installationDir;
    private static final String ECLIPSE_OPTION = "-eclipse";
    private static final String BASE_DIR_OPTION = "-basedir";
    private static final String VERBOSE_OPTION = "-verbose";
    private static final String CONSOLE_OPTION = "-console";
    private static final String DEBUG_OPTION = "-debug";
    private static final String CLASS_OPTION = "-class";
    private static final String NO_CACHE_OPTION = "-no-cache";
    private static final String CHECK_CACHE_OPTION = "-check-cache";
    private static final String GENERATE_CACHE_OPTION = "-gen-cache";
    private static Integer initType;
    public static final Integer BIG_JAVA_CLIENT;
    public static final Integer LAUNCHED_APPLICATION;
    private static final String RESTART_OPTION = "-restart";
    public static final String USE_BUILT_CACHE = "-use-built-cache";
    public static final String APPLICATION_NAME_OPTION = "-app";
    public static final String MAIN_METHOD = "main";
    public static final String FUEGO_STUDIO_NAME = "Studio";
    public static final String FUEGO_EXPRESS_NAME = "Express";
    public static final String FUEGO_ADMCENTER_NAME = "AdmCenter";
    private static final String[] defaultNames;
    private static final BuildCacheProgressMonitor BASIC_MONITOR;
    private static final String BOOT_JAR = "fuego.boot.jar";
    private static final String NEW_CACHE = "new";
    public static final String FUEGOTECH_PLUGIN = "Fuego Plug-in";
    private static final String FUEGO_DATABASE_PLUGIN = "Fuego Database Plug-in";
    public static final String FUEGOTECH_BOOT_PLUGIN = "Fuego Boot Plug-in";
    public static final String FUEGO_BLOCK = "FuegoBlock";
    private static final String SER = ".ser";
    static final String CLASS_CACHE = "ClassCache";
    private static final String DATA_EXT = ".data";
    static final String INDEX_EXT = ".index";
    public static final String[] LANGUAGES_LIST;
    private static final Map<ClassLoader, String> classloaders;
    public static final String APPLICATION_ID = "application.id";
    private static final String CLASS_LIBRARY = "classLibrary";
    private static Loader rootLoader;
    private static boolean systemClassLoader;
    private static boolean logRunningTime;
    private static final String FUEGO_BOOT_PREFIX = "X-fuego-";
    private static BuildCacheProgressMonitor progressMonitor;
    private static ResourceBundle resources;
    private static final char[] blanks;
    private static Properties buildInfo;

    public Loader() {
        this(new String[0]);
        this.usingCache = false;
    }

    private Loader(String[] args) {
        this.arguments = args;
        this.manifestProperties = new Properties();
        this.initialCP = "";
        this.lastTime = this.initialTime = System.currentTimeMillis();
        if (rootLoader == null) {
            rootLoader = this;
        }
        this.installAsianDateFormats();
        CacheURLStreamHandler.install();
    }

    public static void setInstallationDir(File installationDir) {
        Loader.installationDir = installationDir;
    }

    public static void addToClassPath(File[] files) {
        ClassPath.addFilesToClassPath(files);
    }

    public static void addToClassPathFrom(File from) {
        File[] lib = ClassPath.loadExternalClassPathFrom(from);
        ClassPath.addFilesToClassPath(lib);
    }

    public static void addToExtClassPath(String subDir) {
        File file = new File(ClassPath.getExt(), subDir);
        File[] cp = ClassPath.loadExternalClassPathFrom(file);
        ClassPath.addFilesToClassPath(cp);
    }

    public static Loader createLoader(File systemDir, File[] classPath, boolean cached, ClassLoader parent) throws IOException {
        return Loader.createLoader(systemDir, classPath, cached, parent, null);
    }

    public static Loader createLoaderForAnt(File baseDir, String jarName, File[] extraClassPath, Map<String, String> properties, ClassLoader parent) throws IOException {
        assert (baseDir != null && baseDir.exists() && baseDir.isDirectory()) : "Invalid baseDir [" + baseDir + "]";
        ClassPath.setBaseDir(baseDir);
        File jar = jarName == null ? null : new File(ClassPath.getLib(), jarName);
        Properties bootProperties = new Properties();
        bootProperties.putAll(properties);
        bootProperties.setProperty("fuego.basedir", baseDir.getPath());
        if (System.getProperty("fuego.boot.console") == null) {
            System.setProperty("fuego.boot.console", "true");
        }
        bootProperties.setProperty("skip.fuego.boot.jar", "true");
        Loader loader = new Loader();
        loader.setProperties(bootProperties);
        if ("true".equals(bootProperties.getProperty("fuego.boot.verbose"))) {
            loader.verbose = true;
        }
        loader.createClassLoaderForExternalUsage(jar, extraClassPath, null, parent);
        return loader;
    }

    public static Loader createSimpleLoader(File[] classPath, ClassLoader parent) throws IOException {
        Loader loader = new Loader();
        loader.createClassLoader(classPath, parent);
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(int i) {
        if (rootLoader != null) {
            rootLoader.closeBaseClassLoader();
            if (Loader.rootLoader.exitLock != null) {
                Object object = Loader.rootLoader.exitLock;
                synchronized (object) {
                    Loader.rootLoader.exitLock.notify();
                    return;
                }
            }
        }
        System.exit(i);
    }

    public static File getBaseDir(Class clazz) {
        return ClassPath.getBaseDir(clazz);
    }

    public static File getBootJarFile() {
        try {
            return new File(ClassPath.getLib(), BOOT_JAR).getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Set getClassPathFromManifest(Manifest manifest) {
        return ClassPath.getClassPathFromManifest(manifest);
    }

    public static File[] getFuegoBlocks() {
        File[] result;
        if (rootLoader == null || Loader.rootLoader.bootData == null) {
            result = new File[]{};
        } else {
            Set<File> fuegoBlocks = Loader.rootLoader.bootData.fuegoBlocks;
            result = new File[fuegoBlocks.size()];
            fuegoBlocks.toArray(result);
        }
        return result;
    }

    public static String[] getJarsNotInCache() {
        return ClassCache.NEVER;
    }

    public static Loader getLoader(Class baseClass) {
        if (Loader.isSystemClassLoader()) {
            return Loader.getRootLoader();
        }
        BaseClassLoader cl = ClassPath.findBaseClassLoader(baseClass.getClassLoader());
        if (cl == null) {
            cl = ClassPath.findBaseClassLoader(Thread.currentThread().getContextClassLoader());
        }
        return cl != null ? cl.getClassCache().getLoader() : null;
    }

    public static Set getPluginsFromManifest(Manifest manifest) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String vendor = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        String title = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        if (FUEGOTECH_PLUGIN.equals(vendor) && title != null) {
            result.add(title);
        }
        for (Attributes attributes : manifest.getEntries().values()) {
            vendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            title = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            if (!FUEGOTECH_PLUGIN.equals(vendor) || title == null) continue;
            result.add(title);
        }
        return result;
    }

    public static Map getRegisteredClassLoaders() {
        return classloaders;
    }

    public static Loader getRootLoader() {
        if (rootLoader == null) {
            rootLoader = new Loader();
        }
        return rootLoader;
    }

    public static void initClassPathPlugins() {
        if (Loader.arePluginsLoaded()) {
            return;
        }
        initType = BIG_JAVA_CLIENT;
        BootData bootData = Loader.loadClasspathPlugins();
        assert (bootData != null);
        Loader.getRootLoader().pluginsLoaded = bootData.loadPlugins();
    }

    public static void initPlugins(Class parent) {
        if (!Loader.arePluginsLoaded()) {
            int index;
            ClassLoader classLoader = parent.getClassLoader();
            String classFileName = parent.getName().replace('.', '/') + ".class";
            URL url = classLoader.getResource(classFileName);
            String path = url.getPath();
            Loader.getRootLoader().initEnv();
            if (path.startsWith("file:")) {
                int strip = 5;
                if (path.indexOf(58, strip) != -1) {
                    boolean slash;
                    boolean bl = slash = path.charAt(strip) == '/';
                    if (slash) {
                        ++strip;
                    }
                }
                path = path.substring(strip);
            }
            if ((index = path.indexOf(33)) != -1) {
                path = path.substring(0, index);
            }
            try {
                String canonicalPath = new File(path).getParentFile().getCanonicalPath();
                Loader.initPlugins(canonicalPath, classLoader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean initPlugins(String dirName, ClassLoader parent) throws FileNotFoundException {
        if (Loader.arePluginsLoaded()) {
            return true;
        }
        BootData bootData = Loader.getRootBootData();
        if (bootData == null) {
            if (Loader.isBigClientJar()) {
                bootData = Loader.loadClasspathPlugins();
            } else {
                File pluginsDir = new File(dirName);
                if (!pluginsDir.exists() || !pluginsDir.isDirectory()) {
                    throw new FileNotFoundException(dirName);
                }
                try {
                    bootData = (BootData)Loader.readGlobalCachedObject(pluginsDir, "bootData", parent);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                }
                if (bootData == null) {
                    File[] files;
                    bootData = Loader.getRootLoader().getBootData();
                    for (File file : files = pluginsDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".jar") || name.endsWith(".zip");
                        }
                    })) {
                        JarFile jar = null;
                        try {
                            jar = new JarFile(file);
                            Manifest manifest = jar.getManifest();
                            if (manifest == null) continue;
                            Loader.getRootLoader().registerJarInBootData(file, manifest);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        finally {
                            if (jar != null) {
                                try {
                                    jar.close();
                                }
                                catch (IOException ignore) {}
                            }
                        }
                    }
                }
            }
        }
        assert (bootData != null);
        Loader.getRootLoader().pluginsLoaded = bootData.loadPlugins();
        return Loader.getRootLoader().pluginsLoaded;
    }

    public static boolean isBigClientJar() {
        Loader.checkInitializationType();
        return initType.equals(BIG_JAVA_CLIENT);
    }

    public static boolean isLaunchedApplication() {
        Loader.checkInitializationType();
        return initType.equals(LAUNCHED_APPLICATION);
    }

    public static boolean isSystemClassLoader() {
        return systemClassLoader;
    }

    public static boolean isUsingCache() {
        return Loader.getRootLoader().usingCache;
    }

    public static void main(String[] args) {
        Loader loader = new Loader(args);
        loader.initEnv();
        loader.run();
    }

    public static void prompt(String prompt) {
        Loader.getRootLoader().input(prompt);
    }

    public static void rebuildCache(BuildCacheProgressMonitor monitor) throws IOException {
        Loader loader = Loader.getRootLoader();
        loader.setForceRebuild(true);
        BootData bootData = loader.loadBootData();
        Set<File> classSet = bootData.getClassSet();
        ArrayList<ClassHelper> helpers = new ArrayList<ClassHelper>();
        byte[] digest = loader.initClassPath(loader.buildClassPath(classSet), helpers);
        ClassCache classCache = new ClassCache(loader, helpers);
        File file = loader.cacheFile(CLASS_CACHE, NEW_CACHE);
        long cacheFileSize = classCache.buildCache(file, classSet, monitor);
        try {
            File cacheIndex = loader.cacheFile(CLASS_CACHE, INDEX_EXT);
            classCache.writeClassCache(digest, cacheFileSize, cacheIndex);
        }
        catch (ClassCacheWriteException e) {
            file.delete();
            throw e.getIOException();
        }
    }

    public static void registerClassLoader(ClassLoader loader) {
        while (loader != null && !classloaders.containsKey(loader)) {
            String text = loader.toString();
            if (text != null && text.startsWith("sun.misc.Launcher$App")) {
                text = "Sun App ClassLoader";
            } else if (text != null && text.startsWith("sun.misc.Launcher$Ext")) {
                text = "Sun Ext ClassLoader";
            }
            classloaders.put(loader, text);
            loader = loader.getParent();
        }
    }

    public static void restart(String applicationPath) throws IOException {
        InetAddress bindAddr = InetAddress.getLocalHost();
        ServerSocket server = new ServerSocket(0, 2, bindAddr);
        System.out.println("Launch application:start");
        String port = String.valueOf(server.getLocalPort());
        Runtime.getRuntime().exec(new String[]{applicationPath, RESTART_OPTION, port});
        System.out.println("Port: " + port);
        System.out.println("Launch application:end");
        System.out.println("Waiting for connection");
        Socket socket = server.accept();
        InputStream is = socket.getInputStream();
        byte[] temp = new byte[30];
        int c = is.read(temp);
        System.out.println("Receive message - " + c);
        System.exit(33);
    }

    public static int runApplication(File baseDir, String jarFile, String mainClass, String[] args, ClassLoader parentClassLoader) {
        boolean ok;
        ClassPath.setBaseDir(baseDir);
        Loader loader = new Loader(args);
        initType = LAUNCHED_APPLICATION;
        try {
            loader.jarFile = jarFile;
            loader.parentClassLoader = parentClassLoader;
            loader.mainClass = mainClass != null ? mainClass : loader.loadMainClassFromJar(jarFile);
            loader.initEnv();
            ok = loader.runAsMain();
        }
        catch (Throwable e) {
            e.printStackTrace();
            loader.dumpBuildInfo();
            return -1;
        }
        if (ok) {
            loader.waitForLoaderExit();
            return 0;
        }
        return 1;
    }

    public static void setBaseDir(File basedir) {
        ClassPath.setBaseDir(basedir);
    }

    public static void setClassPathBaseDir(File basedir) {
        ClassPath.setBaseDir(basedir);
    }

    public static String showRunningTime(String step, boolean before) {
        return rootLoader == null ? null : rootLoader.showStats(step, before);
    }

    public static void step() {
        Loader loader = Loader.getRootLoader();
        if (loader.stepping) {
            loader.input(":");
        }
    }

    public static File getInstallationDir() {
        if (installationDir == null) {
            installationDir = ClassPath.getBaseDir();
        }
        return installationDir;
    }

    public void closeBaseClassLoader() {
        if (this.classLoader != null && this.classLoader instanceof BaseClassLoader) {
            ((BaseClassLoader)this.classLoader).close();
        }
        this.classLoader = null;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setForceRebuild(boolean forceRebuild) {
        this.forceRebuild = forceRebuild;
    }

    public String toString() {
        return this.bootData.toString();
    }

    static void classNotFound(String className, IOException e) throws ClassNotFoundException {
        String msg = "Boot Loader: Unable to resolve: " + className;
        if (e == null) {
            throw new ClassNotFoundException(msg);
        }
        throw new ClassNotFoundException(msg, e);
    }

    static String getString(String key) {
        String s = key;
        try {
            if (resources == null) {
                resources = ResourceBundle.getBundle("oracle.bpm.resources.boot.Resources");
            }
            s = resources.getString(key);
        }
        catch (MissingResourceException e) {
            System.err.println("Resource: [" + s + "] not found.");
        }
        return s;
    }

    static void printRunningTime(String step) {
        Loader.printRunningTime(step, false);
    }

    static void printRunningTime(String step, boolean before) {
        if (logRunningTime) {
            System.out.println(Loader.showRunningTime(step, before));
            Loader.step();
        }
    }

    File cacheFile(String name, String ext) {
        String fileName = this.applicationPrefix == null ? (this.cacheName != null ? this.cacheName : CLASS_LIBRARY) : this.applicationPrefix + name;
        return new File(this.cacheDir(), fileName + ext);
    }

    boolean doDebug() {
        return this.debug;
    }

    Object[] init(String[] args) throws IOException {
        this.parseCommandLine(this.parseOptions(args));
        return this.initClassPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String loadMainClassFromJar(String j) throws IOException {
        URL jarUrl = new File(ClassPath.getLib(), j).toURI().toURL();
        JarInputStream jar = new JarInputStream(jarUrl.openStream());
        try {
            Manifest mf = jar.getManifest();
            if (mf == null) {
                System.err.println("ERROR: Unable to load MANIFEST from " + j);
                String string = null;
                return string;
            }
            Attributes attr = mf.getMainAttributes();
            this.processManifestProperties(attr);
            String string = (String)attr.get(Attributes.Name.MAIN_CLASS);
            return string;
        }
        finally {
            jar.close();
        }
    }

    File openClassCache() {
        File newCacheFile = this.cacheFile(CLASS_CACHE, NEW_CACHE);
        File cacheFile = this.cacheFile(CLASS_CACHE, DATA_EXT);
        if (newCacheFile.exists()) {
            boolean delete = false;
            for (int retry = 0; !delete && retry <= 3; ++retry) {
                try {
                    Thread.sleep(retry * 2 * 1000);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                delete = cacheFile.delete();
                if (!this.verbose) continue;
                System.out.println("Deleting cache file: retry->" + retry + " : delete->" + delete);
            }
            boolean rename = newCacheFile.renameTo(cacheFile);
            if (this.verbose) {
                System.out.println("The file " + cacheFile.getAbsolutePath() + " was deleted ->" + delete);
                System.out.println("The file " + newCacheFile.getAbsolutePath() + " was rename ->" + rename);
            }
        }
        return cacheFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProductIdProperties() {
        if (buildInfo == null) {
            buildInfo = null;
            InputStream is = Loader.class.getResourceAsStream("/fuego/id.properties");
            assert (is != null) : "could not find id.properties!";
            try {
                try {
                    buildInfo = new Properties();
                    buildInfo.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                System.err.println("Error: Could not load fuego/id.properties properties file.");
            }
        }
        return buildInfo;
    }

    private static void checkInitializationType() {
        if (initType != null) {
            return;
        }
        URL resource = Loader.class.getResource("/META-INF/FuegoClient.txt");
        if (resource != null) {
            initType = BIG_JAVA_CLIENT;
        }
    }

    private static Loader createLoader(File systemDir, File[] classPath, boolean cached, ClassLoader parent, String cacheName) throws IOException {
        Loader result = new Loader();
        result.usingCache = cached;
        result.systemDir = systemDir;
        result.cacheName = cacheName;
        result.createClassLoader(classPath, parent);
        return result;
    }

    private static boolean arePluginsLoaded() {
        return Loader.getRootLoader().pluginsLoaded;
    }

    private static void defineOutput(String outputFileName) {
        try {
            FileOutputStream file = new FileOutputStream(outputFileName);
            MultiplexingOutputStream multiErr = new MultiplexingOutputStream(new OutputStream[]{System.err, file});
            MultiplexingOutputStream multiOut = new MultiplexingOutputStream(new OutputStream[]{System.out, file});
            PrintStream out = new PrintStream(multiOut);
            PrintStream err = new PrintStream(multiErr);
            System.setOut(out);
            System.setErr(err);
        }
        catch (FileNotFoundException e) {
            System.err.println("Can't open file " + outputFileName + " for writing");
        }
    }

    private static BootData getRootBootData() {
        return Loader.getRootLoader().bootData;
    }

    private static BootData loadClasspathPlugins() {
        assert (Loader.isBigClientJar()) : "This is only valid when we are a big client jar";
        ClassLoader classLoader = Loader.class.getClassLoader();
        try {
            Enumeration<URL> manifests = classLoader.getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                try {
                    URL manifestUrl = manifests.nextElement();
                    File containerJar = ClassPath.getManifestContainer(manifestUrl);
                    Manifest manifest = new Manifest(manifestUrl.openStream());
                    Loader.getRootLoader().registerJarInBootData(containerJar, manifest);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Loader.getRootLoader().getBootData();
    }

    private static void padInt(StringBuffer buffer, long value, int width) {
        String str = String.valueOf(value);
        int size = width - str.length();
        if (size > 0 && size <= blanks.length) {
            buffer.append(blanks, 0, width - str.length());
        }
        buffer.append(str);
    }

    private static Object readGlobalCachedObject(File cacheDir, String name, final ClassLoader classLoader) throws IOException {
        Object result = null;
        File cache = new File(cacheDir, name + SER);
        if (cache.exists()) {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(cache)){

                protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    Class<?> cl = null;
                    if (classLoader != null) {
                        cl = Class.forName(desc.getName(), true, classLoader);
                    }
                    return cl == null ? super.resolveClass(desc) : cl;
                }
            };
            try {
                result = objectInputStream.readObject();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static void setSystemClassLoader(ClassLoader cl) {
        try {
            Class<ClassLoader> clClass = ClassLoader.class;
            Field scl = clClass.getDeclaredField("scl");
            Field sclSet = clClass.getDeclaredField("sclSet");
            scl.setAccessible(true);
            sclSet.setAccessible(true);
            scl.set(null, cl);
            sclSet.setBoolean(null, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void usage() {
        System.err.println("USAGE: java -jar fuego.boot.jar [-o <OUTFILE>] <JARFILE>[:<MAIN CLASS>] ");
        System.err.println("\t<JARFILE> Jar file to load");
        System.err.println("\t<MAIN CLASS> Jar's main class");
        System.err.println("\t<OUTFILE> File where stdout and stderr are redirected");
    }

    private void installAsianDateFormats() {
        DateFormat.getDateInstance(0, Locale.CHINESE);
        DateFormat.getDateInstance(0, Locale.SIMPLIFIED_CHINESE);
        DateFormat.getDateInstance(0, Locale.TRADITIONAL_CHINESE);
        DateFormat.getDateInstance(0, Locale.JAPANESE);
        DateFormat.getDateInstance(0, Locale.JAPAN);
        DateFormat.getDateInstance(0, Locale.KOREAN);
        DateFormat.getDateInstance(0, Locale.KOREA);
    }

    private void addInitalCP(String initial, Set<File> cp) {
        LinkedHashSet<File> extraClassPath = new LinkedHashSet<File>();
        ClassPath.addClassPathToSet(initial, extraClassPath);
        for (File extraFile : extraClassPath) {
            if (!this.specifyClass && (extraFile.getName().endsWith("jar") || extraFile.getName().endsWith("zip"))) {
                cp.addAll(this.loadClassPath(extraFile));
                continue;
            }
            cp.add(extraFile);
        }
    }

    private File[] buildClassPath(Set<File> classSet) {
        this.addInitalCP(this.initialCP, classSet);
        String strCp = "";
        Iterator<File> it = classSet.iterator();
        File[] cp = new File[classSet.size()];
        int count = 0;
        while (it.hasNext()) {
            File path = it.next();
            try {
                path = path.getAbsoluteFile().getCanonicalFile();
                strCp = strCp + path.getPath() + File.pathSeparator;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            cp[count] = path;
            ++count;
        }
        this.classPath = strCp;
        return cp;
    }

    private Set<File> buildClassPath(File j, boolean loadJavaClassPath) {
        ClassPath cl = new ClassPath(j, new JarWalker(this), this.verbose);
        if (this.getManifestProperties() != null) {
            cl.addProperties(this.getManifestProperties());
        }
        return cl.getClassPath();
    }

    private File cacheDir() {
        File result;
        if (this.applicationPrefix != null) {
            result = ClassPath.getCache();
        } else {
            assert (this.systemDir != null) : "Must set system dir";
            result = this.systemDir;
        }
        boolean okDir = result.exists() ? result.isDirectory() : result.mkdir();
        if (!okDir) {
            System.err.println("Installation problem can't create cache");
        }
        return result;
    }

    private void createClassLoader(File[] cp, ClassLoader cloader) throws IOException {
        Properties propIdFile = Loader.getProductIdProperties();
        if (propIdFile != null && "albpmstudio".equals(propIdFile.get(APPLICATION_ID))) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (File file : cp) {
                urls.add(file.toURI().toURL());
            }
            URL[] urlsArray = urls.toArray(new URL[urls.size()]);
            this.classLoader = new URLClassLoader(urlsArray, cloader);
        } else {
            ClassCache classCache = this.buildClassCache(cp);
            this.classLoader = new BaseClassLoader(classCache, cp, cloader);
        }
    }

    private ClassCache buildClassCache(File[] cp) throws IOException {
        ClassCache classCache;
        ArrayList<ClassHelper> helpers = new ArrayList<ClassHelper>();
        byte[] digest = this.initClassPath(cp, helpers);
        if (!this.usingCache) {
            classCache = new ClassCache(this, helpers);
        } else {
            File cacheIndexFile = this.cacheFile(CLASS_CACHE, INDEX_EXT);
            classCache = ClassCache.create(this, helpers, cacheIndexFile, digest, this.useBuiltCache, this.isCheckCache());
            if (classCache == null && !this.useBuiltCache) {
                classCache = new ClassCache(this, helpers);
                File cacheFile = this.cacheFile(CLASS_CACHE, DATA_EXT);
                long cacheFileSize = classCache.buildCache(cacheFile, this.getBootData().getClassSet(), progressMonitor);
                try {
                    classCache.writeClassCache(digest, cacheFileSize, cacheIndexFile);
                }
                catch (ClassCacheWriteException e) {
                    cacheFile.delete();
                    throw e.getIOException();
                }
                classCache.openClassCache(cacheFile);
            }
        }
        return classCache;
    }

    private void createClassLoaderForExternalUsage(File jar, File[] extraClassPath, String extraClassPathString, ClassLoader parent) throws IOException {
        Set<File> cpath = this.buildClassPath(jar, false);
        if (extraClassPath != null) {
            cpath.addAll(Arrays.asList(extraClassPath));
        }
        if (extraClassPathString != null) {
            this.addInitalCP(extraClassPathString, cpath);
        }
        File[] cp = new File[cpath.size()];
        cpath.toArray(cp);
        this.createClassLoader(cp, parent);
        rootLoader = this;
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
    }

    private void dump(Properties properties) {
        ArrayList<String> props = new ArrayList<String>();
        for (Object object : properties.keySet()) {
            props.add((String)object);
        }
        Collections.sort(props);
        for (String string : props) {
            System.err.println(string + " = " + properties.get(string));
        }
    }

    private void dumpBuildInfo() {
        Properties info = Loader.getProductIdProperties();
        this.dump(info);
        System.err.println("=========================");
        this.dump(System.getProperties());
    }

    private BootData getBootData() {
        if (this.bootData == null) {
            this.bootData = new BootData(this.usingCache);
        }
        return this.bootData;
    }

    private Properties getManifestProperties() {
        return this.manifestProperties;
    }

    private BufferedReader getStdIn() {
        if (this.stdin == null) {
            this.stdin = new BufferedReader(new InputStreamReader(System.in));
        }
        return this.stdin;
    }

    private Object[] initClassPath() throws IOException {
        File[] cp;
        Set<File> classSet;
        systemClassLoader = true;
        if (this.parentClassLoader == null) {
            this.parentClassLoader = Loader.class.getClassLoader();
        }
        if (this.eclipseSearchPath == null && this.jarFile != null) {
            this.bootData = this.loadBootData();
            classSet = this.bootData.getClassSet();
            cp = this.buildClassPath(classSet);
            this.createClassLoader(cp, this.parentClassLoader);
            if (this.classLoader instanceof BaseClassLoader) {
                ((BaseClassLoader)this.classLoader).enablePreload();
            }
            this.bootData.store(this);
            System.setProperty("java.class.path", this.classPath);
            if (this.generateCache) {
                System.exit(0);
            }
        } else {
            System.out.println("jarFile = " + this.jarFile);
            classSet = new LinkedHashSet<File>();
            if (this.eclipseSearchPath != null) {
                EclipseClasspath eclipseClasspath = new EclipseClasspath(this.jarFile, this.eclipseSearchPath, this.verbose);
                File[] a = eclipseClasspath.build();
                classSet.addAll(Arrays.asList(a));
            }
            cp = this.buildClassPath(classSet);
            System.setProperty("java.class.path", this.classPath);
            this.createClassLoader(cp, this.parentClassLoader);
        }
        Thread.currentThread().setContextClassLoader(this.classLoader);
        Loader.setSystemClassLoader(this.classLoader);
        if (this.bootData != null && this.bootData.bootPlugIns != null) {
            for (String plugin : this.bootData.bootPlugIns) {
                try {
                    Class.forName(plugin, true, this.classLoader);
                }
                catch (Throwable throwable) {}
            }
        }
        return new Object[]{this.mainClass, this.classLoader, this.arguments};
    }

    private byte[] initClassPath(File[] cp, ArrayList<ClassHelper> helpers) {
        DigestOutputStream mdo = null;
        DataOutputStream data = null;
        try {
            mdo = new DigestOutputStream(new NullOS(), MessageDigest.getInstance("SHA"));
            data = new DataOutputStream(mdo);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (this.verbose) {
            System.out.println("CLASSPATH: ");
        }
        BootHashSet classSet = new BootHashSet();
        for (File file : cp) {
            if (classSet.contains(file) || file.getName().startsWith(BOOT_JAR)) continue;
            if (this.verbose) {
                System.out.println("\t" + file);
            }
            classSet.add(file);
            ClassHelper helper = ClassHelper.create(file);
            helper.close();
            helpers.add(helper);
            if (data == null) continue;
            try {
                data.writeChars(helper.getName());
                data.writeLong(helper.lastModified());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return data == null ? null : mdo.getMessageDigest().digest();
    }

    private void initEnv() {
        this.verbose = Boolean.getBoolean("fuego.boot.verbose");
        this.debug = Boolean.getBoolean("fuego.boot.debug");
        this.stepping = Boolean.getBoolean("fuego.loader.step");
    }

    private void input(String prompt) {
        System.out.print(prompt);
        try {
            this.getStdIn().readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isCheckCache() {
        return this.checkCache;
    }

    private BootData loadBootData() {
        File jar = new File(ClassPath.getLib(), this.jarFile);
        if (!this.usingCache) {
            this.bootData = new BootData(false);
        } else {
            try {
                this.bootData = (BootData)this.readCachedObject("bootData", null);
            }
            catch (Throwable e) {
                this.bootData = null;
            }
            if (this.useBuiltCache) {
                if (this.bootData == null) {
                    throw new RuntimeException("Cant Read Cache File");
                }
                return this.bootData;
            }
            long modificationTime = jar.lastModified();
            if (this.bootData == null || this.generateCache || modificationTime > this.bootData.modificationTime || this.forceRebuild) {
                this.bootData = new BootData(this.usingCache);
                this.bootData.modificationTime = 0L;
                this.bootData.store(this);
                this.bootData.needsBuild = true;
                this.bootData.modificationTime = modificationTime;
            } else {
                this.bootData.cached = this.usingCache;
            }
        }
        if (this.bootData.needsBuild()) {
            this.bootData.setClassSet(this.buildClassPath(jar, true));
        }
        return this.bootData;
    }

    private Set<File> loadClassPath(File jar) {
        if (this.bootData == null) {
            this.bootData = new BootData(false);
        }
        return this.buildClassPath(jar, true);
    }

    private boolean parseCommandLine(String commandLine) throws IOException {
        int colon = commandLine.lastIndexOf(58);
        if (this.jarFile != null) {
            assert (this.mainClass != null);
            assert (this.applicationPrefix != null);
            return true;
        }
        boolean classFromManifest = false;
        if (colon != -1) {
            this.jarFile = commandLine.substring(0, colon);
            this.mainClass = commandLine.substring(colon + 1, commandLine.length());
            if (this.applicationPrefix == null) {
                this.applicationPrefix = new File(this.jarFile).getName() + ":" + this.mainClass;
            }
        } else if (this.specifyClass) {
            File f = new File(commandLine);
            this.mainClass = f.getCanonicalPath();
            this.mainClass = this.mainClass.substring(this.mainClass.lastIndexOf("fuego"), this.mainClass.lastIndexOf("."));
            this.mainClass = this.mainClass.replace(File.separatorChar, '.');
            System.out.println("Executing Class: " + this.mainClass);
            this.applicationPrefix = this.mainClass;
        } else {
            this.jarFile = commandLine;
            classFromManifest = true;
            this.applicationPrefix = this.resolveDefaultName();
            try {
                this.mainClass = this.loadMainClassFromJar(this.jarFile);
            }
            catch (IOException ex) {
                System.err.println("ERROR: Unable to load Main-Class manifest attribute from " + this.jarFile + ": " + ex.getClass().getName() + ": " + ex.getMessage());
                return false;
            }
            if (this.mainClass == null) {
                System.err.println("ERROR: Unable to load Main-Class manifest attribute from " + this.jarFile);
                return false;
            }
        }
        if (this.applicationPrefix == null) {
            this.applicationPrefix = new File(this.jarFile).getName();
            if (!classFromManifest) {
                this.applicationPrefix = this.applicationPrefix + ":" + this.mainClass;
            }
        }
        return true;
    }

    private String parseOptions(String[] args) {
        try {
            ArgIterator iter = new ArgIterator(args);
            String arg = null;
            while (iter.hasNext() && (arg = iter.nextArg()).charAt(0) == '-') {
                if ("-cp".equalsIgnoreCase(arg) || "-classpath".equalsIgnoreCase(arg)) {
                    this.initialCP = this.initialCP.concat(iter.nextArg() + File.pathSeparator);
                    this.usingCache = false;
                } else if ("-o".equals(arg)) {
                    this.usingCache = false;
                    String outputFileName = iter.nextArg();
                    Loader.defineOutput(outputFileName);
                } else if (arg.equals(ECLIPSE_OPTION)) {
                    this.eclipseSearchPath = iter.nextArg();
                } else if (arg.equals(APPLICATION_NAME_OPTION)) {
                    this.applicationPrefix = iter.nextArg();
                } else if (arg.equalsIgnoreCase(USE_BUILT_CACHE)) {
                    this.useBuiltCache = true;
                }
                if (arg.equalsIgnoreCase(RESTART_OPTION)) {
                    this.restart = true;
                    this.restartParentPort = Integer.parseInt(iter.nextArg());
                    continue;
                }
                if (arg.equalsIgnoreCase(VERBOSE_OPTION)) {
                    this.verbose = true;
                    continue;
                }
                if (arg.equalsIgnoreCase(CONSOLE_OPTION)) continue;
                if (arg.equalsIgnoreCase(DEBUG_OPTION)) {
                    this.debug = true;
                    this.verbose = true;
                    continue;
                }
                if (arg.equalsIgnoreCase(CLASS_OPTION)) {
                    this.usingCache = false;
                    this.specifyClass = true;
                    continue;
                }
                if (arg.equalsIgnoreCase(NO_CACHE_OPTION)) {
                    this.usingCache = false;
                    continue;
                }
                if (arg.equals(CHECK_CACHE_OPTION)) {
                    this.checkCache = true;
                    continue;
                }
                if (arg.equals(GENERATE_CACHE_OPTION)) {
                    this.generateCache = true;
                    continue;
                }
                if ("-test-loader".equals(arg) || !arg.equals(BASE_DIR_OPTION)) continue;
                ClassPath.setBaseDir(new File(iter.nextArg()));
            }
            String[] allArgs = iter.nextArguments();
            LinkedList<String> arrayList = new LinkedList<String>();
            for (int i = 0; i < allArgs.length; ++i) {
                String a = allArgs[i];
                if (RESTART_OPTION.equals(a)) {
                    this.restart = true;
                    this.restartParentPort = Integer.parseInt(allArgs[i + 1]);
                    this.verbose = true;
                    ++i;
                    continue;
                }
                arrayList.add(a);
            }
            this.setArguments(arrayList.toArray(new String[arrayList.size()]));
            return arg;
        }
        catch (IndexOutOfBoundsException iob) {
            Loader.usage();
            return null;
        }
    }

    private void processManifestProperties(Attributes attributes) {
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String key = entry.getKey().toString();
            String value = (String)entry.getValue();
            if (!key.startsWith(FUEGO_BOOT_PREFIX)) continue;
            key = key.substring(FUEGO_BOOT_PREFIX.length());
            this.manifestProperties.setProperty(key, value);
        }
    }

    private Object readCachedObject(String name, final ClassLoader cloader) throws IOException {
        Object result = null;
        File cache = this.cacheFile(name, SER);
        if (cache.exists()) {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(cache)){

                protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    Class<?> cl = null;
                    if (cloader != null) {
                        cl = Class.forName(desc.getName(), true, cloader);
                    }
                    return cl == null ? super.resolveClass(desc) : cl;
                }
            };
            try {
                result = objectInputStream.readObject();
            }
            catch (Throwable e) {
                result = null;
            }
        }
        return result;
    }

    private void registerJarInBootData(File jar, Manifest manifest) {
        assert (jar != null);
        assert (manifest != null);
        Attributes attr = manifest.getMainAttributes();
        BootData bd = this.getBootData();
        try {
            jar = jar.getAbsoluteFile().getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        String vendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        String title = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        if (FUEGOTECH_PLUGIN.equals(vendor) && title != null) {
            if (bd.plugIns.add(title) && this.verbose) {
                System.out.println("Registering plugin:" + title);
            }
        } else if (FUEGOTECH_BOOT_PLUGIN.equals(vendor) && title != null) {
            if (bd.bootPlugIns.add(title) && this.verbose) {
                System.out.println("Registering boot plugin:" + title);
            }
        } else if (FUEGO_DATABASE_PLUGIN.equals(vendor) && title != null) {
            if (bd.databasePlugIns.add(title) && this.verbose) {
                System.out.println("Registering database plugin:" + title);
            }
        } else if (FUEGO_BLOCK.equals(vendor) && bd.fuegoBlocks.add(jar) && this.verbose) {
            System.out.println("Registering block:" + jar);
        }
        for (Attributes attributes : manifest.getEntries().values()) {
            vendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            title = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            if (FUEGOTECH_PLUGIN.equals(vendor) && title != null) {
                if (!bd.plugIns.add(title) || !this.verbose) continue;
                System.out.println("Registering plugin:" + title);
                continue;
            }
            if (!FUEGO_BLOCK.equals(vendor) || !bd.fuegoBlocks.add(jar) || !this.verbose) continue;
            System.out.println("Registering block:" + jar);
        }
    }

    private String resolveDefaultName() {
        for (int i = 0; i < defaultNames.length; i += 2) {
            if (!this.jarFile.startsWith(defaultNames[i])) continue;
            return defaultNames[i + 1];
        }
        return null;
    }

    private void run() {
        logRunningTime = Boolean.getBoolean("oracle.bpm.log.runningtime");
        try {
            this.runAsMain();
        }
        catch (IOException e) {
            System.err.println();
            e.printStackTrace();
            this.dumpBuildInfo();
            System.exit(-1);
        }
        catch (Throwable t) {
            System.err.println();
            t.printStackTrace();
            this.dumpBuildInfo();
            System.exit(-1);
        }
    }

    private boolean runAsMain() throws Throwable {
        String commandLine = this.parseOptions(this.arguments);
        if (this.restart) {
            this.waitForParentProcess();
        }
        if (commandLine != null && this.parseCommandLine(commandLine)) {
            Object[] obj = this.initClassPath();
            Class<?> clazz = Class.forName((String)obj[0], true, (ClassLoader)obj[1]);
            Method mtd = clazz.getMethod(MAIN_METHOD, String[].class);
            if (!mtd.isAccessible()) {
                mtd.setAccessible(true);
            }
            try {
                mtd.invoke(null, obj[2]);
                return true;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw e.getCause();
            }
        }
        return false;
    }

    private void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    private void setProperties(Properties bootProperties) {
        this.manifestProperties.putAll((Map<?, ?>)bootProperties);
    }

    private String showStats(String step, boolean before) {
        String result = null;
        if (logRunningTime) {
            long current = System.currentTimeMillis();
            StringBuffer buffer = new StringBuffer("");
            buffer.append(before ? "Before " : "After ");
            buffer.append(step);
            int len = step.length();
            if (len < blanks.length) {
                buffer.append(blanks, 0, blanks.length - len);
            }
            buffer.append(" Time: ");
            Loader.padInt(buffer, current - this.lastTime, 6);
            buffer.append(" / ");
            Loader.padInt(buffer, current - this.initialTime, 6);
            buffer.append(" Loaded classes: ");
            buffer.append(" Memory: ");
            long memory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            Loader.padInt(buffer, (memory - this.lastMemory) / 1024L, 5);
            buffer.append(" / ");
            Loader.padInt(buffer, memory / 1024L, 5);
            this.lastTime = current;
            this.lastMemory = memory;
            result = buffer.toString();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForLoaderExit() {
        assert (rootLoader == this) : "I am not the root loader!!!";
        if (this.exitLock != null) {
            Object object = this.exitLock;
            synchronized (object) {
                try {
                    this.exitLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForParentProcess() {
        System.out.println("waitForParentProcess: " + this.restartParentPort);
        InputStream is = null;
        OutputStream os = null;
        try {
            Socket socket = new Socket(InetAddress.getLocalHost(), this.restartParentPort);
            is = socket.getInputStream();
            os = socket.getOutputStream();
            os.write("I'm the child process.".getBytes());
            os.flush();
            socket.shutdownOutput();
            System.out.println("Waiting for my parent.");
            try {
                is.read();
            }
            catch (IOException e) {
                System.out.println("Parent process has died.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeCachedObject(String name, Object object) {
        try {
            File cache = this.cacheFile(name, SER);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(cache));
            objectOutputStream.writeObject(object);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        BIG_JAVA_CLIENT = 6;
        LAUNCHED_APPLICATION = 7;
        defaultNames = new String[]{"ftdesigner", FUEGO_STUDIO_NAME, "ftstudio", FUEGO_STUDIO_NAME, "fuegostudio", FUEGO_STUDIO_NAME, "fuegodesigner", FUEGO_STUDIO_NAME, "ftexpress", FUEGO_EXPRESS_NAME, "fuegoexpress", FUEGO_EXPRESS_NAME, "fuegoadmcenter", FUEGO_ADMCENTER_NAME};
        BASIC_MONITOR = new BuildCacheProgressMonitor(){
            int printed = 0;

            @Override
            public void setProgress(int nv) {
                while (nv > this.printed) {
                    System.out.print('#');
                    this.printed += 2;
                }
                if (nv == 100) {
                    System.out.println();
                    this.printed = 0;
                }
            }
        };
        LANGUAGES_LIST = new String[]{"en", "es", "pt", "fr", "it", "de"};
        classloaders = Collections.synchronizedMap(new WeakHashMap());
        systemClassLoader = false;
        progressMonitor = BASIC_MONITOR;
        resources = null;
        blanks = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    }

    private static class NullOS
    extends OutputStream {
        private NullOS() {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }
    }

    private static final class BootData
    implements Serializable {
        public final Set<String> bootPlugIns;
        public transient boolean cached;
        public final Set<String> databasePlugIns;
        public final Set<File> fuegoBlocks;
        public final Set<String> plugIns = new HashSet<String>();
        long modificationTime;
        transient boolean needsBuild;
        private Set<File> classSet;
        private transient boolean loaded;
        static final long serialCheck = -3234039834023697163L;
        static final long serialVersionUID = -891547506183724799L;
        static final String BOOT_DATA = "bootData";

        public BootData(boolean cached) {
            this.fuegoBlocks = new HashSet<File>();
            this.bootPlugIns = new HashSet<String>();
            this.databasePlugIns = new HashSet<String>();
            this.classSet = new LinkedHashSet<File>();
            this.cached = cached;
            this.needsBuild = true;
        }

        public boolean needsBuild() {
            return this.needsBuild;
        }

        public void store(Loader loader) {
            if (this.cached && !loader.useBuiltCache) {
                this.needsBuild = false;
                loader.writeCachedObject(BOOT_DATA, this);
            }
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Plugins:\n");
            buffer.append(this.plugIns);
            buffer.append("\nFuegoBlocks:\n");
            buffer.append(this.fuegoBlocks);
            buffer.append("\nBootPlugIns:\n");
            buffer.append(this.bootPlugIns);
            buffer.append("\nDatabasePlugIns:\n");
            buffer.append(this.databasePlugIns);
            buffer.append("\nClassSet:\n");
            buffer.append(this.classSet);
            return buffer.toString();
        }

        Set<File> getClassSet() {
            if (this.classSet == null) {
                this.classSet = new LinkedHashSet<File>();
            }
            return this.classSet;
        }

        void setClassSet(Set<File> classSet) {
            this.classSet = classSet;
        }

        private boolean loadPlugins() {
            if (!this.loaded) {
                Iterator<String> plugins = this.plugIns.iterator();
                this.loaded = true;
                while (plugins.hasNext()) {
                    String pluginClassName = plugins.next();
                    try {
                        Class.forName(pluginClassName);
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("Could not find plugin class: " + pluginClassName);
                        if (!Loader.getRootLoader().doDebug()) continue;
                        e.printStackTrace();
                    }
                    catch (Throwable e) {
                        System.err.println("Could not load plugin: " + pluginClassName);
                        System.err.println("\tCause: " + e.getMessage());
                        e.printStackTrace();
                        if (!Loader.getRootLoader().doDebug()) continue;
                        e.printStackTrace();
                    }
                }
            }
            return this.loaded;
        }
    }

    private static final class ArgIterator
    implements Iterator {
        private int argNumber;
        private final String[] args;

        public ArgIterator(String[] args) {
            this.args = args;
            this.argNumber = 0;
        }

        @Override
        public boolean hasNext() {
            return this.argNumber < this.args.length;
        }

        public Object next() {
            return this.nextArg();
        }

        public String nextArg() {
            if (!this.hasNext()) {
                IndexOutOfBoundsException e = new IndexOutOfBoundsException();
                e.printStackTrace();
                throw e;
            }
            return this.args[this.argNumber++];
        }

        public String[] nextArguments() {
            return Arrays.copyOfRange(this.args, this.argNumber, this.args.length);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static final class JarWalker {
        private final Loader loader;

        public JarWalker(Loader loader) {
            this.loader = loader;
        }

        public void visitJar(File jar, Manifest manifest) {
            this.loader.registerJarInBootData(jar, manifest);
        }
    }
}

