/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.xml;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.ListIterator;
import oracle.bpm.xml.XmlWriter;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class XFormSerializer {
    public static void serialize(XmlWriter out, XFormPresentation object) throws IOException {
        XFormSerializer.serializeX(out, object);
    }

    private static void serializeX(XmlWriter xml, XFormXMLObject xObject) throws IOException {
        String tag = xObject.getName();
        if (tag == null || tag.equals("")) {
            return;
        }
        xml.startElement(tag);
        Field[] fields = null;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        ArrayList<Object> entities = new ArrayList<Object>();
        String content = null;
        try {
            fields = xObject.getClass().getFields();
        }
        catch (SecurityException se) {
            // empty catch block
        }
        for (int i = 0; i < fields.length; ++i) {
            if (Modifier.isStatic(fields[i].getModifiers())) continue;
            try {
                Object o = fields[i].get(xObject);
                if (o == null) continue;
                if (!(o instanceof XFormXMLObject) && !o.getClass().isArray()) {
                    String fieldName = fields[i].getName();
                    if (fieldName.equals(tag + "_d")) {
                        content = (String)fields[i].get(xObject);
                        continue;
                    }
                    Object value = o;
                    if (o instanceof Enum) {
                        value = ((Enum)o).name();
                    }
                    attributes.add(new Attribute(fieldName, value));
                    continue;
                }
                if (o.getClass().isArray()) {
                    int ed;
                    String value;
                    if (o.getClass().getComponentType().equals(String.class)) {
                        value = "[";
                        String[] temp = (String[])o;
                        if (temp.length > 0) {
                            value = value + "," + temp[0];
                        }
                        for (ed = 1; ed < temp.length; ++ed) {
                            value = value + "," + temp[ed];
                        }
                        value = value + "]";
                        attributes.add(new Attribute(fields[i].getName(), value));
                        continue;
                    }
                    if (o.getClass().getComponentType().equals(Integer.TYPE)) {
                        value = "[";
                        int[] temp = (int[])o;
                        if (temp.length > 0) {
                            value = value + "," + temp[0];
                        }
                        for (ed = 1; ed < temp.length; ++ed) {
                            value = value + "," + temp[ed];
                        }
                        value = value + "]";
                        attributes.add(new Attribute(fields[i].getName(), value));
                        continue;
                    }
                    XFormXMLObject[] tmp = (XFormXMLObject[])o;
                    for (int j = 0; j < tmp.length; ++j) {
                        entities.add(tmp[j]);
                    }
                    continue;
                }
                entities.add(o);
                continue;
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
        ListIterator li = attributes.listIterator();
        while (li.hasNext()) {
            Attribute att = (Attribute)li.next();
            xml.printAttribute(att.getName(), att.getValue());
        }
        if (content != null) {
            xml.printChars(content);
        }
        li = entities.listIterator();
        while (li.hasNext()) {
            XFormSerializer.serializeX(xml, (XFormXMLObject)li.next());
        }
        xml.endElement();
    }

    private static class Attribute {
        private String name_d;
        private String value_d;

        private Attribute(String name, Object value) {
            if (name.endsWith("_d")) {
                name = name.substring(0, name.length() - 2);
            }
            this.name_d = name;
            this.value_d = String.valueOf(value);
        }

        public String getName() {
            return this.name_d;
        }

        public String getValue() {
            return this.value_d;
        }
    }
}

