/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.presentationmodel;

import java.io.Serializable;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;
import oracle.bpm.xobject.presentationmodel.PropertiesUtils;
import oracle.bpm.xobject.presentationmodel.XFormComponent;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class XFormTable
extends XFormPresentationXMLObject
implements XFormComponent,
Serializable,
FullBorderProperties {
    public String alignment;
    public boolean border = true;
    public String bottombordercolor = "#D0D2D4";
    public String bottomborderstyle = DEFAULT_BORDER_STYLE;
    public int bottomborderwidth = 1;
    public int cellpadding;
    public int cellspacing;
    public String[] columnwidth;
    public String id = null;
    public String leftbordercolor = "#D0D2D4";
    public String leftborderstyle = DEFAULT_BORDER_STYLE;
    public int leftborderwidth = 1;
    public String rightbordercolor = "#D0D2D4";
    public String rightborderstyle = DEFAULT_BORDER_STYLE;
    public int rightborderwidth = 1;
    public XFormRow[] row;
    public String topbordercolor = "#D0D2D4";
    public String topborderstyle = DEFAULT_BORDER_STYLE;
    public int topborderwidth = 1;
    public String width;
    static final long serialVersionUID = 6378829418516906654L;
    static final long serialCheck = -5102424087430739376L;

    public XFormTable() {
        this.setCssClass("fo_table");
    }

    public XFormTable(int rowN, int col) {
        this();
        this.expand(rowN, col);
    }

    @Override
    public boolean isBorderActive() {
        return this.border;
    }

    @Override
    public void setBottomColor(String color) {
        this.bottombordercolor = PropertiesUtils.getBorderColor(color);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getBottomColor() {
        return this.bottombordercolor;
    }

    @Override
    public BorderStyle getBottomStyle() {
        return PropertiesUtils.valueOfBorderStyle(this.bottomborderstyle);
    }

    @Override
    public void setBottomWidth(int width) {
        this.bottomborderwidth = PropertiesUtils.getBorderWidth(width);
    }

    @Override
    public int getBottomWidth() {
        return this.bottomborderwidth;
    }

    @Override
    public void setBottomborderstyle(BorderStyle style) {
        this.bottomborderstyle = PropertiesUtils.getBorderStyle(style);
    }

    @Override
    public int getComponentID() {
        return 11;
    }

    @Override
    public void setLeftColor(String color) {
        this.leftbordercolor = PropertiesUtils.getBorderColor(color);
    }

    @Override
    public String getLeftColor() {
        return this.leftbordercolor;
    }

    @Override
    public BorderStyle getLeftStyle() {
        return PropertiesUtils.valueOfBorderStyle(this.leftborderstyle);
    }

    @Override
    public void setLeftWidth(int width) {
        this.leftborderwidth = PropertiesUtils.getBorderWidth(width);
    }

    @Override
    public int getLeftWidth() {
        return this.leftborderwidth;
    }

    @Override
    public void setLeftborderstyle(BorderStyle style) {
        this.leftborderstyle = PropertiesUtils.getBorderStyle(style);
    }

    public int getModelTotalColumnWidth() {
        int count = 0;
        if (this.row != null) {
            int[] rowColWidth = new int[this.row.length];
            for (int i = 0; i < this.row.length; ++i) {
                if (this.row[i].cell == null) continue;
                for (int j = 0; j < this.row[i].cell.length; ++j) {
                    int vex;
                    int currentHExpand = this.row[i].cell[j].hexpand == 0 ? 1 : this.row[i].cell[j].hexpand;
                    int n = i;
                    rowColWidth[n] = rowColWidth[n] + currentHExpand;
                    int currentRow = i;
                    if (vex <= 1) continue;
                    for (vex = this.row[i].cell[j].vexpand; vex > 1 && currentRow + 1 < rowColWidth.length; --vex) {
                        int n2 = ++currentRow;
                        rowColWidth[n2] = rowColWidth[n2] + currentHExpand;
                    }
                }
                if (rowColWidth[i] <= count) continue;
                count = rowColWidth[i];
            }
        }
        return count;
    }

    public int getModelTotalColumns() {
        int count = 0;
        if (this.row != null) {
            for (int i = 0; i < this.row.length; ++i) {
                if (this.row[i].cell == null) continue;
                int currentCount = 0;
                for (int j = 0; j < this.row[i].cell.length; ++j) {
                    currentCount += this.row[i].cell[j].hexpand == 0 ? 1 : this.row[i].cell[j].hexpand;
                }
                if (currentCount <= count) continue;
                count = currentCount;
            }
        }
        return count;
    }

    @Override
    public String getName() {
        return "table";
    }

    @Override
    public void setRightColor(String color) {
        this.rightbordercolor = PropertiesUtils.getBorderColor(color);
    }

    @Override
    public String getRightColor() {
        return this.rightbordercolor;
    }

    @Override
    public BorderStyle getRightStyle() {
        return PropertiesUtils.valueOfBorderStyle(this.rightborderstyle);
    }

    @Override
    public void setRightWidth(int width) {
        this.rightborderwidth = PropertiesUtils.getBorderWidth(width);
    }

    @Override
    public int getRightWidth() {
        return this.rightborderwidth;
    }

    @Override
    public void setRightborderstyle(BorderStyle style) {
        this.rightborderstyle = PropertiesUtils.getBorderStyle(style);
    }

    @Override
    public void setTopColor(String color) {
        this.topbordercolor = PropertiesUtils.getBorderColor(color);
    }

    @Override
    public String getTopColor() {
        return this.topbordercolor;
    }

    @Override
    public BorderStyle getTopStyle() {
        return PropertiesUtils.valueOfBorderStyle(this.topborderstyle);
    }

    @Override
    public void setTopWidth(int width) {
        this.topborderwidth = PropertiesUtils.getBorderWidth(width);
    }

    @Override
    public int getTopWidth() {
        return this.topborderwidth;
    }

    @Override
    public void setTopborderstyle(BorderStyle style) {
        this.topborderstyle = PropertiesUtils.getBorderStyle(style);
    }

    @Override
    public boolean contains(XFormXMLObject object) {
        for (int i = 0; i < this.row.length; ++i) {
            XFormRow xFormRow = this.row[i];
            if (xFormRow != object) continue;
            return true;
        }
        return false;
    }

    public void expand(int rowN, int col) {
        this.row = new XFormRow[rowN];
        for (int i = 0; i < this.row.length; ++i) {
            this.row[i] = new XFormRow();
            this.row[i].setParent(this);
            this.row[i].expand(col);
        }
    }

    @Override
    public boolean hasReferenceTo(String dataId) {
        if (this.row != null) {
            for (int i = 0; i < this.row.length; ++i) {
                if (!this.row[i].hasReferenceTo(dataId)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean invokes(String signature) {
        if (this.row != null) {
            for (int i = 0; i < this.row.length; ++i) {
                if (!this.row[i].invokes(signature)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeInvocationTo(String signature) {
        if (this.row != null) {
            for (int i = 0; i < this.row.length; ++i) {
                this.row[i].removeInvocationTo(signature);
            }
        }
    }

    @Override
    public void removeReferenceTo(String dataId) {
        if (this.row != null) {
            for (int i = 0; i < this.row.length; ++i) {
                this.row[i].removeReferenceTo(dataId);
            }
        }
    }

    @Override
    public void renameReferenceTo(String oldReference, String newReference) {
        if (this.row != null) {
            for (int i = 0; i < this.row.length; ++i) {
                this.row[i].renameReferenceTo(oldReference, newReference);
            }
        }
    }

    public boolean hasRows() {
        return this.row != null && this.row.length > 0;
    }

    public int indexOf(XFormRow theRow) {
        int result = -1;
        if (theRow != null && this.row != null) {
            for (int i = 0; i < this.row.length; ++i) {
                if (this.row[i] != theRow) continue;
                result = i;
            }
        }
        return result;
    }

    @Override
    public int getIndex(XFormXMLObject nodeToClear) {
        return nodeToClear instanceof XFormRow ? this.indexOf((XFormRow)nodeToClear) : super.getIndex(nodeToClear);
    }

    @Override
    public XFormXMLObject getChildAt(int index) {
        return index < this.row.length && index >= 0 ? this.row[index] : super.getChildAt(index);
    }

    @Override
    public int getChildCount() {
        return this.row == null ? 0 : this.row.length;
    }

    @Override
    public boolean move(XFormXMLObject child, boolean up) {
        boolean result;
        int actualIndex = this.getIndex(child);
        if (actualIndex >= 0) {
            int newIndex;
            int n = newIndex = up ? actualIndex - 1 : actualIndex + 1;
            if (newIndex < 0 || newIndex >= this.getChildCount()) {
                result = false;
            } else {
                XFormRow object = this.row[newIndex];
                this.row[newIndex] = (XFormRow)child;
                this.row[actualIndex] = object;
                result = true;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public XFormPresentationXMLObject findComponent(String dataId) {
        XFormPresentationXMLObject result = null;
        if (dataId.equals(this.getId())) {
            result = this;
        } else if (this.row != null) {
            for (int i = 0; result == null && i < this.row.length; ++i) {
                result = this.row[i].findComponent(dataId);
            }
        }
        return result;
    }
}

