/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.presentationmodel;

import oracle.bpm.ui.BorderStyle;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.xobject.GraphicType;
import oracle.bpm.xobject.presentationmodel.FontProperties;
import oracle.bpm.xobject.presentationmodel.PropertiesUtils;
import oracle.bpm.xobject.presentationmodel.SimpleBorderProperties;
import oracle.bpm.xobject.presentationmodel.XFormComponent;
import oracle.bpm.xobject.presentationmodel.XFormPresentationComponent;
import oracle.bpm.xobject.xml.XFormXMLObject;

public abstract class XFormGraphic
extends XFormPresentationComponent
implements XFormComponent,
FontProperties,
SimpleBorderProperties {
    public int backargqty = 0;
    public String backmethod;
    public String bgcolor;
    public String bordercolor = "#D0D2D4";
    public String borderstyle = BORDER_STYLE_SOLID;
    public int borderwidth = 1;
    public String contentcolor;
    public transient GraphicType enumType;
    public String fontface = FontProperties.DEFAULT_FONT_STYLE.toString();
    public int fontsize = 12;
    public String fonttype = "Times New Roman, Times, serif";
    public boolean hasdynamictype = false;
    public boolean hasforcedrefresh = false;
    public int height = 150;
    public String id;
    public String methodinvocation;
    public String onclick;
    public int onclickargqty = 0;
    public String outlinecolor;
    public String plotbgcolor;
    public String plotoutlinecolor;
    public int refreshrate = 60;
    public String title;
    public String titlebackground;
    public String titleforeground;
    public int type;
    public String valuecolor;
    public FontStyle valuefontface = FontProperties.DEFAULT_FONT_STYLE;
    public int valuefontsize = 12;
    public String valuefonttype = "Times New Roman, Times, serif";
    public int width = 150;
    public static final int DEFAULT_REFRESH_RATE = 60;
    public static final int MIN_WIDTH = 150;
    public static final int MIN_HEIGHT = 150;
    static final long serialVersionUID = 1012504042015260901L;
    static final long serialCheck = 3313365091103545080L;

    public abstract int getType();

    public void setBackMethodArgumentQty(int qty) {
        this.backargqty = qty;
    }

    public int getBackMethodArgumentQty() {
        return this.backargqty;
    }

    public void setBackmethod(String backmethod) {
        this.backmethod = backmethod;
    }

    public String getBackmethod() {
        return this.backmethod;
    }

    @Override
    public boolean isBorderActive() {
        return true;
    }

    @Override
    public void setBordercolor(String borderColor) {
        this.bordercolor = PropertiesUtils.getBorderColor(borderColor);
    }

    @Override
    public String getBordercolor() {
        return this.bordercolor;
    }

    @Override
    public void setBorderstyle(BorderStyle borderStyle) {
        this.borderstyle = PropertiesUtils.getBorderStyle(borderStyle);
    }

    @Override
    public BorderStyle getBorderstyle() {
        return PropertiesUtils.valueOfBorderStyle(this.borderstyle);
    }

    @Override
    public void setBorderwidth(int borderWidth) {
        this.borderwidth = PropertiesUtils.getBorderWidth(borderWidth);
    }

    @Override
    public int getBorderwidth() {
        return this.borderwidth;
    }

    @Override
    public void setFontStyle(FontStyle fontStyle) {
        this.fontface = fontStyle != null ? fontStyle.toString() : null;
    }

    public FontStyle getFontface() {
        return this.getFontStyle();
    }

    public void setFontface(FontStyle fontStyle) {
        this.setFontStyle(fontStyle);
    }

    @Override
    public FontStyle getFontStyle() {
        return FontStyle.fromString(this.fontface);
    }

    @Override
    public void setFontsize(int fontsize) {
        this.fontsize = fontsize;
    }

    @Override
    public int getFontsize() {
        return this.fontsize;
    }

    @Override
    public void setFonttype(String fonttype) {
        this.fonttype = fonttype;
    }

    @Override
    public String getFonttype() {
        return this.fonttype;
    }

    public void setHasdynamictype(boolean hasdynamictype) {
        this.hasdynamictype = hasdynamictype;
    }

    public boolean getHasdynamictype() {
        return this.hasdynamictype;
    }

    public void setHasforcedrefresh(boolean hasforcedrefresh) {
        this.hasforcedrefresh = hasforcedrefresh;
    }

    public boolean getHasforcedrefresh() {
        return this.hasforcedrefresh;
    }

    public void setHeight(int height) {
        if (height >= 150) {
            this.height = height;
        }
    }

    public int getHeight() {
        return Math.max(this.height, 150);
    }

    public void setMethodinvocation(String methodinvocation) {
        this.methodinvocation = methodinvocation;
    }

    public String getMethodinvocation() {
        return this.methodinvocation;
    }

    public void setOnClickArgumentQty(int qty) {
        this.onclickargqty = qty;
    }

    public int getOnClickArgumentQty() {
        return this.onclickargqty;
    }

    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    public String getOnclick() {
        return this.onclick;
    }

    public void setRefreshrate(int refreshrate) {
        this.refreshrate = refreshrate;
    }

    public int getRefreshrate() {
        return this.refreshrate;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitlebackground(String titlebackground) {
        this.titlebackground = titlebackground;
    }

    public void setTitleforeground(String titleforeground) {
        this.titleforeground = titleforeground;
    }

    public void setType(int type) {
        this.type = this.checkType(type);
        this.enumType = null;
    }

    public void setType(GraphicType type) {
        this.enumType = type;
        this.type = this.enumType.getGraphicCode();
    }

    public GraphicType getEnumType() {
        this.getType();
        return this.enumType;
    }

    public FontProperties getValueFontProperties() {
        return new FontProperties(){

            @Override
            public void setFontStyle(FontStyle fontFace) {
                XFormGraphic.this.valuefontface = fontFace;
            }

            @Override
            public FontStyle getFontStyle() {
                return XFormGraphic.this.valuefontface;
            }

            @Override
            public void setFontsize(int fontSize) {
                XFormGraphic.this.valuefontsize = fontSize;
            }

            @Override
            public int getFontsize() {
                return XFormGraphic.this.valuefontsize;
            }

            @Override
            public void setFonttype(String fontType) {
                XFormGraphic.this.valuefonttype = fontType;
            }

            @Override
            public String getFonttype() {
                return XFormGraphic.this.valuefonttype;
            }
        };
    }

    public void setWidth(int width) {
        if (width >= 150) {
            this.width = width;
        }
    }

    public int getWidth() {
        return Math.max(this.width, 150);
    }

    @Override
    public boolean contains(XFormXMLObject object) {
        return false;
    }

    @Override
    public boolean hasReferenceTo(String dataId) {
        return false;
    }

    @Override
    public boolean invokes(String signature) {
        return false;
    }

    @Override
    public void removeInvocationTo(String signature) {
    }

    @Override
    public void renameReferenceTo(String oldReference, String newReference) {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String componentId) {
        this.id = componentId;
    }

    protected abstract int checkType(int var1);
}

