/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.presentationmodel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.xml.XmlWriter;
import oracle.bpm.xobject.presentationmodel.ColorProperties;
import oracle.bpm.xobject.presentationmodel.FontProperties;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormCombo;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.presentationmodel.XFormText;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PresentationGenerationOptions {
    private int[] buttonPanelLayout_d = new int[]{0, 1};
    private String[] buttonsDisplay_d;
    private boolean buttonsTransparent_d = true;
    private String cellDefaultAlignment_d = "left";
    private FontStyle cellDefaultFontFace_d;
    private int cellDefaultFontSize_d;
    private String cellDefaultFontType_d;
    private String cellDefaultVerticalAlignment_d = "center";
    private boolean createFromTemplate_d;
    private String defaultComboAlignment_d = "left";
    private int defaultTablePadding_d = 7;
    private int defaultTableSpacing_d;
    private FontStyle defaultTextFontStyle;
    private String labelCellDefaultAlignment = "right";
    private boolean labelSeparateUnderscoresAndCaps = true;
    private boolean labelShiftFirstLetter = true;
    private boolean labelShiftSeparatedWords;
    private String numberlDefaultAlignment_d = "right";
    private String presentationBackGround_d;
    private String textCellDefaultAlignment_d = "left";
    private String textDefaultAlignment_d = "left";
    private String textDefaultBgColor_d;
    private int textDefaultColQty_d = 5;
    private String textDefaultFgColor_d;
    private int textDefaultFontSize_d;
    private boolean useDefaultLayout_d = true;
    public static final String H1_BACKGROUND_COLOR = "#333333";
    public static final String H6_BACKGROUND_COLOR = "#A8A8A8";
    public static final String H1_FOREGROUND_COLOR = "#000000";
    public static final String H6_FOREGROUND_COLOR = "#FFFFFF";
    public static final String BODY_BACKGROUND_COLOR = "#FFFFFF";
    private static final File PRESENTATION_OPTIONS_FILE = FuegoDirectories.homeRelativeFile("presentationOptions");
    private static PresentationGenerationOptions presentationOptions;
    public static final String CELLDEFAULTALIGNMENT = "left";
    public static final String LABELCELLDEFAULTALIGNMENT = "right";
    public static final String TEXTCELLDEFAULTALIGNMENT = "left";
    public static final String NUMBERDEFAULTALIGNMENT = "right";
    public static final String DEFAULT_FONT_TYPE = "Verdana";
    public static final int DEFAULT_FONT_SIZE = 10;

    private PresentationGenerationOptions() {
        this.loadButtonDisplays();
    }

    public static PresentationGenerationOptions load() {
        PresentationGenerationOptions options = presentationOptions;
        if (options == null) {
            options = new PresentationGenerationOptions();
            try {
                if (PRESENTATION_OPTIONS_FILE.exists()) {
                    new PresentationOptionsLoader(PRESENTATION_OPTIONS_FILE, options);
                } else {
                    options.reset();
                }
            }
            catch (Exception e) {
                Log.logWarning(e);
            }
            presentationOptions = options;
        }
        return options;
    }

    public void setButtonDefaultDisplay(String[] display) {
        assert (display != null && this.buttonsDisplay_d.length >= display.length) : "Error: display = " + ArrayUtils.toString(display) + " should be equal to buttonsDisplay_d = " + ArrayUtils.toString(this.buttonsDisplay_d);
        this.buttonsDisplay_d = display;
    }

    public void setButtonPanelLayout(int[] layout) {
        assert (layout != null);
        this.buttonPanelLayout_d = layout;
    }

    public int[] getButtonPanelLayout() {
        return this.buttonPanelLayout_d;
    }

    public void setButtonsTransparent(boolean transparent) {
        this.buttonsTransparent_d = transparent;
    }

    public void setCancelButtonDefaultDisplay(String text) {
        assert (text != null);
        this.buttonsDisplay_d[1] = text;
    }

    public String getCancelButtonDefaultDisplay() {
        return this.buttonsDisplay_d[1];
    }

    public void setCellDefaultAlignment(String align) {
        assert (align != null);
        this.cellDefaultAlignment_d = align;
    }

    public String getCellDefaultAlignment() {
        return this.cellDefaultAlignment_d;
    }

    public void setCellDefaultFontSize(int s) {
        this.cellDefaultFontSize_d = s;
    }

    public int getCellDefaultFontSize() {
        return this.cellDefaultFontSize_d;
    }

    public void setCellDefaultFontStyle(FontStyle fontStyle) {
        this.cellDefaultFontFace_d = fontStyle;
    }

    public FontStyle getCellDefaultFontStyle() {
        return this.cellDefaultFontFace_d;
    }

    public void setCellDefaultFontType(String cellDefaultFontType) {
        this.cellDefaultFontType_d = cellDefaultFontType;
    }

    public String getCellDefaultFontType() {
        return this.cellDefaultFontType_d;
    }

    public void setCellDefaultVerticalAlignment(String align) {
        assert (align != null);
        this.cellDefaultVerticalAlignment_d = align;
    }

    public String getCellDefaultVerticalAlignment() {
        return this.cellDefaultVerticalAlignment_d;
    }

    public void setCreateFromTemplate(boolean createFromTemplate) {
        this.createFromTemplate_d = createFromTemplate;
    }

    public String getDefaultButtonDisplay(int index) {
        return this.buttonsDisplay_d[index];
    }

    public void setDefaultComboAlignment(String text) {
        assert (text != null);
        this.defaultComboAlignment_d = text;
    }

    public String getDefaultComboAlignment() {
        return this.defaultComboAlignment_d;
    }

    public void setDefaultTablePadding(int defaultTablePadding) {
        this.defaultTablePadding_d = defaultTablePadding;
    }

    public int getDefaultTablePadding() {
        return this.defaultTablePadding_d;
    }

    public void setDefaultTableSpacing(int defaultTableSpacing) {
        this.defaultTableSpacing_d = defaultTableSpacing;
    }

    public int getDefaultTableSpacing() {
        return this.defaultTableSpacing_d;
    }

    public void setNumberDefaultAlignment(String numberDefaultAlignment) {
        this.numberlDefaultAlignment_d = numberDefaultAlignment;
    }

    public String getNumberDefaultAlignment() {
        return this.numberlDefaultAlignment_d;
    }

    public void setOkButtonDefaultDisplay(String text) {
        assert (text != null);
        this.buttonsDisplay_d[0] = text;
    }

    public String getOkButtonDefaultDisplay() {
        return this.buttonsDisplay_d[0];
    }

    public void setPresentationBackGround(String presentationBackGround) {
        this.presentationBackGround_d = presentationBackGround;
    }

    public String getPresentationBackGround() {
        return this.presentationBackGround_d;
    }

    public void setRefreshButtonDefaultDisplay(String text) {
        assert (text != null);
        this.buttonsDisplay_d[3] = text;
    }

    public String getRefreshButtonDefaultDisplay() {
        return this.buttonsDisplay_d[3];
    }

    public void setResetButtonDefaultDisplay(String text) {
        assert (text != null);
        this.buttonsDisplay_d[2] = text;
    }

    public String getResetButtonDefaultDisplay() {
        return this.buttonsDisplay_d[2];
    }

    public void setTextCellDefaultAlignment(String textCellDefaultAlignment) {
        this.textCellDefaultAlignment_d = textCellDefaultAlignment;
    }

    public String getTextCellDefaultAlignment() {
        return this.textCellDefaultAlignment_d;
    }

    public void setTextDefaultAlignment(String text) {
        assert (text != null);
        this.textDefaultAlignment_d = text;
    }

    public String getTextDefaultAlignment() {
        return this.textDefaultAlignment_d;
    }

    public void setTextDefaultBgColor(String textBgColor) {
        this.textDefaultBgColor_d = textBgColor;
    }

    public String getTextDefaultBgColor() {
        return this.textDefaultBgColor_d;
    }

    public void setTextDefaultColQty(int col) {
        this.textDefaultColQty_d = col;
    }

    public int getTextDefaultColQty() {
        return this.textDefaultColQty_d;
    }

    public void setTextDefaultFgColor(String textFgColor) {
        this.textDefaultFgColor_d = textFgColor;
    }

    public String getTextDefaultFgColor() {
        return this.textDefaultFgColor_d;
    }

    public void setTextDefaultFontSize(int s) {
        this.textDefaultFontSize_d = s;
    }

    public int getTextDefaultFontSize() {
        return this.textDefaultFontSize_d;
    }

    public void setTextDefaultFontStyle(FontStyle textFontStyle) {
        this.defaultTextFontStyle = textFontStyle;
    }

    public boolean areButtonsTransparent() {
        return this.buttonsTransparent_d;
    }

    public boolean doCreateFromTemplate() {
        return this.createFromTemplate_d;
    }

    public void setLabelCellDefaultAlignment(String labelCellDefaultAlignment) {
        this.labelCellDefaultAlignment = labelCellDefaultAlignment;
    }

    public String getLabelCellDefaultAlignment() {
        return this.labelCellDefaultAlignment;
    }

    public void setLabelSeparateUnderscoresAndCaps(boolean labelSeparateUnderscoresAndCaps) {
        this.labelSeparateUnderscoresAndCaps = labelSeparateUnderscoresAndCaps;
    }

    public void setLabelShiftFirstLetter(boolean labelShiftFirstLetter) {
        this.labelShiftFirstLetter = labelShiftFirstLetter;
    }

    public void setLabelShiftSeparatedWords(boolean labelShiftSeparatedWords) {
        this.labelShiftSeparatedWords = labelShiftSeparatedWords;
    }

    public FontStyle getTextDefaultFontStyle() {
        return this.defaultTextFontStyle;
    }

    public void setUseDefaultLayout(boolean useDefaultLayout) {
        this.useDefaultLayout_d = useDefaultLayout;
    }

    public void apply(XFormPresentationXMLObject object) {
        switch (object.getComponentID()) {
            case 11: {
                this.applyTable((XFormTable)object);
                break;
            }
            case 15: 
            case 18: {
                this.applyRepeatable((XFormRepeatable)object);
                break;
            }
            case 10: {
                this.applyRow((XFormRow)object);
                break;
            }
            case 3: {
                this.applyCell((XFormCell)object);
                break;
            }
            case 12: {
                this.applyText((XFormText)object);
                break;
            }
            case 0: {
                this.applyCombo((XFormCombo)object);
                break;
            }
            case 2: {
                this.applyButton((XFormButton)object);
            }
        }
        if (object instanceof FontProperties) {
            FontProperties fontProperties = (FontProperties)((Object)object);
            fontProperties.setFonttype(DEFAULT_FONT_TYPE);
        }
    }

    public boolean doLabelSeparateUnderscoresAndCaps() {
        return this.labelSeparateUnderscoresAndCaps;
    }

    public boolean doLabelShiftFirstLetter() {
        return this.labelShiftFirstLetter;
    }

    public boolean doLabelShiftSeparatedWords() {
        return this.labelShiftSeparatedWords;
    }

    public void reset() {
        this.presentationBackGround_d = "#FFFFFF";
        this.useDefaultLayout_d = false;
        this.cellDefaultFontFace_d = null;
        this.cellDefaultFontType_d = null;
        this.defaultTextFontStyle = null;
        this.textDefaultBgColor_d = ColorProperties.DEFAULT_BACKGROUND_COLOR;
        this.textDefaultFgColor_d = ColorProperties.DEFAULT_FOREGROUND_COLOR;
        this.buttonPanelLayout_d = new int[]{0, 1};
        this.cellDefaultAlignment_d = "left";
        this.cellDefaultVerticalAlignment_d = "center";
        this.cellDefaultFontSize_d = 0;
        this.defaultComboAlignment_d = "left";
        this.textDefaultColQty_d = 20;
        this.textDefaultFontSize_d = 12;
        this.textDefaultAlignment_d = "left";
        this.numberlDefaultAlignment_d = "right";
        this.textCellDefaultAlignment_d = "left";
        this.buttonsTransparent_d = true;
        this.defaultTablePadding_d = 7;
        this.defaultTableSpacing_d = 0;
        this.createFromTemplate_d = true;
        this.labelCellDefaultAlignment = "right";
        this.labelShiftFirstLetter = true;
        this.labelSeparateUnderscoresAndCaps = true;
        this.labelShiftSeparatedWords = true;
        this.loadButtonDisplays();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(PRESENTATION_OPTIONS_FILE);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, Literals.DEFAULT_ENCODING);
            this.writeXML(writer);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean useDefaultLayout() {
        return this.useDefaultLayout_d;
    }

    private static String toXMLString(String[] array) {
        StringBuilder buttonsDisplay = new StringBuilder();
        for (String str : array) {
            if (buttonsDisplay.length() > 0) {
                buttonsDisplay.append(';');
            }
            buttonsDisplay.append(str);
        }
        return buttonsDisplay.toString();
    }

    private static String toXMLString(int[] array) {
        StringBuilder layoutString = new StringBuilder();
        for (int n : array) {
            if (layoutString.length() > 0) {
                layoutString.append(';');
            }
            layoutString.append(n);
        }
        return layoutString.toString();
    }

    private void applyButton(XFormButton xFormButton) {
        xFormButton.transparent = this.areButtonsTransparent();
        String action = xFormButton.action;
        if (action != null) {
            for (int i = 0; i < XFormButton.possibleAction_d.length && i < this.buttonsDisplay_d.length; ++i) {
                if (!action.equals(XFormButton.possibleAction_d[i])) continue;
                xFormButton.display = this.buttonsDisplay_d[i];
                if (xFormButton.isSubmit()) {
                    xFormButton.setBgcolor(H1_BACKGROUND_COLOR);
                    xFormButton.setFgcolor("#FFFFFF");
                    xFormButton.transparent = false;
                    xFormButton.setCssClass("fo_footer_submit_button");
                    break;
                }
                if (!xFormButton.isCancel()) break;
                xFormButton.setBgcolor(H6_BACKGROUND_COLOR);
                xFormButton.setFgcolor("#FFFFFF");
                xFormButton.transparent = false;
                xFormButton.setCssClass("fo_footer_cancel_button");
                break;
            }
        }
    }

    private void applyCell(XFormCell xFormCell) {
        xFormCell.setValignment(this.getCellDefaultVerticalAlignment());
        xFormCell.setAlignment(this.getCellDefaultAlignment());
    }

    private void applyCombo(XFormCombo xFormCombo) {
        xFormCombo.alignment = this.getDefaultComboAlignment();
    }

    private void applyRepeatable(XFormRepeatable xFormRepeatable) {
        xFormRepeatable.setHeaderfgcolor(H1_FOREGROUND_COLOR);
        xFormRepeatable.setBgcolor("#DEDFE1");
        xFormRepeatable.setHeaderbgcolor("#C2C2C2");
        xFormRepeatable.setHeaderfgcolor(H1_FOREGROUND_COLOR);
        xFormRepeatable.setHeaderfonttype(DEFAULT_FONT_TYPE);
        xFormRepeatable.setHeaderfontsize(10);
        xFormRepeatable.setHeaderFontStyle(FontStyle.BOLD);
        xFormRepeatable.setIndexbgcolor("#DEDFE1");
        xFormRepeatable.setIndexfgcolor(H1_FOREGROUND_COLOR);
        xFormRepeatable.setPagingbgcolor("#C2C2C2");
        xFormRepeatable.setPagingfgcolor(H1_FOREGROUND_COLOR);
        xFormRepeatable.setPagingfonttype(DEFAULT_FONT_TYPE);
        xFormRepeatable.setPagingfontsize(10);
        if (xFormRepeatable.row != null) {
            this.applyRow(xFormRepeatable.row);
        }
    }

    private void applyRow(XFormRow xFormRow) {
        if (xFormRow.cell != null) {
            for (XFormCell cell : xFormRow.cell) {
                this.applyCell(cell);
            }
        }
    }

    private void applyTable(XFormTable xFormTable) {
        xFormTable.cellpadding = this.getDefaultTablePadding();
        xFormTable.cellspacing = this.getDefaultTableSpacing();
        if (xFormTable.row != null) {
            for (XFormRow row : xFormTable.row) {
                this.applyRow(row);
            }
        }
    }

    private void applyText(XFormText xFormText) {
        xFormText.setFgcolor(this.getTextDefaultFgColor());
        xFormText.setBgcolor(this.getTextDefaultBgColor());
        xFormText.setFontStyle(this.getTextDefaultFontStyle());
        xFormText.setFontsize(this.getTextDefaultFontSize());
        xFormText.alignment = this.getTextDefaultAlignment();
        xFormText.setColqty(this.getTextDefaultColQty());
    }

    private void loadButtonDisplays() {
        this.buttonsDisplay_d = new String[XFormButton.possibleAction_d.length];
        for (int i = 0; i < this.buttonsDisplay_d.length; ++i) {
            String display = null;
            switch (i) {
                case 4: {
                    display = CoreMsg.ACTION.getString();
                    break;
                }
                case 0: {
                    display = CoreMsg.SUBMIT.getString();
                    break;
                }
                case 1: {
                    display = CoreMsg.CANCEL.getString();
                    break;
                }
                case 3: {
                    display = CoreMsg.REFRESH.getString();
                    break;
                }
                case 2: {
                    display = CoreMsg.RESET.getString();
                    break;
                }
                case 5: {
                    display = CoreMsg.SAVE.getString();
                    break;
                }
                case 6: {
                    display = CoreMsg.PRINT.getString();
                }
            }
            this.buttonsDisplay_d[i] = display;
        }
    }

    private void writeXML(OutputStreamWriter writer) throws IOException {
        XmlWriter xmlWriter = new XmlWriter(writer, "UTF-8");
        xmlWriter.startDocument();
        xmlWriter.startElement("PresentationOptions");
        xmlWriter.startElement("presentation");
        xmlWriter.printAttribute("presentationBackGround", this.presentationBackGround_d);
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("useDefaultLayout", this.useDefaultLayout_d);
        xmlWriter.setIgnoreEmpty(true);
        xmlWriter.printAttribute("createFromTemplate", this.createFromTemplate_d);
        xmlWriter.printAttribute("buttonPanelLayout", PresentationGenerationOptions.toXMLString(this.buttonPanelLayout_d));
        xmlWriter.endElement();
        xmlWriter.startElement("table");
        xmlWriter.printAttribute("tablePadding", this.defaultTablePadding_d);
        xmlWriter.printAttribute("tableSpacing", this.defaultTableSpacing_d);
        xmlWriter.endElement();
        xmlWriter.startElement("cell");
        xmlWriter.printAttribute("cellDefaultFontFace", this.cellDefaultFontFace_d);
        xmlWriter.printAttribute("cellDefaultFontType", this.cellDefaultFontType_d);
        xmlWriter.printAttribute("cellDefaultAlignment", this.cellDefaultAlignment_d);
        xmlWriter.printAttribute("cellDefaultVerticalAlignment", this.cellDefaultVerticalAlignment_d);
        xmlWriter.printAttribute("cellDefaultFontSize", this.cellDefaultFontSize_d);
        xmlWriter.endElement();
        xmlWriter.startElement("text");
        xmlWriter.printAttribute("textDefaultFontFace", this.defaultTextFontStyle != null ? this.defaultTextFontStyle.toString() : null);
        xmlWriter.printAttribute("textDefaultBgColor", this.textDefaultBgColor_d);
        xmlWriter.printAttribute("textDefaultFgColor", this.textDefaultFgColor_d);
        xmlWriter.printAttribute("textDefaultColQty", this.textDefaultColQty_d);
        xmlWriter.printAttribute("textDefaultFontSize", this.textDefaultFontSize_d);
        xmlWriter.printAttribute("textDefaultAlignment", this.textDefaultAlignment_d);
        xmlWriter.printAttribute("numberDefaultAlignment", this.numberlDefaultAlignment_d);
        xmlWriter.printAttribute("textCellDefaultAlignment", this.textCellDefaultAlignment_d);
        xmlWriter.endElement();
        xmlWriter.startElement("combo");
        xmlWriter.printAttribute("defaultComboAlignment", this.defaultComboAlignment_d);
        xmlWriter.endElement();
        xmlWriter.startElement("button");
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("buttonsTransparent", this.buttonsTransparent_d);
        xmlWriter.setIgnoreEmpty(true);
        xmlWriter.printAttribute("buttonsDisplay", PresentationGenerationOptions.toXMLString(this.buttonsDisplay_d));
        xmlWriter.endElement();
        xmlWriter.startElement("label");
        xmlWriter.printAttribute("labelCellDefaultAlignment", this.labelCellDefaultAlignment);
        xmlWriter.setIgnoreEmpty(false);
        xmlWriter.printAttribute("labelSeparateUnderscoresAndCaps", this.labelSeparateUnderscoresAndCaps);
        xmlWriter.printAttribute("labelShiftFirstLetter", this.labelShiftFirstLetter);
        xmlWriter.printAttribute("labelShiftSeparatedWords", this.labelShiftSeparatedWords);
        xmlWriter.setIgnoreEmpty(true);
        xmlWriter.endElement();
        xmlWriter.endElement();
    }

    public static class PresentationOptionsLoader
    implements ContentHandler {
        private File file_d;
        private PresentationGenerationOptions preferences_d;
        private List warningList_d = new ArrayList();

        public PresentationOptionsLoader(File f, PresentationGenerationOptions pref) throws Exception {
            this.file_d = f;
            this.preferences_d = pref;
            this.load();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        public List getWarningList() {
            return this.warningList_d;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (!"PresentationOptions".equals(qName)) {
                if ("presentation".equals(qName)) {
                    this.managePresentation(atts);
                } else if ("table".equals(qName)) {
                    this.manageTable(atts);
                } else if ("cell".equals(qName)) {
                    this.manageCell(atts);
                } else if ("text".equals(qName)) {
                    this.manageText(atts);
                } else if ("combo".equals(qName)) {
                    this.manageCombo(atts);
                } else if ("button".equals(qName)) {
                    this.manageButton(atts);
                } else if ("label".equals(qName)) {
                    this.manageLabel(atts);
                } else {
                    Log.logDebug("Name: " + qName + " not found when parsing presentation options");
                }
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        private void load() throws Exception {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader parser = sp.getXMLReader();
            parser.setContentHandler(this);
            parser.parse("file:" + this.file_d.getAbsolutePath());
        }

        private void manageButton(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if ("buttonsTransparent".equals(attname)) {
                    this.preferences_d.setButtonsTransparent(Boolean.parseBoolean(value));
                    continue;
                }
                if (!"buttonsDisplay".equals(attname)) continue;
                StringTokenizer st = new StringTokenizer(value, ";");
                String[] buttonsDisplay = new String[st.countTokens()];
                int j = 0;
                while (st.hasMoreTokens()) {
                    buttonsDisplay[j] = st.nextToken();
                    ++j;
                }
                this.preferences_d.setButtonDefaultDisplay(buttonsDisplay);
            }
        }

        private void manageCell(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if ("cellDefaultFontFace".equals(attname)) {
                    this.preferences_d.setCellDefaultFontStyle(FontStyle.fromString(value));
                    continue;
                }
                if ("cellDefaultFontType".equals(attname)) {
                    this.preferences_d.setCellDefaultFontType(value);
                    continue;
                }
                if ("cellDefaultAlignment".equals(attname)) {
                    this.preferences_d.setCellDefaultAlignment(value);
                    continue;
                }
                if ("cellDefaultVerticalAlignment".equals(attname)) {
                    this.preferences_d.setCellDefaultVerticalAlignment(value);
                    continue;
                }
                if (!"cellDefaultFontSize".equals(attname)) continue;
                this.preferences_d.setCellDefaultFontSize(Integer.parseInt(value));
            }
        }

        private void manageCombo(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if (!"defaultComboAlignment".equals(attname)) continue;
                this.preferences_d.setDefaultComboAlignment(value);
            }
        }

        private void manageLabel(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if ("labelCellDefaultAlignment".equals(attname)) {
                    this.preferences_d.setLabelCellDefaultAlignment(value);
                    continue;
                }
                if ("labelSeparateUnderscoresAndCaps".equals(attname)) {
                    this.preferences_d.setLabelSeparateUnderscoresAndCaps(Boolean.parseBoolean(value));
                    continue;
                }
                if ("labelShiftFirstLetter".equals(attname)) {
                    this.preferences_d.setLabelShiftFirstLetter(Boolean.parseBoolean(value));
                    continue;
                }
                if (!"labelShiftSeparatedWords".equals(attname)) continue;
                this.preferences_d.setLabelShiftSeparatedWords(Boolean.parseBoolean(value));
            }
        }

        private void managePresentation(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if ("presentationBackGround".equals(attname)) {
                    this.preferences_d.setPresentationBackGround(value);
                    continue;
                }
                if ("useDefaultLayout".equals(attname)) {
                    this.preferences_d.setUseDefaultLayout(Boolean.parseBoolean(value));
                    continue;
                }
                if ("buttonPanelLayout".equals(attname)) {
                    StringTokenizer st = new StringTokenizer(value, ";");
                    int[] buttonLayout = new int[st.countTokens()];
                    int j = 0;
                    while (st.hasMoreTokens()) {
                        String s = st.nextToken();
                        buttonLayout[j] = Integer.parseInt(s);
                        ++j;
                    }
                    this.preferences_d.setButtonPanelLayout(buttonLayout);
                    continue;
                }
                if (!"createFromTemplate".equals(attname)) continue;
                this.preferences_d.setCreateFromTemplate(Boolean.parseBoolean(value));
            }
        }

        private void manageTable(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if ("tablePadding".equals(attname)) {
                    try {
                        this.preferences_d.setDefaultTablePadding(Integer.parseInt(value));
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (!"tableSpacing".equals(attname)) continue;
                try {
                    this.preferences_d.setDefaultTableSpacing(Integer.parseInt(value));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        private void manageText(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if ("textDefaultFontFace".equals(attname)) {
                    this.preferences_d.setTextDefaultFontStyle(FontStyle.fromString(value));
                    continue;
                }
                if ("textDefaultFgColor".equals(attname)) {
                    this.preferences_d.setTextDefaultFgColor(value);
                    continue;
                }
                if ("textDefaultBgColor".equals(attname)) {
                    this.preferences_d.setTextDefaultBgColor(value);
                    continue;
                }
                if ("textDefaultAlignment".equals(attname)) {
                    this.preferences_d.setTextDefaultAlignment(value);
                    continue;
                }
                if ("textCellDefaultAlignment".equals(attname)) {
                    this.preferences_d.setTextCellDefaultAlignment(value);
                    continue;
                }
                if ("textDefaultFontSize".equals(attname)) {
                    this.preferences_d.setTextDefaultFontSize(Integer.parseInt(value));
                    continue;
                }
                if (!"textDefaultColQty".equals(attname)) continue;
                this.preferences_d.setTextDefaultColQty(Integer.parseInt(value));
            }
        }
    }
}

