/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum GraphicType implements I18nProvider
{
    GAUGE_SPEEDOMETER(LibMsg.SPEEDOMETER, 0, "GAUGE"),
    GAUGE_THERMOMETER(LibMsg.THERMOMETER, 1, "GAUGE"),
    PIE(LibMsg.PIE, 0, "XY"),
    PIE3D(LibMsg.PIE3D, 1, "XY"),
    MULTIPLE_PIE(LibMsg.MULTIPLE_PIE, 0, "XYZ"),
    MULTIPLE_PIE3D(LibMsg.MULTIPLE_PIE3D, 1, "XYZ"),
    BAR_CHART(LibMsg.BAR_CHART, 2, "XYZ"),
    BAR_CHART_3D(LibMsg.BAR_CHART_3D, 3, "XYZ"),
    STACKED_BAR_CHART(LibMsg.STACKED_BAR_CHART, 4, "XYZ"),
    STACKED_BAR_CHART_3D(LibMsg.STACKED_BAR_CHART_3D, 5, "XYZ"),
    AREA_CHART(LibMsg.AREA_CHART, 6, "XYZ"),
    STACKED_AREA_CHART(LibMsg.STACKED_AREA_CHART, 7, "XYZ"),
    LINE_CHART(LibMsg.LINE_CHART, 8, "XYZ"),
    WATERFALL_CHART(LibMsg.WATERFALL_CHART, 9, "XYZ");

    private int graphicCode;
    private String graphicType;
    private static final int GAUGE_TYPE_QTY = 2;
    private static final int XY_TYPE_QTY = 2;
    private transient Msg msg;
    public static final String GAUGE_TYPE = "GAUGE";
    public static final String XY_TYPE = "XY";
    public static final String XYZ_TYPE = "XYZ";

    private GraphicType(Msg msg, int graphicCode, String graphicType) {
        this.msg = msg;
        this.graphicCode = graphicCode;
        this.graphicType = graphicType;
    }

    public static GraphicType valueOf(int ordinal) {
        GraphicType[] types = GraphicType.values();
        return ordinal < 0 || ordinal >= types.length ? null : types[ordinal];
    }

    public static GraphicType valueOf(String graphicType, int typeCode) {
        Object result = null;
        if (graphicType.toUpperCase().indexOf(XYZ_TYPE) != -1) {
            typeCode = typeCode + 2 + 2;
        } else if (graphicType.toUpperCase().indexOf(XY_TYPE) != -1) {
            typeCode += 2;
        }
        return GraphicType.valueOf(typeCode);
    }

    public int getGraphicCode() {
        return this.graphicCode;
    }

    public String getGraphicType() {
        return this.graphicType;
    }

    @Exclude
    public static List<GraphicType> getSubtypes(String type) {
        ArrayList<GraphicType> list = new ArrayList<GraphicType>();
        GraphicType[] types = GraphicType.values();
        for (int i = 0; i < types.length; ++i) {
            GraphicType subtype = types[i];
            if (!subtype.getGraphicType().equals(type)) continue;
            list.add(subtype);
        }
        list.remove(MULTIPLE_PIE);
        list.remove(MULTIPLE_PIE3D);
        return list;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    @Exclude
    public Msg getMsg() {
        return this.msg;
    }
}

