/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xml;

import fuego.directory.msg.DirectoryMsg;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.bpm.lang.FormatException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;

public class XmlTag {
    private Map<Object, String> map = new HashMap<Object, String>();
    private String name;

    public XmlTag() {
    }

    public XmlTag(String name) {
        this();
        this.name = name;
    }

    public static XmlTag createXmlTag(String source) {
        int i;
        if ((source = source.trim()).length() == 0 || source.charAt(0) != '<' && !source.endsWith("/>")) {
            return XmlTag.invalidFormat(source);
        }
        StringBuffer tag = new StringBuffer();
        for (i = 1; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c != ' ') {
                tag.append(c);
                continue;
            }
            if (tag.length() != 0) break;
        }
        XmlTag result = new XmlTag(tag.toString());
        int insideQuotes = 32;
        boolean gettingAttr = true;
        boolean gettingValue = false;
        StringBuffer attr = new StringBuffer();
        StringBuffer value = new StringBuffer();
        while (i < source.length() - 2) {
            int c = source.charAt(i);
            if (c != 32 || insideQuotes != 32 || gettingValue) {
                if (gettingAttr) {
                    if (c != 61) {
                        attr.append((char)c);
                    } else {
                        gettingAttr = false;
                    }
                } else if (!gettingValue) {
                    gettingValue = true;
                    if (c == 34 || c == 39) {
                        insideQuotes = c;
                    } else {
                        value.append((char)c);
                    }
                } else if (c != insideQuotes) {
                    value.append((char)c);
                } else {
                    result.map.put(attr.toString(), value.toString());
                    attr.setLength(0);
                    value.setLength(0);
                    gettingAttr = true;
                    gettingValue = false;
                    insideQuotes = 32;
                }
            }
            ++i;
        }
        if (gettingValue) {
            result.map.put(attr.toString(), value.toString());
        }
        return result;
    }

    public String getAttribute(String attr) {
        return this.map.get(attr);
    }

    public boolean getBoolean(String attr) {
        String b = this.getAttribute(attr);
        return b != null && b.equalsIgnoreCase(Boolean.toString(true));
    }

    public int getInteger(String attr) {
        String integer = this.getAttribute(attr);
        return integer == null ? 0 : Integer.parseInt(integer);
    }

    public Interval getInterval(String attr) {
        String interval = this.getAttribute(attr);
        return interval == null ? Interval.ZERO : Interval.valueOf(interval);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Time getTime(String attr) {
        String time = this.getAttribute(attr);
        return time == null ? null : Time.valueOf(time);
    }

    public void putAttribute(String attr, String value) {
        if (value != null && value.length() > 0) {
            this.map.put(attr, value);
        }
    }

    public void putAttribute(String attr, Object value) {
        if (value != null) {
            this.map.put(attr, value.toString());
        }
    }

    public void putAttribute(String attr, boolean value) {
        if (value) {
            this.map.put(attr, Boolean.toString(value));
        }
    }

    public void putAttribute(String attr, int value) {
        if (value != 0) {
            this.map.put(attr, Integer.toString(value));
        }
    }

    public void putAttribute(String attr, Interval value) {
        if (value != null && value != Interval.ZERO) {
            this.map.put(attr, value.toXMLString());
        }
    }

    public void putAttribute(String attr, Time value) {
        if (value != null) {
            this.map.put(attr, value.toXMLString());
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('<');
        result.append(this.name);
        result.append(' ');
        Iterator<Map.Entry<Object, String>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, String> entry = iterator.next();
            result.append(entry.getKey());
            result.append("=\"");
            result.append(entry.getValue());
            result.append('\"');
            if (!iterator.hasNext()) continue;
            result.append(' ');
        }
        result.append('/');
        result.append('>');
        return result.toString();
    }

    private static XmlTag invalidFormat(String source) {
        throw new FormatException(DirectoryMsg.INVALID_TAG(source));
    }
}

