/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util.documentation;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import oracle.bpm.util.StringTokenizer;

public final class DocumentationUtils {
    private static final String HTML_MARK = "#html_doc#";

    private DocumentationUtils() {
    }

    public static String getDocumentation(JTextPane textPane) {
        String realText;
        String result = "";
        Document document = textPane.getDocument();
        try {
            realText = document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            realText = "error";
        }
        if (realText != null && !realText.equals("") && !realText.equals("\n")) {
            StringBuilder sb = new StringBuilder();
            DocInfo info = DocumentationUtils.buildDocInfoToSave(textPane);
            sb.append(info.html);
            result = sb.toString();
        }
        return result;
    }

    public static DocInfo buildDocInfoToSave(JTextPane textPane) {
        DocInfo result = new DocInfo();
        result.html = textPane.getText();
        return result;
    }

    public static boolean insideHTMLTag(Element e, HTML.Tag tag) {
        Object value = e.getAttributes().getAttribute(StyleConstants.NameAttribute);
        return tag.equals(value) || e.getParentElement() != null && DocumentationUtils.insideHTMLTag(e.getParentElement(), tag);
    }

    public static void loadDocumentation(JTextPane textPane, String documentString) {
        assert (documentString != null);
        DocInfo docInfo = DocumentationUtils.buildDocInfo(documentString);
        if (docInfo == null) {
            textPane.setDocument(textPane.getEditorKit().createDefaultDocument());
        } else {
            try {
                textPane.read(new StringReader(docInfo.html), null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static DocInfo buildDocInfo(String doc) {
        if (doc == null || doc.length() == 0) {
            return null;
        }
        DocInfo result = new DocInfo();
        String html = null;
        if (doc.startsWith(HTML_MARK)) {
            StringTokenizer st = new StringTokenizer(doc.substring(HTML_MARK.length()), "#@#");
            while (st.hasMoreTokens()) {
                String imageS = st.nextToken();
                if (!imageS.startsWith(HTML_MARK)) continue;
                html = imageS.substring(HTML_MARK.length());
                break;
            }
        } else {
            html = doc;
        }
        assert (html != null) : "html cannot be null";
        result.html = html.startsWith("<html>") ? html : "<html><body>" + html + "</body></html>";
        return result;
    }

    public static class DocInfo {
        public String html;
        public Map<String, byte[]> images = new HashMap<String, byte[]>();
    }
}

