/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.IllegalArgException;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.log.Log;
import oracle.bpm.util.InvokeException;
import oracle.bpm.util.StdStreamConsumer;

public class Utilities {
    private Utilities() {
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toUpperCase().startsWith("MAC");
    }

    public static Object invokeMethod(Object target, String method) throws ComponentExecutionException, IllegalArgException {
        return Utilities.invokeMethod(target, method, (Object[])null);
    }

    public static Object invokeMethod(Object target, String method, Object arg) throws ComponentExecutionException, IllegalArgException {
        Object[] oArray = new Object[]{arg};
        return Utilities.invokeMethod(target, method, oArray);
    }

    public static Object invokeMethod(Object target, String method, String argumentClassName) throws ComponentExecutionException, IllegalArgException {
        Object[] oArray = new Object[1];
        try {
            oArray[0] = Class.forName(argumentClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new InvokeException(e, target.getClass(), method);
        }
        catch (ClassNotFoundException e) {
            throw new InvokeException(e, target.getClass(), method);
        }
        catch (IllegalAccessException e) {
            throw new InvokeException(e, target.getClass(), method);
        }
        return Utilities.invokeMethod(target, method, oArray);
    }

    public static Object invokeMethod(Object target, String method, String targetArgumentClassName, Object sourceArgument) throws ComponentExecutionException, IllegalArgException {
        try {
            Class<?> targetClass = Class.forName(targetArgumentClassName);
            Object targetArgument = DynamicObject.valueOf(sourceArgument).convertTo(targetClass);
            return Utilities.invokeMethod(target, method, targetArgument);
        }
        catch (ClassNotFoundException e) {
            throw new InvokeException(e, target.getClass(), method);
        }
    }

    public static Object invokeMethod(Object target, String method, Object[] args) throws ComponentExecutionException, IllegalArgException {
        Class<?> cls = target.getClass();
        Class[] argsClass = null;
        if (args != null) {
            argsClass = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argsClass[i] = args[i].getClass();
            }
        }
        try {
            if (Log.isDebugging()) {
                Log.logDebug("Invking method: " + method);
            }
            Method m = cls.getMethod(method, argsClass);
            return m.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw new ComponentExecutionException(e, cls, method);
        }
        catch (IllegalAccessException e) {
            throw new InvokeException(e, cls, method);
        }
        catch (NoSuchMethodException e) {
            Method[] m;
            for (Method aM : m = cls.getMethods()) {
                if (!method.equals(aM.getName())) continue;
                throw new IllegalArgException(aM, args);
            }
            throw new InvokeException(e, cls, method);
        }
        catch (SecurityException e) {
            throw new InvokeException(e, cls, method);
        }
    }

    public static Object parseObject(String text, Class clazz) {
        return Utilities.parseObject(text, clazz, null);
    }

    public static Object parseObject(String text, Class clazz, Object def) {
        block11: {
            assert (text != null) : "text can't be null";
            try {
                Method valueOf;
                try {
                    Class[] parameterTypes = new Class[]{String.class};
                    valueOf = clazz.getMethod("valueOf", parameterTypes);
                }
                catch (NoSuchMethodException exc) {
                    Class[] parameterTypes = new Class[]{Object.class};
                    valueOf = clazz.getMethod("valueOf", parameterTypes);
                }
                return valueOf.invoke(null, text);
            }
            catch (NoSuchMethodException exc) {
                if (Log.isDebugging()) {
                    Log.logDebug(exc.getMessage());
                }
            }
            catch (IllegalAccessException exc) {
                if (Log.isDebugging()) {
                    Log.logDebug(exc.getMessage());
                }
            }
            catch (IllegalArgumentException exc) {
                if (Log.isDebugging()) {
                    Log.logDebug(exc.getMessage());
                }
            }
            catch (InvocationTargetException exc) {
                if (!Log.isDebugging()) break block11;
                Log.logDebug(exc.getMessage());
            }
        }
        return def;
    }

    public static void sleep(long t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Throwable unwrapException(Throwable t) {
        Throwable inner = null;
        if (t instanceof ComponentExecutionException) {
            inner = t.getCause();
        } else if (t instanceof RuntimeExceptionShell) {
            inner = ((RuntimeExceptionShell)t).getThrowable();
        } else if (t instanceof InvocationTargetException) {
            inner = ((InvocationTargetException)t).getTargetException();
        }
        if (inner == null) {
            return t;
        }
        return Utilities.unwrapException(inner);
    }

    public static int waitFor(Process p, OutputStream out) {
        int exitValue = -1;
        InputStream in = p.getInputStream();
        InputStream err = p.getErrorStream();
        StdStreamConsumer stdout = new StdStreamConsumer(out, in);
        StdStreamConsumer stderr = new StdStreamConsumer(out, err);
        stdout.start();
        stderr.start();
        try {
            exitValue = p.waitFor();
            stdout.join();
            stderr.join();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        return exitValue;
    }
}

