/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.util.Dumper;

public class UnixDumper
extends Dumper {
    @Override
    public boolean doThreadDump() {
        if (!this.appropriateIntervalBetweenDumps()) {
            return false;
        }
        if (System.getProperty("java.vendor").startsWith("IBM")) {
            return UnixDumper.raiseSignal();
        }
        return this.performKillCommand();
    }

    private static boolean raiseSignal() {
        try {
            Class<?> c = Class.forName("sun.misc.Signal");
            Method m = c.getDeclaredMethod("raise0", Integer.TYPE);
            m.setAccessible(true);
            m.invoke(null, 3);
        }
        catch (ClassNotFoundException e) {
            Log.logWarning(e);
            return false;
        }
        catch (NoSuchMethodException e) {
            Log.logWarning(e);
            return false;
        }
        catch (SecurityException e) {
            Log.logWarning(e);
            return false;
        }
        catch (IllegalAccessException e) {
            Log.logWarning(e);
            return false;
        }
        catch (IllegalArgumentException e) {
            Log.logWarning(e);
            return false;
        }
        catch (InvocationTargetException e) {
            Log.logWarning(e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performKillCommand() {
        block11: {
            try {
                Process p;
                try {
                    p = Runtime.getRuntime().exec("pid.sh");
                }
                catch (IOException e) {
                    Log.logWarning(e);
                    p = Runtime.getRuntime().exec(System.getProperty("user.dir") + File.separator + "pid.sh");
                }
                p.waitFor();
                BufferedReader is = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = is.readLine();
                if (line == null) break block11;
                int eol = line.indexOf("\n");
                if (eol > 0) {
                    line = line.substring(0, eol);
                }
                if ((line = line.trim()) != null && line.equals("")) {
                    Log.logWarning(LibMsg.PID_NULL_NUMBER);
                    return false;
                }
                int pid = Integer.parseInt(line);
                p = Runtime.getRuntime().exec(" kill -3 " + pid);
                p.waitFor();
                UnixDumper unixDumper = this;
                synchronized (unixDumper) {
                    this.wait(5000L);
                }
            }
            catch (IOException e) {
                Log.logWarning(e);
                return false;
            }
            catch (InterruptedException e) {
                Log.logWarning(e);
                return false;
            }
            catch (RuntimeException e) {
                Log.logWarning(e);
                return false;
            }
        }
        return true;
    }
}

