/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.bpm.log.Log;

public class StdStreamConsumer
extends Thread {
    protected InputStream in_d;
    protected OutputStream out_d;
    protected boolean stop_d;

    public StdStreamConsumer(OutputStream out, InputStream in) {
        this.out_d = out;
        this.in_d = in;
        this.stop_d = false;
    }

    public void setStop(boolean stop) {
        this.stop_d = stop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            int count;
            byte[] buf = new byte[512];
            boolean failed = false;
            while (!this.stop_d && (count = this.in_d.read(buf)) != -1) {
                if (failed || this.out_d == null) continue;
                OutputStream outputStream = this.out_d;
                synchronized (outputStream) {
                    try {
                        this.processInput(buf, count);
                    }
                    catch (IOException e) {
                        this.notifyFailure(e);
                        failed = true;
                    }
                }
            }
            return;
        }
        catch (IOException e) {
            this.notifyFailure(e);
        }
    }

    protected void notifyFailure(IOException e) {
        Log.logWarning(e);
    }

    protected void processInput(byte[] buf, int count) throws IOException {
        if (this.out_d != null) {
            this.out_d.write(buf, 0, count);
        }
    }
}

