/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceDiff {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("usage: ResourceDiff resource_class1 resource_class2");
            System.exit(-1);
        }
        ResourceBundle bundle1 = ResourceDiff.loadResource(args[0]);
        ResourceBundle bundle2 = ResourceDiff.loadResource(args[1]);
        ResourceDiff.compare(bundle1, bundle2, "<");
        ResourceDiff.compare(bundle2, bundle1, ">");
    }

    private static void compare(ResourceBundle bundle1, ResourceBundle bundle2, String prefix) {
        Enumeration<String> keys = bundle1.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            try {
                bundle2.getObject(key);
            }
            catch (MissingResourceException e) {
                System.out.println(prefix + key);
            }
        }
    }

    private static ResourceBundle loadResource(String classname) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = Class.forName(classname);
        return (ResourceBundle)clazz.newInstance();
    }
}

