/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import oracle.bpm.util.Properties;
import oracle.bpm.util.PropertyFilter;
import oracle.bpm.util.PropertyIterator;
import oracle.bpm.util.PropertyListener;
import oracle.bpm.util.PropertyValidationException;

public abstract class Property
implements PropertyListener {
    protected Object defValue_d;
    protected String description_d;
    protected boolean editable_d = true;
    protected PropertyFilter filter_d;
    protected boolean fixed_d;
    protected WeakHashMap<PropertyListener, Object> listeners_d;
    protected String name_d;
    protected boolean password_d;
    protected List<Object> predefinedValues_d;
    protected List<Property> subProperties_d = new ArrayList<Property>();
    protected Class type_d;
    protected Object value_d;

    public Property() {
        this.predefinedValues_d = new ArrayList<Object>();
        this.listeners_d = new WeakHashMap();
    }

    public String getDescription() {
        return this.description_d;
    }

    public boolean isEditable() {
        return !this.isFixed() && this.editable_d;
    }

    public PropertyFilter getFilter() {
        return this.filter_d;
    }

    public void setFixed(boolean fixed) {
        this.fixed_d = fixed;
    }

    public boolean isFixed() {
        return this.fixed_d;
    }

    public boolean isLeaf() {
        return this.subProperties_d.size() == 0;
    }

    public String getName() {
        return this.name_d;
    }

    public boolean isPassword() {
        return this.password_d;
    }

    public Iterator getPredefinedValues() {
        return this.predefinedValues_d.iterator();
    }

    public String getShortDescription() {
        return this.getText();
    }

    public PropertyIterator getSubProperties() {
        return new PropertyIterator(this.subProperties_d.iterator());
    }

    public int getSubPropertiesCount() {
        return this.subProperties_d.size();
    }

    public Property getSubProperty(int number) {
        return this.subProperties_d.get(number);
    }

    public Property getSubProperty(String name) {
        PropertyIterator properties = this.getSubProperties();
        while (properties.hasNext()) {
            Property property = properties.next();
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public String getText() {
        return this.value_d != null ? this.value_d.toString() : "";
    }

    public Class getType() {
        return this.type_d;
    }

    public void setValue(Object value) {
        this.value_d = value;
        this.fireDataChanged();
    }

    public Object getValue() {
        return this.value_d;
    }

    public void addPropertyListener(PropertyListener listener) {
        this.listeners_d.put(listener, null);
    }

    public Properties convertToProperties() {
        Properties result = new Properties();
        PropertyIterator iterator = this.getSubProperties();
        while (iterator.hasNext()) {
            Property each = iterator.next();
            result.setProperty(each.getName(), each.getValue().toString());
        }
        return result;
    }

    @Override
    public void dataChanged(Property root) {
        this.fireDataChanged(root);
    }

    public boolean hasPredefinedValues() {
        return this.predefinedValues_d.size() != 0;
    }

    public void removePropertyListener(PropertyListener listener) {
        this.listeners_d.remove(listener);
    }

    @Override
    public void structureChanged(Property root) {
        this.fireStructureChanged(root);
    }

    public void toDefault() {
        this.setValue(this.defValue_d);
    }

    public String toString() {
        return this.toText("");
    }

    public void validate() throws PropertyValidationException {
    }

    protected void setDefaultValue(Object value) {
        this.defValue_d = value;
    }

    protected void setDescription(String description) {
        this.description_d = description;
    }

    protected void setEditable(boolean editable) {
        this.editable_d = editable;
    }

    protected void setFilter(PropertyFilter filter) {
        this.filter_d = filter;
    }

    protected void setName(String name) {
        this.name_d = name;
    }

    protected void setPassword(boolean password) {
        this.password_d = password;
    }

    protected void setType(Class type) {
        this.type_d = type;
    }

    protected void addPredefinedValue(Object value) {
        this.predefinedValues_d.add(value);
    }

    protected void addProperty(Property property) {
        property.addPropertyListener(this);
        this.subProperties_d.add(property);
        this.fireStructureChanged();
    }

    protected void fireDataChanged() {
        this.fireDataChanged(this);
    }

    protected void fireDataChanged(Property root) {
        PropertyListener[] array = this.listeners_d.keySet().toArray(new PropertyListener[this.listeners_d.keySet().size()]);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            array[i].dataChanged(root);
        }
    }

    protected void fireStructureChanged() {
        this.fireStructureChanged(this);
    }

    protected void fireStructureChanged(Property root) {
        PropertyListener[] array;
        for (PropertyListener anArray : array = this.listeners_d.keySet().toArray(new PropertyListener[this.listeners_d.keySet().size()])) {
            if (anArray == null) continue;
            anArray.structureChanged(root);
        }
    }

    protected void removeAllProperties() {
        PropertyIterator subProperties = this.getSubProperties();
        while (subProperties.hasNext()) {
            subProperties.next().removeAllListeners();
        }
        this.subProperties_d.clear();
        this.fireStructureChanged();
    }

    protected void removeProperty(Property property) {
        property.removeAllListeners();
        this.subProperties_d.remove(property);
        this.fireStructureChanged();
    }

    private void removeAllListeners() {
        PropertyIterator subProperties = this.getSubProperties();
        while (subProperties.hasNext()) {
            subProperties.next().removeAllListeners();
        }
        this.listeners_d.clear();
    }

    private String toText(String tabs) {
        String text = "";
        text = text + tabs + this.getName() + " : " + this.getValue() + "\n";
        PropertyIterator properties = this.getSubProperties();
        while (properties.hasNext()) {
            text = text + properties.next().toText(tabs + "\t");
        }
        return text;
    }
}

