/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.util.LegacyGroupArray;
import oracle.bpm.util.LegacyMemberArray;

public class MemberArray
extends AbstractList {
    protected JavaClass executor;
    protected String getter;
    protected String setter;
    protected List targetList;

    protected MemberArray() {
    }

    protected MemberArray(List target, String getter, String setter, Class<?> javaMemberType) {
        this.targetList = target != null ? target : Collections.EMPTY_LIST;
        this.getter = getter;
        this.setter = setter;
        if (javaMemberType != null) {
            this.executor = JavaClass.fromClass(javaMemberType);
        }
    }

    public static MemberArray create(List target, String getter, String setter, Class javaMemberType) {
        if (target instanceof LegacyGroupArray) {
            return new LegacyMemberArray(target, getter, setter, javaMemberType);
        }
        return new MemberArray(target, getter, setter, javaMemberType);
    }

    @Override
    public Object get(int index) {
        if (this.getter == null) {
            throw new UnsupportedOperationException("Array is write only");
        }
        Object result = null;
        Object instance = this.targetList.get(index);
        if (instance != null) {
            if (this.executor == null || instance instanceof Invokeable) {
                Invokeable invokeable = (Invokeable)instance;
                result = invokeable.getAttributeValue(this.getter);
            } else {
                result = this.executor.getAttributeValue(this.getter, instance);
            }
        }
        return result;
    }

    @Override
    public Object set(int index, Object newValue) {
        if (this.setter == null) {
            throw new UnsupportedOperationException("Array is read only");
        }
        Object instance = this.targetList.get(index);
        Object oldValue = null;
        if (this.executor == null || instance instanceof Invokeable) {
            Invokeable invokeable = (Invokeable)instance;
            invokeable.setAttributeValue(this.setter, newValue);
            if (this.getter != null) {
                oldValue = invokeable.getAttributeValue(this.getter);
            }
        } else {
            this.executor.setAttributeValue(this.setter, newValue, instance);
            if (this.getter != null) {
                oldValue = this.executor.getAttributeValue(this.getter, instance);
            }
        }
        return oldValue;
    }

    @Override
    public int size() {
        return this.targetList.size();
    }
}

