/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.bpm.lang.FuegoClassLoader;

public class JarClassLoader
extends ClassLoader {
    private String description_d;
    private ZipInputStream jar_d;
    private ZipEntry nextEntry_d;

    public JarClassLoader(ZipInputStream jar) throws IOException {
        this(jar, null);
    }

    public JarClassLoader(ZipInputStream jar, String description) throws IOException {
        super(Thread.currentThread().getContextClassLoader());
        this.description_d = description;
        this.jar_d = jar;
        this.nextEntry_d = this.getNextEntry();
        FuegoClassLoader.registerClassLoader(this);
    }

    public Class getNextClass() throws ClassNotFoundException {
        try {
            int len;
            byte[] data = null;
            byte[] auxData = new byte[1024];
            int totLen = 0;
            while ((len = this.jar_d.read(auxData, 0, 1024)) > -1) {
                int i;
                byte[] dynData = new byte[totLen += len];
                for (i = 0; data != null && i < data.length; ++i) {
                    dynData[i] = data[i];
                }
                int j = 0;
                while (j < len) {
                    dynData[i] = auxData[j];
                    ++j;
                    ++i;
                }
                data = dynData;
            }
            assert (data != null) : "data cannot be null";
            Class<?> c = this.defineClass(null, data, 0, data.length);
            this.resolveClass(c);
            this.nextEntry_d = this.getNextEntry();
            return c;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(this.nextEntry_d.getName());
        }
    }

    public boolean hasMoreClasses() {
        return this.nextEntry_d != null;
    }

    public String toString() {
        return "JarClassLoader(" + this.description_d + ")";
    }

    private ZipEntry getNextEntry() throws IOException {
        ZipEntry ze = this.jar_d.getNextEntry();
        while (ze != null && !ze.getName().endsWith(".class")) {
            ze = this.jar_d.getNextEntry();
        }
        return ze;
    }
}

