/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.HashMap;
import java.util.Map;

public class CharArrayMap<T>
extends HashMap<CharSequence, T> {
    static Chars KEY = new Chars();
    static final long serialVersionUID = 967608225972123714L;
    static final long serialCheck = -7131622752334013095L;

    public CharArrayMap() {
    }

    public CharArrayMap(int initialCapacity) {
        super(initialCapacity);
    }

    public CharArrayMap(Map<? extends CharSequence, ? extends T> t) {
        super(t);
    }

    public CharArrayMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public T get(char[] chars, int offset, int length) {
        return (T)(chars == null ? null : CharArrayMap.KEY.get(this, chars, offset, length));
    }

    public T remove(char[] chars, int offset, int length) {
        return (T)CharArrayMap.KEY.removeIt(this, chars, offset, length);
    }

    private static class Chars
    implements CharSequence {
        char[] chars;
        int length;
        int offset;

        private Chars() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof char[]) {
                char[] chars = (char[])object;
                if (this.length != chars.length) {
                    return false;
                }
                for (int i = this.length - 1; i >= 0; --i) {
                    if (this.chars[this.offset + i] == chars[i]) continue;
                    return false;
                }
                return true;
            }
            if (object instanceof CharSequence) {
                CharSequence s = (CharSequence)object;
                if (this.length != s.length()) {
                    return false;
                }
                for (int i = this.length - 1; i >= 0; --i) {
                    if (this.chars[this.offset + i] == s.charAt(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int h = 0;
            char[] chars = this.chars;
            int off = this.offset;
            for (int i = this.length; i > 0; --i) {
                h = 31 * h + chars[off++];
            }
            return h;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.chars[index - this.offset];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            Chars result = new Chars();
            result.chars = this.chars;
            result.offset = this.offset + start;
            result.length = Math.min(end, this.length) - start;
            return result;
        }

        private synchronized <T> T removeIt(CharArrayMap<T> map, char[] chars, int offset, int length) {
            this.chars = chars;
            this.offset = offset;
            this.length = length;
            Object result = map.remove(this);
            this.chars = null;
            return (T)result;
        }

        private synchronized <T> T get(CharArrayMap<T> hashMap, char[] chars, int offset, int length) {
            this.chars = chars;
            this.offset = offset;
            this.length = length;
            Object result = hashMap.get(this);
            this.chars = null;
            return (T)result;
        }
    }
}

