/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import fuego.directory.DirectoryException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.collections.maps.WeakValueHashMap;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.CatalogFileInfo;
import oracle.bpm.util.CatalogMgr;
import oracle.bpm.util.FuegoObjectCatalog;

class CatalogLoaderMgrCache {
    private Map<String, ClassLoader> catalogClassLoaderMap;
    private CatalogManagerCache catalogManagerCache;
    private final Object mutex = new Object();
    private static CatalogLoaderMgrCache catalogLoaderMgrCache = new CatalogLoaderMgrCache();

    private CatalogLoaderMgrCache() {
        this.catalogClassLoaderMap = new WeakValueHashMap<String, ClassLoader>(10, 10.0f);
        this.catalogManagerCache = new CatalogManagerCache();
    }

    public static CatalogLoaderMgrCache create() {
        return catalogLoaderMgrCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ClassLoader findOrCreateCatalogClassloader(String schemaId, int catalogIN) throws ClassNotFoundException {
        String key = this.buildKey(schemaId, catalogIN);
        Object object = this.mutex;
        synchronized (object) {
            ClassLoader result = this.catalogClassLoaderMap.get(key);
            if (result == null) {
                CatalogMgr mgr = this.findCatalogManager(schemaId);
                if (mgr.supportsClassLoader()) {
                    try {
                        result = mgr.getCatalogClassLoader(schemaId, catalogIN);
                    }
                    catch (Exception e) {
                        throw new ClassNotFoundException(e.getMessage(), e);
                    }
                } else {
                    CatalogFileInfo fileInfo = this.createCatalogFileInfo(catalogIN, schemaId);
                    result = FuegoObjectCatalog.createLoader(catalogIN, schemaId, fileInfo.getFiles());
                }
                this.catalogClassLoaderMap.put(key, result);
                if (Log.isDebugging()) {
                    this.logDebugInfo("CatalogClassLoader[" + key + "] added to cache");
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCatalogClassLoader(String schemaId, int catalogIN) {
        Object object = this.mutex;
        synchronized (object) {
            String key = this.buildKey(schemaId, catalogIN);
            this.catalogClassLoaderMap.remove(key);
        }
    }

    public final void registerCatalogManager(String schemaId, CatalogMgr mgr) {
        this.catalogManagerCache.register(schemaId, mgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterCatalogManager(String schemaId) {
        this.catalogManagerCache.unregisterCatalogMgr(schemaId);
        Object object = this.mutex;
        synchronized (object) {
            StringList keys = StringList.create();
            for (Map.Entry<String, ClassLoader> entry : this.catalogClassLoaderMap.entrySet()) {
                String key = entry.getKey();
                if (!schemaId.equals(this.extractSchemaId(key))) continue;
                keys.add(key);
            }
            for (String key : keys) {
                this.catalogClassLoaderMap.remove(key);
            }
        }
    }

    public final CatalogMgr findCatalogManager(String schemaId) {
        return this.catalogManagerCache.find(schemaId);
    }

    public final boolean hasCatalogManager(String schemaId) {
        return this.catalogManagerCache.isCatalogMgrRegistered(schemaId);
    }

    private String buildKey(String schemaId, int catalogIN) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(schemaId);
        buffer.append('-');
        buffer.append(catalogIN);
        return buffer.toString();
    }

    private String extractSchemaId(String key) {
        return key.substring(0, key.lastIndexOf("-"));
    }

    private boolean logDebugInfo(String msg) {
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("[CatalogLoaderMgrCache] =======================\n");
        logMessage.append(msg);
        logMessage.append("\n\n Catalog ClassLoader MAP: \n");
        logMessage.append(this.catalogClassLoaderMap);
        logMessage.append("\n\n Catalog Manager Cache: \n");
        logMessage.append(this.catalogManagerCache);
        Log.logDebug(logMessage.toString());
        return true;
    }

    private CatalogFileInfo createCatalogFileInfo(int catalogIN, String schemaId) throws ClassNotFoundException {
        CatalogFileInfo fileInfo = null;
        CatalogMgr mgr = this.findCatalogManager(schemaId);
        Msg errorMsg = null;
        try {
            if (mgr != null) {
                fileInfo = mgr.getCatalogURL(catalogIN);
            } else {
                errorMsg = CoreMsg.CATALOG_MANAGER_NOT_REGISTERED(schemaId, catalogIN);
            }
        }
        catch (MalformedURLException e) {
            errorMsg = CoreMsg.CATALOG_MALFORMED_URL;
        }
        catch (DirectoryException e) {
            errorMsg = CoreMsg.CANT_GET_URLS(schemaId, catalogIN);
        }
        catch (IOException e) {
            errorMsg = CoreMsg.CANT_GET_URLS(schemaId, catalogIN);
        }
        if (errorMsg != null) {
            if (Log.isDebugging()) {
                this.logDebugInfo(errorMsg.getString());
            }
            Throwable error = null;
            throw new ClassNotFoundException(errorMsg.getString(), error);
        }
        return fileInfo;
    }

    private static final class CatalogManagerCache {
        private final Object cacheMutex = new Object();
        private Map<String, Integer> managerCounterMap;
        private Map<String, CatalogMgr> managerMap = new HashMap<String, CatalogMgr>();

        public CatalogManagerCache() {
            this.managerCounterMap = new HashMap<String, Integer>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(String schemaId, CatalogMgr mgr) {
            Object object = this.cacheMutex;
            synchronized (object) {
                if (Log.isDebugging()) {
                    this.logDebugInfo("Registering CatalogMgr [" + schemaId + "] ...");
                }
                if (!this.isCatalogMgrRegistered(schemaId)) {
                    this.managerMap.put(schemaId, mgr);
                    if (Log.isDebugging()) {
                        this.logDebugInfo("CatalogMgr [" + schemaId + "] REGISTERED!");
                    }
                }
                this.increaseCounter(schemaId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterCatalogMgr(String schemaId) {
            Object object = this.cacheMutex;
            synchronized (object) {
                if (Log.isDebugging()) {
                    this.logDebugInfo("Unregistering CatalogMgr [" + schemaId + "] ...");
                }
                if (this.isCatalogMgrRegistered(schemaId) && this.decreaseCounter(schemaId) == 0) {
                    this.managerMap.remove(schemaId);
                    if (Log.isDebugging()) {
                        this.logDebugInfo("CatalogMgr [" + schemaId + "] UNREGISTERED!");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCatalogMgrRegistered(String schemaId) {
            Object object = this.cacheMutex;
            synchronized (object) {
                return this.managerMap.containsKey(schemaId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CatalogMgr find(String schemaId) {
            Object object = this.cacheMutex;
            synchronized (object) {
                return this.managerMap.get(schemaId);
            }
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("CatalogManagerCache ");
            buffer.append(this.hashCode());
            buffer.append(":\nManagers:\n");
            buffer.append(this.managerMap);
            buffer.append("\nCounters:\n");
            buffer.append(this.managerCounterMap);
            return buffer.toString();
        }

        private void increaseCounter(String schemaId) {
            assert (Thread.holdsLock(this.cacheMutex));
            Integer counter = this.managerCounterMap.get(schemaId);
            this.managerCounterMap.put(schemaId, counter == null ? 1 : counter + 1);
        }

        private int decreaseCounter(String schemaId) {
            assert (Thread.holdsLock(this.cacheMutex));
            int counter = this.managerCounterMap.get(schemaId);
            if (counter > 1) {
                this.managerCounterMap.put(schemaId, --counter);
            } else {
                counter = 0;
                this.managerCounterMap.remove(schemaId);
            }
            return counter;
        }

        private boolean logDebugInfo(String msg) {
            StringBuilder logMessage = new StringBuilder();
            logMessage.append("[CatalogMgrCache] =======================\n");
            logMessage.append(msg);
            logMessage.append(this.toString());
            Log.logDebug(logMessage.toString());
            return true;
        }
    }
}

