/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.net.ProtocolException;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.connector.JavaLibrariesHelper;
import oracle.bpm.util.CatalogLoaderMgrCache;
import oracle.bpm.util.CatalogMgr;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;
import oracle.bpm.util.FuegoObjectCatalog;

public class CatalogLoaderMgr {
    private static final CatalogLoaderMgrCache catalogLoaderMgrCache = CatalogLoaderMgrCache.create();
    private static final byte REGULAR_CLASS = 0;
    private static final byte XOBJECT_CLASS = 1;
    private static final byte FUEGO_OBJ_CLASS_NO_CL = 2;
    private static final byte VERSIONABLE_CLASS = 3;

    public static void annotateClass(ObjectOutputStream out, Class clazz) throws IOException {
        String className = clazz.getName();
        ClassLoader classLoader = clazz.getClassLoader();
        FuegoObjectCatalog catalog = FuegoObjectCatalog.getFrom(classLoader);
        if (className.startsWith("xobject")) {
            if (catalog != null) {
                out.writeByte(1);
                out.writeInt(catalog.getCatalogIN());
                out.writeUTF(catalog.getDirectoryId());
            } else {
                out.writeByte(2);
            }
        } else if (catalog != null) {
            out.writeByte(3);
            out.writeInt(catalog.getCatalogIN());
            out.writeUTF(catalog.getDirectoryId());
        } else {
            out.writeByte(0);
        }
    }

    public static ClassLoader getCatalogClassLoader(int catalogIN, String schemaId) throws ClassNotFoundException {
        return catalogLoaderMgrCache.findOrCreateCatalogClassloader(schemaId, catalogIN);
    }

    public static CatalogMgr getCatalogMgr(String schemaId) {
        return catalogLoaderMgrCache.findCatalogManager(schemaId);
    }

    public static Class getClass(String name) throws ClassNotFoundException {
        if (ConnectorTransaction.hasConnectorService()) {
            ClassLoader cl = null;
            ExecutionContext context = ExecutionContextAccessor.getContext();
            if (context != null) {
                cl = (ClassLoader)context.getProperty("fuego.process.classloader");
            }
            if (cl == null) {
                cl = JavaLibrariesHelper.getClassLoader();
            }
            return Class.forName(name, true, cl);
        }
        return null;
    }

    public static Class getClass(String name, int catalogIN, String directoryId) throws ClassNotFoundException {
        return Class.forName(name, true, CatalogLoaderMgr.getCatalogClassLoader(catalogIN, directoryId));
    }

    public static void registerCatalogMgr(String schemaId, CatalogMgr mgr) {
        catalogLoaderMgrCache.registerCatalogManager(schemaId, mgr);
    }

    public static Class resolveClass(ObjectInputStream in, ObjectStreamClass classInfo) throws IOException, ClassNotFoundException {
        Class clazz;
        String name = classInfo.getName();
        byte op = in.readByte();
        switch (op) {
            case 0: 
            case 2: {
                clazz = CatalogLoaderMgr.getClass(name);
                break;
            }
            case 1: 
            case 3: {
                int catalogIn = in.readInt();
                String directoryId = in.readUTF();
                clazz = CatalogLoaderMgr.getClass(name, catalogIn, directoryId);
                if (clazz != null) break;
                throw new ClassNotFoundException("Class: " + name + " not found.");
            }
            default: {
                throw new ProtocolException("Unexpected class annotation mark: 0x" + Integer.toHexString(0xFF & op));
            }
        }
        return clazz;
    }

    public static void unregisterCatalogMgr(String schemaId) {
        catalogLoaderMgrCache.unregisterCatalogManager(schemaId);
    }
}

