/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import fuego.directory.DirCalendarRule;
import fuego.directory.DirectorySession;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import oracle.bpm.data.CalendarRuleData;
import oracle.bpm.holidays.HolidayCalendar;
import oracle.bpm.holidays.HolidayCalendarLoader;
import oracle.bpm.lang.Day;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.WorkDaySchedule;
import oracle.bpm.lang.WorkWeek;
import oracle.bpm.log.Log;

public class CalendarRule {
    private HolidayCalendar holidayCalendar;
    private TimeZone timeZone;
    private WorkWeek workWeek;

    public CalendarRule() {
    }

    public CalendarRule(WorkWeek workWeek, TimeZone timeZone, HolidayCalendar holidayCalendar) {
        this.workWeek = workWeek;
        this.timeZone = timeZone;
        this.holidayCalendar = holidayCalendar == null ? new HolidayCalendar(null) : holidayCalendar;
    }

    public CalendarRule(WorkWeek workWeek, String timeZone, HolidayCalendar holidayCalendar) {
        this(workWeek, timeZone != null ? TimeZone.getTimeZone(timeZone) : TimeZone.getDefault(), holidayCalendar);
    }

    public static CalendarRule getCalendarRule(DirectorySession session, DirCalendarRule r) {
        CalendarRule result = null;
        String properties = r.getProperties();
        if (properties != null) {
            try {
                CalendarRuleData rdata = CalendarRuleData.valueOf(properties);
                result = new CalendarRule(rdata.workWeek, rdata.timeZone, HolidayCalendarLoader.load(session, rdata.holidayRule));
            }
            catch (Exception e) {
                Log.logWarning(e);
            }
        }
        return result;
    }

    public HolidayCalendar getHolidayCalendar() {
        return this.holidayCalendar;
    }

    public Interval getInterval(int finish, int start) {
        return finish <= 0 ? Interval.valueOf(0L) : this.interval(finish).sub(this.interval(start));
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public WorkWeek getWorkWeek() {
        return this.workWeek;
    }

    public Time computeDate(Time date, Interval interval) {
        int days;
        GregorianCalendar calendar = new GregorianCalendar(this.timeZone);
        calendar.setTime(date.dateValue());
        int months = interval.getMonths();
        if (months != 0) {
            ((Calendar)calendar).add(2, months);
            interval = interval.addMonths(-months);
        }
        if ((days = interval.getDays()) != 0) {
            this.addDays(calendar, days);
            interval = interval.addDays(-days);
        }
        this.consumeWorkingTime(calendar, interval);
        return Time.valueOf(calendar.getTime());
    }

    public void moveCalendar(Calendar cal, Interval interval) {
        cal.add(11, interval.getHoursOnly());
        cal.add(12, interval.getMinutesOnly());
        cal.add(13, interval.getSecondsOnly());
    }

    private void addDays(Calendar cal, int days) {
        int substract = days < 0 ? -1 : 1;
        days = Math.abs(days);
        while (days > 0) {
            cal.add(5, substract);
            if (this.holidayCalendar.isHoliday(cal) || !this.workWeek.isWorkingDay(cal)) continue;
            --days;
        }
    }

    private void consumeWorkingTime(Calendar calendar, Interval interval) {
        if (interval.compareTo(Interval.ZERO) >= 0) {
            interval = interval.addMicroSeconds(1L);
        }
        while (interval.compareTo(Interval.ZERO) != 0) {
            while (this.holidayCalendar.isHoliday(calendar) || !this.workWeek.isWorkingDay(calendar)) {
                this.consumeOneDay(calendar, interval);
            }
            WorkDaySchedule wds = this.workWeek.getSchedule(Day.valueOf(calendar));
            interval = wds.consumeWorkingDay(calendar, interval);
            this.consumeOneDay(calendar, interval);
        }
    }

    private void consumeOneDay(Calendar calendar, Interval interval) {
        if (interval.compareTo(Interval.ZERO) < 0) {
            this.backwardDay(calendar);
        } else if (interval.compareTo(Interval.ZERO) > 0) {
            this.nextDay(calendar);
        }
    }

    private void backwardDay(Calendar calendar) {
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(11, 0);
        calendar.add(14, -1);
    }

    private Interval interval(int hhmm) {
        return Interval.valueOf(hhmm / 100 + "h " + hhmm % 100 + "m");
    }

    private void nextDay(Calendar calendar) {
        calendar.add(5, 1);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(11, 0);
    }
}

