/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type.catalog;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import oracle.bpm.lang.ComponentLoadingException;
import oracle.bpm.lang.JavaClassResolver;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeInfo;
import oracle.bpm.type.TypeLoader45;
import oracle.bpm.type.catalog.AbstractComponentBundle;

public abstract class XcdlComponentBundle
extends AbstractComponentBundle {
    private JavaClassResolver classResolver;
    private TypeInfo.Parser infoParser;
    private TypeLoader45 typeParser;
    public static final String CATALOG_PREFIX = "FUEGO-INF/";
    public static final String SUFFIX = ".xcdl";
    public static final int SUFFIX_LENGTH = ".xcdl".length();
    public static final String ROOT = "";
    public static final FilenameFilter SUFFIX_FILTER = new SuffixFilter();

    public void setClassResolver(JavaClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    public JavaClassResolver getClassResolver() {
        return this.classResolver;
    }

    @Override
    public TypeDescription loadType(String typeName, String parentName, ComponentCatalog catalog) throws TypeCatalogException {
        InputStream stream = null;
        try {
            stream = this.openInputStream(typeName, catalog);
            TypeLoader45 loader = this.getParser(catalog);
            ObjectTypeDescription type = loader.load(stream, parentName, typeName);
            assert (type != null) : "Type Loader should return an OTD or throw an exception";
            type.setJavaClassResolver(this.classResolver);
            String expectedName = typeName.substring(typeName.lastIndexOf(46) + 1);
            assert (type.getName().equals(expectedName)) : "TypeParser loaded '" + type.getName() + "' instead of '" + expectedName + "'";
            ObjectTypeDescription objectTypeDescription = type;
            return objectTypeDescription;
        }
        catch (ComponentLoadingException e) {
            throw new TypeCatalogException(catalog, e.getMessage()).initCause(e);
        }
        catch (IOException e) {
            throw new TypeCatalogException(catalog, e.getMessage()).initCause(e);
        }
        finally {
            this.closeInputStream(catalog, stream);
        }
    }

    @Override
    public TypeInfo loadHeader(String typeName, String parentName, ComponentCatalog catalog) throws TypeCatalogException {
        Reader reader = null;
        try {
            reader = this.openReader(typeName, catalog);
            TypeInfo typeInfo = this.getInfoParser().parse(reader);
            return typeInfo;
        }
        catch (IOException e) {
            throw new TypeCatalogException(catalog, "Could not load '" + typeName + "' because:" + e.toString()).initCause(e);
        }
        finally {
            this.closeReader(catalog, reader);
        }
    }

    protected abstract Reader openReader(String var1, ComponentCatalog var2) throws IOException;

    protected abstract InputStream openInputStream(String var1, ComponentCatalog var2) throws IOException;

    protected TypeLoader45 getParser(ComponentCatalog catalog) {
        if (this.typeParser == null) {
            this.typeParser = new TypeLoader45(catalog);
        }
        return this.typeParser;
    }

    protected TypeInfo.Parser getInfoParser() {
        if (this.infoParser == null) {
            this.infoParser = new TypeInfo.Parser();
        }
        return this.infoParser;
    }

    private void closeReader(ComponentCatalog catalog, Reader reader) throws TypeCatalogException {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new TypeCatalogException(catalog, e.getMessage());
            }
        }
    }

    private void closeInputStream(ComponentCatalog catalog, InputStream stream) throws TypeCatalogException {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new TypeCatalogException(catalog, e.getMessage());
            }
        }
    }

    private static class SuffixFilter
    implements FilenameFilter {
        private SuffixFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(XcdlComponentBundle.SUFFIX);
        }
    }
}

