/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type.catalog;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.catalog.AbstractComponentBundle;
import org.jetbrains.annotations.NotNull;

public class MemoryComponentBundle
extends AbstractComponentBundle {
    private Map<String, ObjectTypeDescription> types;

    public MemoryComponentBundle(String id) {
        this.setUniqueId(id);
        this.setModified();
    }

    public void addType(ObjectTypeDescription type) {
        String name = type.getText();
        this.getTypes().put(name, type);
        this.getListener().typeAdded(name, this);
        this.setModified();
        for (TypeRef child : type.getInnerTypeRefs()) {
            this.addType(child.get().asObject());
        }
    }

    public void removeType(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/catalog/MemoryComponentBundle.removeType must not be null");
        }
        ObjectTypeDescription type = this.getTypes().get(typeName);
        if (type != null) {
            this.removeType(type);
        }
    }

    @Override
    public List<String> loadTypeNames() throws TypeCatalogException {
        return StringList.create(this.getTypes().keySet());
    }

    @Override
    public TypeDescription loadType(String typeName, String parentName, ComponentCatalog catalog) throws TypeCatalogException {
        ObjectTypeDescription result = this.getTypes().get(typeName);
        if (result != null) {
            this.setCatalog(result, catalog);
            assert (typeName.equals(result.getText())) : "Requested type name '" + typeName + "' does not match result type name '" + result.getText() + "'";
        }
        return result;
    }

    protected Map<String, ObjectTypeDescription> getTypes() {
        if (this.types == null) {
            this.types = new HashMap<String, ObjectTypeDescription>();
            this.loadTypes();
        }
        return this.types;
    }

    protected void loadTypes() {
    }

    private void removeType(ObjectTypeDescription type) {
        for (TypeRef child : type.getInnerTypeRefs()) {
            this.removeType(child.get().asObject());
        }
        String name = type.getText();
        this.getTypes().remove(name);
        this.getListener().typeRemoved(name, this);
        this.setModified();
    }

    private void setCatalog(ObjectTypeDescription result, ComponentCatalog catalog) {
        if (result.getCatalog() == null) {
            result.setCatalog(catalog);
            TypeDescription parent = result.getParent();
            if (parent != null) {
                this.setCatalog(parent.asObject(), catalog);
            }
        }
    }
}

