/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type.catalog;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.catalog.XcdlComponentBundle;

public class JarComponentBundle
extends XcdlComponentBundle {
    private File jarFile;

    public JarComponentBundle(File jarFile) {
        String name = jarFile.getName();
        if (!name.endsWith(".jar") && !name.endsWith(".zip")) {
            throw new IllegalArgumentException("Not a jar or zip file: " + name);
        }
        this.jarFile = jarFile;
        this.setUniqueId("jar: " + jarFile.getAbsolutePath());
    }

    public static Reader openReader(JarFile jar, String typeName) throws IOException {
        String fname = "FUEGO-INF/" + typeName.replace('.', '/') + ".xcdl";
        ZipEntry entry = jar.getEntry(fname);
        if (entry == null) {
            throw new FileNotFoundException("Could not found '" + typeName + "' in '" + jar.getName() + "' : " + fname);
        }
        return JarComponentBundle.openReader(jar, entry);
    }

    public static Reader openReader(JarFile jar, ZipEntry entry) throws IOException {
        int n;
        int total;
        InputStream inputStream = jar.getInputStream(entry);
        byte[] bytes = new byte[total];
        int offset = 0;
        for (total = (int)entry.getSize(); total > 0 && (n = inputStream.read(bytes, offset, total)) >= 0; total -= n) {
            offset += n;
        }
        return new InputStreamReader(new ByteArrayInputStream(bytes));
    }

    public static InputStream openInputStream(JarFile jar, ZipEntry entry) throws IOException {
        int n;
        int total;
        InputStream inputStream = jar.getInputStream(entry);
        byte[] bytes = new byte[total];
        int offset = 0;
        for (total = (int)entry.getSize(); total > 0 && (n = inputStream.read(bytes, offset, total)) >= 0; total -= n) {
            offset += n;
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public List<String> loadTypeNames() throws TypeCatalogException {
        try {
            StringList result = StringList.create();
            this.scanJarFile(result);
            return result;
        }
        catch (IOException e) {
            throw new TypeCatalogException(null, e.toString()).initCause(e);
        }
    }

    @Override
    public long getLastModifiedTime(String typeName) {
        return this.jarFile.lastModified();
    }

    @Override
    public long lastModified() {
        return this.jarFile.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader openReader(String typeName, ComponentCatalog catalog) throws IOException {
        ZipFile jar = null;
        try {
            jar = new JarFile(this.jarFile, false, 1);
            Reader reader = JarComponentBundle.openReader((JarFile)jar, typeName);
            return reader;
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
    }

    @Override
    public File getBasePath() {
        return this.jarFile;
    }

    public String toString() {
        return "JarComponentBundle(" + this.getBasePath() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream openInputStream(String typeName, ComponentCatalog catalog) throws IOException {
        ZipFile jar = null;
        try {
            jar = new JarFile(this.jarFile, false, 1);
            InputStream inputStream = this.openInputStream((JarFile)jar, typeName);
            return inputStream;
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
    }

    private InputStream openInputStream(JarFile jar, String typeName) throws IOException {
        String fname = "FUEGO-INF/" + typeName.replace('.', '/') + ".xcdl";
        ZipEntry entry = jar.getEntry(fname);
        if (entry == null) {
            throw new FileNotFoundException("Could not found '" + typeName + "' in '" + jar.getName() + "' : " + fname);
        }
        return JarComponentBundle.openInputStream(jar, entry);
    }

    private void scanJarFile(List<String> typeNames) throws IOException {
        this.scanJarFile(this.jarFile, "", typeNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJarFile(File path, String currentModule, List<String> typeNames) throws IOException {
        int count = 0;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(path);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String name;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).startsWith("FUEGO-INF/") || !(name = name.substring("FUEGO-INF/".length())).endsWith(".xcdl")) continue;
                name = name.substring(0, name.length() - SUFFIX_LENGTH);
                name = name.replace('/', '.');
                String module = currentModule;
                int lastDot = name.lastIndexOf(46);
                if (lastDot != -1) {
                    String partialModule = name.substring(0, lastDot);
                    module = "".equals(module) ? partialModule : module + ".".concat(partialModule);
                    name = name.substring(lastDot + 1);
                    module = module.intern();
                    name = name.intern();
                }
                ++count;
                typeNames.add(module + "." + name);
            }
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }
}

