/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.JavaIntrospector;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeBeautifier;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeInfo;
import oracle.bpm.type.UnknownType;
import oracle.bpm.type.catalog.AbstractComponentBundle;
import oracle.bpm.util.ProgressMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedComponentBundle
extends AbstractComponentBundle {
    @Nullable
    private volatile SortedMap<String, String> index;
    private final Object indexLock = new Object();
    private String indexName;
    private static final String CREATION_PROPERTY = "creation";
    private static final String INTERFACE_MODIFIER = "interface";
    private static final String ENUM_MODIFIER = "enum";
    private static final String RUNS_ON_CLIENT = "runsOnClient";
    private static final String RUNS_ON_SERVER = "runsOnServer";

    protected IndexedComponentBundle() {
        this.setModified();
    }

    public static InputStream resolveResource(String name, ClassLoader classLoader) throws IOException {
        URL url = Platform.getResourceService().resolveResource(name, classLoader);
        return url != null ? url.openStream() : null;
    }

    @Override
    public List<String> loadTypeNames() throws TypeCatalogException {
        return new ArrayList<String>(this.getIndex().keySet());
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexName() {
        if (this.indexName == null) {
            this.indexName = this.guessIndexName();
        }
        return this.indexName;
    }

    @Override
    public TypeInfo loadHeader(String typeName, String parentName, ComponentCatalog catalog) throws TypeCatalogException {
        String descriptor = (String)this.getIndex().get(typeName);
        String[] elements = descriptor.split(";");
        String className = elements[0];
        int dot = className.lastIndexOf(46);
        String javaPackage = dot != -1 ? className.substring(0, dot) : "";
        TypeInfo info = new TypeInfo();
        info.setId(className);
        info.setProperty("package", javaPackage);
        info.setProperty("javaClassName", className);
        info.setType("java");
        int flags = 0;
        for (int i = 1; i < elements.length; ++i) {
            String[] modifier = elements[i].split(":");
            if (INTERFACE_MODIFIER.equals(modifier[0])) {
                flags = (int)((long)flags | 0x400L);
                continue;
            }
            if (RUNS_ON_SERVER.equals(modifier[0])) {
                if (!"false".equalsIgnoreCase(modifier[1])) continue;
                flags = (int)((long)flags | 0x8000000L);
                continue;
            }
            if (!ENUM_MODIFIER.equals(modifier[0])) continue;
        }
        info.setFlags(flags);
        return info;
    }

    @Override
    public TypeDescription loadType(String typeName, String parentName, ComponentCatalog catalog) throws TypeCatalogException {
        TypeDescription result;
        ClassLoader loader = this.getClass().getClassLoader();
        SortedMap<String, String> index = this.getIndex();
        String descriptor = (String)index.get(typeName);
        if (descriptor != null) {
            String className = descriptor.split(";")[0];
            try {
                Class<?> cl = Class.forName(className, false, loader);
                ObjectTypeDescription[] introspected = JavaIntrospector.introspectFromClassLoader(catalog, cl);
                if (!introspected[0].isHidden()) {
                    TypeBeautifier tb = new TypeBeautifier();
                    tb.beautify(introspected, ProgressMonitor.NULL_INSTANCE, null, false);
                }
                result = introspected[0];
            }
            catch (ClassNotFoundException e) {
                result = IndexedComponentBundle.findModule(typeName, index, catalog);
            }
        } else {
            result = IndexedComponentBundle.findModule(typeName, index, catalog);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected SortedMap<String, String> loadIndex() throws TypeCatalogException {
        Properties properties = new Properties();
        try {
            InputStream indexStream = this.openIndex(this.getClass().getClassLoader());
            if (indexStream == null) {
                throw new IllegalStateException("Could not load index '" + this.getIndexName() + "' for " + this.getUniqueId());
            }
            try {
                properties.load(indexStream);
                indexStream.close();
            }
            catch (Throwable throwable) {
                StreamUtils.close(indexStream);
                throw throwable;
            }
            StreamUtils.close(indexStream);
        }
        catch (IOException e) {
            throw new TypeCatalogException(null, null, e);
        }
        String creationProperty = properties.getProperty(CREATION_PROPERTY);
        if (creationProperty == null) {
            throw new IllegalStateException("Could not get 'creation' property for " + this.getUniqueId() + '\n' + properties);
        }
        long creation = Long.parseLong(creationProperty);
        properties.remove(CREATION_PROPERTY);
        this.setLastModified(creation);
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (String component : properties.stringPropertyNames()) {
            result.put(component, properties.getProperty(component));
        }
        TreeMap<String, String> treeMap = result;
        if (treeMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/catalog/IndexedComponentBundle.loadIndex must not return null");
        }
        return treeMap;
    }

    protected InputStream openIndex(ClassLoader classLoader) throws IOException {
        InputStream result = IndexedComponentBundle.resolveResource(this.getIndexName(), classLoader);
        if (result == null) {
            result = IndexedComponentBundle.resolveResource('/' + this.getIndexName(), classLoader);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected SortedMap<String, String> getIndex() throws TypeCatalogException {
        SortedMap<String, String> result = this.index;
        if (result == null) {
            Object object = this.indexLock;
            synchronized (object) {
                result = this.index;
                if (result == null) {
                    this.index = result = this.loadIndex();
                }
            }
        }
        SortedMap<String, String> sortedMap = result;
        if (sortedMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/catalog/IndexedComponentBundle.getIndex must not return null");
        }
        return sortedMap;
    }

    private static TypeDescription findModule(String typeName, SortedMap<String, String> index, ComponentCatalog catalog) throws TypeCatalogException {
        String baseName;
        String moduleName = typeName;
        String parentName = null;
        int idx = typeName.lastIndexOf(46);
        if (idx != -1) {
            moduleName = typeName.substring(idx + 1);
            parentName = typeName.substring(0, idx);
        }
        if (index.subMap(baseName = typeName + '.', baseName + '\uffff').isEmpty()) {
            throw new TypeCatalogException(catalog, typeName);
        }
        ObjectTypeDescription otd = new ObjectTypeDescription(moduleName);
        otd.setComponentType(ComponentType.JAVA.getText());
        otd.setProperty("isPackage", String.valueOf(true));
        if (parentName != null) {
            otd.setParent(UnknownType.create(parentName, catalog));
        }
        return otd;
    }

    private String guessIndexName() {
        String name = this.getClass().getName();
        boolean fuegoBlock = name.startsWith("fuegoblock.");
        int dot = name.lastIndexOf(46);
        if ((name = name.substring(dot + 1)).endsWith("Block")) {
            name = name.substring(0, name.length() - "Block".length());
        } else if (name.endsWith("ComponentBundle")) {
            name = name.substring(0, name.length() - "ComponentBundle".length());
        }
        return (fuegoBlock ? "block." : "") + name.toLowerCase() + ".index";
    }
}

