/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type.catalog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.List;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.JavaClassResolver;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeWriter45;
import oracle.bpm.type.catalog.MutableComponentBundle;
import oracle.bpm.type.catalog.XcdlComponentBundle;
import org.jetbrains.annotations.Nullable;

public class DirectoryComponentBundle
extends XcdlComponentBundle
implements MutableComponentBundle {
    private File baseDir;
    private static final String FUEGO_INF_DIRECTORY_SUFIX = "FUEGO-INF";

    public DirectoryComponentBundle(File baseDir) {
        this(baseDir, null);
    }

    public DirectoryComponentBundle(String path) {
        this(new File(path));
    }

    public DirectoryComponentBundle(File baseDir, JavaClassResolver classResolver) {
        if (baseDir.exists() && !baseDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + baseDir);
        }
        this.baseDir = DirectoryComponentBundle.canonical(baseDir);
        this.setClassResolver(classResolver);
        File fuegoInfDir = new File(baseDir, FUEGO_INF_DIRECTORY_SUFIX);
        if (fuegoInfDir.exists()) {
            this.baseDir = fuegoInfDir;
        }
        this.setUniqueId("dir:" + baseDir.getAbsolutePath());
    }

    public static File getDirForType(File baseDir, String qname) {
        return DirectoryComponentBundle.getFileForType(baseDir, qname, "");
    }

    public static File getFileForType(File baseDir, String qname) {
        return DirectoryComponentBundle.getFileForType(baseDir, qname, ".xcdl");
    }

    public static File getFileForType(File baseDir, String qname, String suffix) {
        assert (!qname.endsWith(".xcdl")) : qname;
        String fname = qname.replace('.', File.separatorChar);
        return new File(baseDir, fname + suffix);
    }

    public static void storeFile(File baseDir, ObjectTypeDescription type) throws TypeCatalogException {
        boolean created;
        File targetFile = DirectoryComponentBundle.getFileForType(baseDir, type.getText(), ".xcdl");
        File directory = targetFile.getParentFile();
        if (directory.exists() || !(created = directory.mkdirs())) {
            // empty if block
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), "UTF-8");
            TypeWriter45.writeXML(type, "component", writer);
        }
        catch (IOException e) {
            throw new TypeCatalogException(null, type.getText(), e);
        }
    }

    @Override
    public File getBasePath() {
        return this.baseDir;
    }

    @Override
    public List<String> loadTypeNames() throws TypeCatalogException {
        assert (!"/".equals(this.baseDir.toString())) : this.baseDir;
        StringList typeNames = StringList.create();
        DirectoryComponentBundle.scanDirectory(this.baseDir, "", typeNames);
        return typeNames;
    }

    @Override
    public long getLastModifiedTime(String typeName) {
        return this.getFileForType(typeName).lastModified();
    }

    @Override
    public boolean hasChangedFrom(long date) {
        return true;
    }

    @Override
    public long lastModified() {
        return System.currentTimeMillis();
    }

    @Override
    public void remove(String typeName) throws TypeCatalogException {
        File file = DirectoryComponentBundle.getFileForType(this.baseDir, typeName, ".xcdl");
        DirectoryComponentBundle.deleteFile(file);
        File dir = DirectoryComponentBundle.getDirForType(this.baseDir, typeName);
        DirectoryComponentBundle.deleteDirectory(dir);
    }

    @Override
    public void store(ObjectTypeDescription type) throws TypeCatalogException {
        DirectoryComponentBundle.storeFile(this.baseDir, type);
    }

    public File getFileForType(String typeName) {
        return DirectoryComponentBundle.getFileForType(this.baseDir, typeName, ".xcdl");
    }

    @Override
    public boolean isReadOnly(TypeRef type) {
        File file = DirectoryComponentBundle.getFileForType(this.getBasePath(), type.getText());
        return !file.canWrite();
    }

    public File getDirForType(String qname) throws TypeCatalogException {
        return DirectoryComponentBundle.getDirForType(this.getBasePath(), qname);
    }

    public String toString() {
        return "DirectoryComponentBundle(" + this.getBasePath() + ')';
    }

    @Override
    protected Reader openReader(String typeName, ComponentCatalog catalog) throws IOException {
        return new InputStreamReader(this.openInputStream(typeName, catalog));
    }

    @Override
    protected InputStream openInputStream(String typeName, ComponentCatalog catalog) throws IOException {
        assert (!typeName.endsWith(".xcdl")) : typeName;
        File source = this.getFileForType(typeName);
        return new FileInputStream(source);
    }

    private static void scanDirectory(File path, String currentModule, List<String> typeNames) {
        DirectoryComponentBundle.scanDirectoryFile(path, currentModule, typeNames);
    }

    private static void scanIgnoreFiles(String name, String currentModule, List<String> typeNames) {
        if (name.endsWith(".xcdl") && !name.startsWith(".")) {
            name = name.substring(0, name.length() - SUFFIX_LENGTH);
            typeNames.add(currentModule + '.' + name);
        }
    }

    private static void scanDirectoryFile(File path, String currentModule, List<String> typeNames) {
        currentModule = currentModule.intern();
        File[] files = path.listFiles();
        if (files != null) {
            for (File file : files) {
                File dir;
                String name = file.getName();
                DirectoryComponentBundle.scanIgnoreFiles(name, currentModule, typeNames);
                if (name.indexOf(46) != -1 || !(dir = new File(path, name)).isDirectory()) continue;
                String subModule = currentModule.equals("") ? name : currentModule + '.' + name;
                DirectoryComponentBundle.scanDirectoryFile(dir, subModule, typeNames);
            }
        }
    }

    private static void deleteFile(File file) throws TypeCatalogException {
        boolean deleted = file.delete();
        if (!deleted && file.exists()) {
            String reason = "unknown";
            File dir = file.getParentFile();
            if (dir != null && dir.exists() && !dir.canWrite()) {
                reason = "Permission denied to modify files in directory: '" + dir.getAbsolutePath() + '\'';
            } else {
                String os = System.getProperty("os.name");
                if (os != null && os.contains("Windows")) {
                    reason = "Maybe it is being used by another person or program. Close any programs that might be using the file and try again";
                }
            }
            throw new TypeCatalogException(null, CoreMsg.COULDNOTDELETEFILE(file.getAbsolutePath(), reason));
        }
    }

    private static boolean deleteDirectory(File dir) throws TypeCatalogException {
        return DirectoryComponentBundle.deleteDirectoryFile(dir);
    }

    private static boolean deleteDirectoryFile(File dir) throws TypeCatalogException {
        boolean empty = true;
        File[] files = dir.listFiles();
        if (files != null) {
            for (File current : files) {
                if (current.isDirectory()) {
                    boolean deleted = DirectoryComponentBundle.deleteDirectoryFile(current);
                    empty = empty && deleted;
                    continue;
                }
                if (current.getName().endsWith(".xcdl")) {
                    DirectoryComponentBundle.deleteFile(current);
                    continue;
                }
                empty = false;
            }
        }
        if (empty) {
            DirectoryComponentBundle.deleteFile(dir);
        }
        return empty;
    }

    private static File canonical(@Nullable File path) {
        if (path != null) {
            try {
                path = path.getCanonicalFile();
            }
            catch (IOException ignore) {
                Log.logDebug(ignore);
            }
        }
        return path;
    }
}

