/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.type.Argument;
import oracle.bpm.type.catalog.DocumentationBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDocumentationBundle
implements DocumentationBundle {
    private static final char SLASH = '/';

    @Nullable
    public static String buildSubPath(@NotNull TypeDescription type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/catalog/AbstractDocumentationBundle.buildSubPath must not be null");
        }
        String path = null;
        String name = type.getName();
        if (type.isAttribute()) {
            path = (type.getParent().getText() + '/' + "@" + name).replace('.', '/');
        } else if (type.isMethod()) {
            MethodTypeDescription mtd = (MethodTypeDescription)type;
            if (mtd.isConstructor() && mtd.getArguments().length == 0) {
                return null;
            }
            path = mtd.getQualifiedName().replace('.', '/') + AbstractDocumentationBundle.buildArgumentsString(mtd.getArguments());
        } else if (type.isObject()) {
            path = type.getQualifiedName().replace('.', '/') + '/' + name + "_component";
        }
        return path != null ? path + ".html" : null;
    }

    @Override
    @Nullable
    public String getDocumentation(@NotNull TypeDescription type, @NotNull Locale locale) {
        String result;
        block5: {
            InputStream is;
            if (type == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/catalog/AbstractDocumentationBundle.getDocumentation must not be null");
            }
            if (locale == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/catalog/AbstractDocumentationBundle.getDocumentation must not be null");
            }
            result = null;
            ClassLoader loader = this.getClass().getClassLoader();
            String subPath = AbstractDocumentationBundle.buildSubPath(type);
            if (subPath != null && (is = this.loadFile(locale, loader, subPath)) != null) {
                try {
                    char[] chars = StreamUtils.readChars(new InputStreamReader(is, Literals.DEFAULT_ENCODING));
                    is.close();
                    result = new String(chars);
                }
                catch (IOException e) {
                    if (!Log.isDebugging()) break block5;
                    Log.logDebug(e);
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String buildArgumentsString(@NotNull Argument[] arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/catalog/AbstractDocumentationBundle.buildArgumentsString must not be null");
        }
        String result = "";
        for (Argument argument : arguments) {
            String typeText = argument.getTypeText();
            if (argument.getType().isArray()) {
                if (argument.getType().isMap()) {
                    ArrayTypeDescription atd = (ArrayTypeDescription)argument.getType();
                    typeText = atd.getElementType().getText() + "(" + atd.getIndexType().getText() + ")";
                } else {
                    typeText = typeText.replace('[', '(');
                    typeText = typeText.replace(']', ')');
                }
            }
            result = result.equals("") ? "$" + typeText : result + "_" + typeText;
        }
        String string = result;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/catalog/AbstractDocumentationBundle.buildArgumentsString must not return null");
        }
        return string;
    }

    private InputStream loadFile(Locale locale, ClassLoader loader, String subPath) {
        List<String> localeStrings = this.buildLocaleStrings(locale);
        for (String localeString : localeStrings) {
            String path = localeString + '/' + subPath;
            InputStream is = loader.getResourceAsStream(path);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    private List<String> buildLocaleStrings(Locale locale) {
        String language = locale.getLanguage().equals("") ? null : locale.getLanguage();
        String country = locale.getCountry().equals("") ? null : locale.getCountry();
        String variant = locale.getVariant().equals("") ? null : locale.getVariant();
        ArrayList<String> list = new ArrayList<String>();
        list.add(locale.toString());
        if ((variant != null || country != null) && language != null) {
            if (country != null && variant != null) {
                list.add(language + "_" + country);
            }
            list.add(language);
        }
        list.add("en");
        return list;
    }
}

