/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.collections.maps.BiMap;
import oracle.bpm.collections.maps.TreeBiMap;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.impl.TypeDescriptionImpl;

public class TypeToXsdMapping {
    private static BiMap<TypeDescription, String> typesToXsd = new TreeBiMap<TypeDescription, String>(new TypeComparator(), null);
    private static final TypeDescription NMTOKEN = TypeDescriptionImpl.createTypeDescription(5, -1, -21, false);
    private static final TypeDescription ENTITY = TypeDescriptionImpl.createTypeDescription(5, -1, -19, false);
    private static final TypeDescription IDREF = TypeDescriptionImpl.createTypeDescription(5, -1, -18, false);
    public static final TypeDescription HEX_BINARY = TypeDescriptionImpl.createTypeDescription(8, -1, 1, false);

    public static Map<TypeDescription, String> getTypesToXsd() {
        return typesToXsd;
    }

    public static Map<String, TypeDescription> getXsdToType() {
        return typesToXsd.inverse();
    }

    public static String getTypeMapping(TypeDescription td) {
        return TypeToXsdMapping.getTypesToXsd().get(td);
    }

    public static TypeDescription getXsdTypeMapping(String typeName) {
        return TypeToXsdMapping.getXsdToType().get(typeName);
    }

    public static Map<TypeDescription, String> createEmptyTypeMap() {
        return new TreeMap<TypeDescription, String>(new TypeComparator());
    }

    static {
        typesToXsd.put(TypeFactory.getString(), "string");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(5, -1, -10, false), "normalizedString");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(5, -1, -11, false), "token");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(5, -1, -12, false), "Name");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(5, -1, -13, false), "QName");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(5, -1, -14, false), "NCName");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(5, -1, -15, false), "anyURI");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(5, -1, -16, false), "language");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(5, -1, -17, false), "ID");
        typesToXsd.put(IDREF, "IDREF");
        typesToXsd.put(ENTITY, "ENTITY");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(5, -1, -20, false), "NOTATION");
        typesToXsd.put(NMTOKEN, "NMTOKEN");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(5, -1, -22, false), "uriReference");
        typesToXsd.put(TypeFactory.getArray(IDREF), "IDREFS");
        typesToXsd.put(TypeFactory.getArray(ENTITY), "ENTITIES");
        typesToXsd.put(TypeFactory.getArray(NMTOKEN), "NMTOKENS");
        typesToXsd.put(TypeFactory.getInt(8), "byte");
        typesToXsd.put(TypeFactory.getInt(16), "short");
        typesToXsd.put(TypeFactory.getInt(32), "int");
        typesToXsd.put(TypeFactory.getInt(64), "long");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(2, 8, -10, false), "unsignedByte");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(2, 64, -11, false), "positiveInteger");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(2, 64, -12, false), "negativeInteger");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(2, 64, -13, false), "nonNegativeInteger");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(2, 64, -14, false), "nonPositiveInteger");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(2, 32, -15, false), "unsignedInt");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(2, 64, -16, false), "unsignedLong");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(2, 16, -17, false), "unsignedShort");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(2, 64, -18, false), "integer");
        typesToXsd.put(TypeFactory.getDecimal(), "decimal");
        typesToXsd.put(TypeFactory.getReal(64), "double");
        typesToXsd.put(TypeFactory.getReal(32), "float");
        typesToXsd.put(TypeFactory.getBool(), "boolean");
        typesToXsd.put(TypeFactory.getTime(), "dateTime");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(6, -1, 2, false), "dateTime");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(6, -1, 1, false), "time");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(6, -1, 0, false), "date");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(6, -1, 4, false), "gYearMonth");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(6, -1, 3, false), "gMonthDay");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(2, 8, -20, false), "gDay");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(2, 8, -21, false), "gMonth");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(2, 16, -22, false), "gYear");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(6, -1, 5, false), "timeInstant");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(6, -1, 6, false), "timeDuration");
        typesToXsd.put(TypeFactory.getInterval(), "duration");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(8, -1, 0, false), "base64Binary");
        typesToXsd.put(HEX_BINARY, "hexBinary");
        typesToXsd.put(TypeFactory.getAny(), "anyType");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(5, -1, -23, false), "anySimpleType");
    }

    private static class TypeComparator
    implements Comparator<TypeDescription> {
        private TypeComparator() {
        }

        @Override
        public int compare(TypeDescription td1, TypeDescription td2) {
            int k2;
            if (td1 == td2) {
                return 0;
            }
            int k1 = td1.getKind();
            if (k1 != (k2 = td2.getKind())) {
                return k1 - k2;
            }
            if (td1.isArray()) {
                return this.compare(td1.getElementType(), td2.getElementType());
            }
            int l1 = td1.getLength();
            int l2 = td2.getLength();
            int s1 = td1.getScale();
            int s2 = td2.getScale();
            if (td1.isInt() || td1.isReal()) {
                if (l1 != l2) {
                    return l1 - l2;
                }
                if (td1.isInt() && s1 != s2) {
                    return s1 - s2;
                }
            } else if (td1.isTime() ? s1 != s2 : (td1.isBinary() ? s1 != s2 : td1.isString() && s1 != s2)) {
                return s1 - s2;
            }
            return 0;
        }
    }
}

