/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpm.type.PropertyIndex;
import oracle.bpm.type.PropertyProvider;
import oracle.bpm.type.PropertyVisitor;
import org.jetbrains.annotations.NotNull;

public class SimplePropertyIndex
implements PropertyIndex {
    @NotNull
    private final SortedMap<String, SortedMap<String, SortedSet<String>>> index = new TreeMap<String, SortedMap<String, SortedSet<String>>>();
    static final long serialCheck = 7982030911970582837L;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public SortedSet<String> findByPropertyValue(@NotNull String property, @NotNull String value) {
        void var3_10;
        if (property == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.findByPropertyValue must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.findByPropertyValue must not be null");
        }
        SortedMap<String, SortedMap<String, SortedSet<String>>> sortedMap = this.index;
        // MONITORENTER : sortedMap
        SortedMap propertyValues = (SortedMap)this.index.get(property);
        // MONITOREXIT : sortedMap
        if (propertyValues != null) {
            Object object = propertyValues;
            // MONITORENTER : object
            SortedSet valueTypes = (SortedSet)propertyValues.get(value);
            // MONITOREXIT : object
            if (valueTypes != null) {
                object = valueTypes;
                // MONITORENTER : object
                TreeSet treeSet = new TreeSet(valueTypes);
                // MONITOREXIT : object
            } else {
                TreeSet treeSet = new TreeSet();
            }
        } else {
            TreeSet treeSet = new TreeSet();
        }
        void v0 = var3_10;
        if (v0 == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/SimplePropertyIndex.findByPropertyValue must not return null");
        return v0;
    }

    public void addType(@NotNull String typeName, @NotNull PropertyProvider propertyProvider) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.addType must not be null");
        }
        if (propertyProvider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.addType must not be null");
        }
        propertyProvider.visitProperties(new AddPropertyVisitor(typeName));
    }

    public void removeType(@NotNull String typeName, @NotNull PropertyProvider propertyProvider) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.removeType must not be null");
        }
        if (propertyProvider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.removeType must not be null");
        }
        propertyProvider.visitProperties(new RemovePropertyVisitor(typeName));
    }

    public void clear() {
        this.index.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProperty(@NotNull String typeName, @NotNull String property, @NotNull String value) {
        SortedSet<String> valueTypes;
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.addProperty must not be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.addProperty must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.addProperty must not be null");
        }
        SortedSet<String> sortedSet = valueTypes = this.findValueSet(property, value);
        synchronized (sortedSet) {
            valueTypes.add(typeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProperty(@NotNull String typeName, @NotNull String property, @NotNull String value) {
        boolean removeValues;
        SortedSet<String> valueTypes;
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.removeProperty must not be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.removeProperty must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.removeProperty must not be null");
        }
        SortedSet<String> sortedSet = valueTypes = this.findValueSet(property, value);
        synchronized (sortedSet) {
            valueTypes.remove(typeName);
            removeValues = valueTypes.isEmpty();
        }
        if (removeValues) {
            this.removeValueSet(property, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private SortedSet<String> findValueSet(@NotNull String property, @NotNull String value) {
        TreeSet<String> valueTypes;
        TreeMap<String, TreeSet<String>> propertyValues;
        if (property == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.findValueSet must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.findValueSet must not be null");
        }
        SortedMap<String, SortedMap<String, SortedSet<String>>> sortedMap = this.index;
        synchronized (sortedMap) {
            propertyValues = (TreeMap<String, TreeSet<String>>)this.index.get(property);
            if (propertyValues == null) {
                propertyValues = new TreeMap<String, TreeSet<String>>();
                this.index.put(property, propertyValues);
            }
        }
        TreeMap<String, TreeSet<String>> treeMap = propertyValues;
        synchronized (treeMap) {
            valueTypes = (TreeSet<String>)propertyValues.get(value);
            if (valueTypes == null) {
                valueTypes = new TreeSet<String>();
                propertyValues.put(value, valueTypes);
            }
        }
        TreeSet<String> treeSet = valueTypes;
        if (treeSet == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/SimplePropertyIndex.findValueSet must not return null");
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeValueSet(@NotNull String property, @NotNull String value) {
        if (property == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.removeValueSet must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex.removeValueSet must not be null");
        }
        SortedMap<String, SortedMap<String, SortedSet<String>>> sortedMap = this.index;
        synchronized (sortedMap) {
            SortedMap propertyValues = (SortedMap)this.index.get(property);
            if (propertyValues != null) {
                SortedMap sortedMap2 = propertyValues;
                synchronized (sortedMap2) {
                    SortedSet valueTypes = (SortedSet)propertyValues.get(value);
                    if (valueTypes != null) {
                        SortedSet sortedSet = valueTypes;
                        synchronized (sortedSet) {
                            if (valueTypes.isEmpty()) {
                                propertyValues.remove(value);
                            }
                        }
                    }
                    if (propertyValues.isEmpty()) {
                        this.index.remove(property);
                    }
                }
            }
        }
    }

    private class RemovePropertyVisitor
    extends AbstractPropertyVisitor {
        private RemovePropertyVisitor(String typeName) {
            if (SimplePropertyIndex.this == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex$RemovePropertyVisitor.<init> must not be null");
            }
            super(typeName);
        }

        @Override
        public boolean visit(@NotNull String key, @NotNull String value) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex$RemovePropertyVisitor.visit must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex$RemovePropertyVisitor.visit must not be null");
            }
            SimplePropertyIndex.this.removeProperty(this.typeName, key, value);
            return true;
        }
    }

    private class AddPropertyVisitor
    extends AbstractPropertyVisitor {
        private AddPropertyVisitor(String typeName) {
            if (SimplePropertyIndex.this == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex$AddPropertyVisitor.<init> must not be null");
            }
            super(typeName);
        }

        @Override
        public boolean visit(@NotNull String key, @NotNull String value) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex$AddPropertyVisitor.visit must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex$AddPropertyVisitor.visit must not be null");
            }
            SimplePropertyIndex.this.addProperty(this.typeName, key, value);
            return true;
        }
    }

    private static abstract class AbstractPropertyVisitor
    implements PropertyVisitor {
        protected final String typeName;

        protected AbstractPropertyVisitor(@NotNull String typeName) {
            if (typeName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/SimplePropertyIndex$AbstractPropertyVisitor.<init> must not be null");
            }
            this.typeName = typeName;
        }
    }
}

