/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.Map;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.type.AbstractPresentationMigrator;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.xobject.presentationmodel.FontProperties;
import oracle.bpm.xobject.presentationmodel.XFormGraphic;
import oracle.bpm.xobject.presentationmodel.XFormRepeatablesection;
import oracle.bpm.xobject.presentationmodel.XFormUserInputPresentationXMLObject;

public class Presentation5Migrator
extends AbstractPresentationMigrator {
    private static final String ITALIC = "italic";
    private static final String BOLD = "bold";

    public Presentation5Migrator(XObjectTypeDescription obj, String currentParentName, StringList requiredAttributes) {
        super(obj, currentParentName, requiredAttributes);
    }

    @Override
    protected void migratePresentationComponent(XFormUserInputPresentationXMLObject comp, String arrayRef, Map<String, String> groupMethods) {
        FontProperties f;
        FontStyle fontStyle;
        if (comp instanceof FontProperties && (fontStyle = (f = (FontProperties)((Object)comp)).getFontStyle()) != null) {
            f.setFontStyle(Presentation5Migrator.getAccurateFont(fontStyle));
        }
    }

    @Override
    protected void migratePresentationGraphic(XFormGraphic graphic, String arrayRef, Map<String, String> groupMethods) {
        if (!Presentation5Migrator.isValid(graphic.fontface)) {
            graphic.setFontStyle(FontStyle.PLAIN);
        }
    }

    @Override
    protected void migrateRepeatableSettings(XFormRepeatablesection repeatablesection) {
        if (!Presentation5Migrator.isValid(repeatablesection.headerfontface)) {
            repeatablesection.setHeaderFontStyle(Presentation5Migrator.getAccurateFont(repeatablesection.headerfontface));
        }
        if (!Presentation5Migrator.isValid(repeatablesection.indexfontface)) {
            repeatablesection.setIndexFontStyle(Presentation5Migrator.getAccurateFont(repeatablesection.indexfontface));
        }
        if (!Presentation5Migrator.isValid(repeatablesection.pagingfontface)) {
            repeatablesection.setPagingFontStyle(Presentation5Migrator.getAccurateFont(repeatablesection.pagingfontface));
        }
    }

    private static boolean isValid(String s) {
        for (FontStyle style : FontStyle.values()) {
            if (!style.toString().equalsIgnoreCase(s) && !style.getMsg().getString().equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    private static FontStyle getAccurateFont(FontStyle f) {
        String s = f.getString();
        return Presentation5Migrator.getAccurateFont(s);
    }

    private static FontStyle getAccurateFont(String s) {
        FontStyle ret = FontStyle.PLAIN;
        String font = s.toLowerCase();
        if (font.contains(BOLD) && font.contains(ITALIC)) {
            ret = FontStyle.BOLD_ITALIC;
        } else if (font.contains(ITALIC)) {
            ret = FontStyle.ITALIC;
        } else if (font.contains(BOLD)) {
            ret = FontStyle.BOLD;
        }
        return ret;
    }
}

