/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.util.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class IntrospectionRules {
    private SelectionRule[] selectionRules = new SelectionRule[0];
    private Rule[] transformationRules = new Rule[0];

    public static IntrospectionRules parse(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        IntrospectionRules rules = IntrospectionRules.parse(fileReader);
        ((Reader)fileReader).close();
        return rules;
    }

    public static IntrospectionRules parse(Reader fileReader) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(fileReader);
        IntrospectionRules rules = new IntrospectionRules();
        while ((line = reader.readLine()) != null) {
            if (IntrospectionRules.isComment(line = line.trim())) continue;
            rules.parseRule(line);
        }
        return rules;
    }

    public void addSelectionRule(SelectionRule rule) {
        this.selectionRules = (SelectionRule[])ArrayUtils.addElement(SelectionRule.class, this.selectionRules, rule);
    }

    public void addRule(Rule rule) {
        this.transformationRules = (Rule[])ArrayUtils.addElement(Rule.class, this.transformationRules, rule);
    }

    public TypeDescription apply(@NotNull TypeDescription type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/IntrospectionRules.apply must not be null");
        }
        return this.apply(IntrospectionRules.getTypeText(type), type);
    }

    public TypeDescription apply(@NotNull String qualifiedName, @NotNull TypeDescription type) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/IntrospectionRules.apply must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/IntrospectionRules.apply must not be null");
        }
        TypeDescription result = type;
        if (this.isIncluded(qualifiedName)) {
            for (Rule rule : this.transformationRules) {
                if (!rule.matches(qualifiedName, result)) continue;
                result = rule.apply(result);
            }
            if (result.isObject()) {
                MethodTypeDescription member;
                int i;
                ObjectTypeDescription objectType = result.asObject();
                ArrayList<MethodTypeDescription> typesToRemove = null;
                int memberCount = objectType.getMemberCount();
                for (i = 0; i < memberCount; ++i) {
                    for (member = objectType.getMember(i); member != null; member = member.getNextMethod()) {
                        String string = qualifiedName + "." + member.getName();
                        TypeDescription memberType = this.apply(string, member);
                        if (memberType == null) {
                            if (typesToRemove == null) {
                                typesToRemove = new ArrayList<MethodTypeDescription>();
                            }
                            typesToRemove.add(member);
                            continue;
                        }
                        if (memberType == member) continue;
                    }
                }
                if (typesToRemove != null) {
                    for (i = 0; i < typesToRemove.size(); ++i) {
                        member = (MethodTypeDescription)typesToRemove.get(i);
                        objectType.removeMember(member);
                    }
                    typesToRemove.clear();
                }
                int count = objectType.getInnerTypeCount();
                for (int i2 = 0; i2 < count; ++i2) {
                    ObjectTypeDescription objectTypeDescription = objectType.getInnerType(i2);
                    String innerTypeName = qualifiedName + "." + objectTypeDescription.getName();
                    TypeDescription fixedType = this.apply(innerTypeName, objectTypeDescription);
                    if (fixedType == null) {
                        if (typesToRemove == null) {
                            typesToRemove = new ArrayList();
                        }
                        typesToRemove.add((MethodTypeDescription)((Object)objectTypeDescription));
                        continue;
                    }
                    if (objectTypeDescription == fixedType) continue;
                    objectType.replaceInnerAt(i2, fixedType);
                }
                if (typesToRemove != null) {
                    for (TypeDescription typeDescription : typesToRemove) {
                        objectType.removeInnerType(typeDescription);
                    }
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    public boolean isIncluded(String typeName) {
        boolean include = false;
        int length = this.selectionRules.length;
        for (int i = length - 1; i >= 0; --i) {
            SelectionRule rule = this.selectionRules[i];
            if (!rule.matches(typeName)) continue;
            include = rule.isInclude();
            break;
        }
        return include;
    }

    public TypeDescription[] apply(TypeDescription[] types) {
        for (int i = 0; i < types.length; ++i) {
            TypeDescription type = types[i];
            types[i] = this.apply(type);
        }
        return ArrayUtils.trim(types);
    }

    private static boolean isComment(String line) {
        return line.startsWith("#") || line.length() == 0;
    }

    private static String getTypeText(TypeDescription type) {
        return type.isMember() ? type.getParent().getText() + "." + type.getName() : type.getText();
    }

    private void parseRule(String line) throws IOException {
        int whitespaceIndex = line.indexOf(32);
        if (whitespaceIndex == -1) {
            throw new IOException("Invalid command: " + line);
        }
        String name = line.substring(0, whitespaceIndex);
        line = line.substring(whitespaceIndex + 1).trim();
        int length = line.length();
        ArrayList<String> args = new ArrayList<String>();
        block5: for (int i = 0; i < length; ++i) {
            char ch = line.charAt(i);
            switch (ch) {
                case '\"': {
                    int start = ++i;
                    while (i < length && (ch = line.charAt(i)) != '\"') {
                        if (ch == '\\' && i + 1 < length && line.charAt(i + 1) == '\"') {
                            ++i;
                        }
                        ++i;
                    }
                    String text = line.substring(start, i);
                    args.add(text);
                    continue block5;
                }
                case '\\': {
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case ' ': {
                    continue block5;
                }
                default: {
                    int start = i;
                    while (i < length && !Character.isWhitespace(line.charAt(i))) {
                        ++i;
                    }
                    if (i <= start) continue block5;
                    args.add(line.substring(start, i));
                }
            }
        }
        String regexp = (String)args.get(0);
        if ("include".equals(name)) {
            this.addSelectionRule(new SelectionRule(regexp, true));
        } else if ("exclude".equals(name)) {
            this.addSelectionRule(new SelectionRule(regexp, false));
        } else if ("hide".equals(name)) {
            this.addRule(new Hide(regexp, false));
        } else if ("hide-object".equals(name)) {
            this.addRule(new Hide(regexp, true));
        } else if ("rename".equals(name)) {
            this.addRule(new Rename(regexp, (String)args.get(1)));
        } else if ("delegate".equals(name)) {
            this.addRule(new Delegate(regexp, (String)args.get(1), (String)args.get(2)));
        } else if ("doc".equals(name)) {
            this.addRule(new Doc(regexp, (String)args.get(1)));
        } else if ("refactor".equals(name)) {
            this.addRule(new Refactor(regexp, (String)args.get(1), (String)args.get(2)));
        } else {
            throw new IOException("Invalid command: " + name);
        }
    }

    public static class SelectionRule {
        protected Matcher matcher;
        protected Pattern pattern;
        private final boolean include;

        public SelectionRule(String regexp, boolean include) {
            regexp = regexp.trim();
            this.pattern = Pattern.compile(regexp);
            this.matcher = this.pattern.matcher("");
            this.include = include;
        }

        public boolean matches(String typeName) {
            this.matcher.reset(typeName);
            return this.matcher.matches();
        }

        public boolean isInclude() {
            return this.include;
        }
    }

    public static class Rule {
        protected Matcher matcher;
        protected Pattern pattern;

        public Rule(String regexp) {
            regexp = regexp.trim();
            this.pattern = Pattern.compile(regexp);
            this.matcher = this.pattern.matcher("");
        }

        public TypeDescription apply(TypeDescription type) {
            return type;
        }

        public boolean matches(String qualifiedName, TypeDescription type) {
            this.matcher.reset(qualifiedName);
            return this.matcher.matches();
        }

        public String toString() {
            return "PatternBasedRule(" + this.pattern.pattern() + ")";
        }
    }

    public static class Rename
    extends Rule {
        private String newName;

        public Rename(String regexp, String newName) {
            super(regexp);
            this.newName = newName;
        }

        @Override
        public TypeDescription apply(TypeDescription type) {
            if (type.isObject()) {
                ObjectTypeDescription otd = type.asObject();
                TypeDescription parent = otd.getParent();
                if (parent != null) {
                    parent.asObject().removeInnerType(otd);
                }
                otd.setName(this.newName);
                if (parent != null) {
                    parent.asObject().addInnerType(otd);
                }
            }
            return type;
        }

        @Override
        public String toString() {
            return "Rename(" + this.pattern.pattern() + "=> " + this.newName + ")";
        }
    }

    public static class Refactor
    extends Rule {
        private String code;
        private String codeType;

        public Refactor(String regexp, String type, String code) {
            super(regexp);
            this.codeType = type;
            this.code = code;
        }

        @Override
        public TypeDescription apply(TypeDescription type) {
            MethodTypeDescription member = type.asMethod();
            member.setModifiers(member.getModifiers() | 0x8000000000L);
            member.setCode(this.code, "Fuego");
            if ("expression".equals(this.codeType)) {
                member.setModifiers(member.getModifiers() | 0x1000000000L);
            } else if (!"statement".equals(this.codeType)) {
                throw new IllegalArgumentException("Invalid type: " + this.codeType + ", it must be 'expression' or 'statement'");
            }
            return type;
        }

        @Override
        public boolean matches(String qualifiedName, TypeDescription type) {
            return type.isMethod() && super.matches(qualifiedName, type);
        }

        @Override
        public String toString() {
            return "Refactor(" + this.pattern.pattern() + ")";
        }
    }

    public static class Hide
    extends Rule {
        private boolean onlyObjects;

        public Hide(String regexp, boolean onlyObjects) {
            super(regexp);
            this.onlyObjects = onlyObjects;
        }

        @Override
        public TypeDescription apply(TypeDescription type) {
            if (type.isObject()) {
                type.asObject().setModifiers(type.getModifiers() | 0x2000000L);
            } else if (type.isMember() && !this.onlyObjects) {
                type.asMethod().setModifiers(type.getModifiers() | 0x2000000L);
            }
            return type;
        }

        @Override
        public String toString() {
            return "Hide(" + this.pattern.pattern() + ")";
        }
    }

    public static class Doc
    extends Rule {
        private String description;

        public Doc(String regexp, String description) {
            super(regexp);
            this.description = description;
        }

        @Override
        public TypeDescription apply(TypeDescription type) {
            if (type.isObject()) {
                type.asObject().setDescription(this.description);
            } else if (type.isMember()) {
                type.asMethod().setDescription(this.description);
            }
            return type;
        }

        @Override
        public String toString() {
            return "Doc(" + this.pattern.pattern() + ")";
        }
    }

    public static class Delegate
    extends Rule {
        private String signature;

        public Delegate(String regexp, String javaClass, String method) {
            super(regexp);
            this.signature = "L" + javaClass + ";" + method;
        }

        @Override
        public TypeDescription apply(TypeDescription type) {
            MethodTypeDescription member = type.asMethod();
            member.setSignature(this.signature);
            return type;
        }

        @Override
        public boolean matches(String qualifiedName, TypeDescription type) {
            return type.isMethod() && super.matches(qualifiedName, type);
        }

        @Override
        public String toString() {
            return "Delegate(" + this.pattern.pattern() + ")";
        }
    }
}

