/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormValue;
import oracle.bpm.xobject.xml.XFormXMLObject;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class FormLoader45 {
    private Stack<XFormXMLObject> currentElement;
    private XFormPresentationModel pModel;
    private Map<String, Field> pModelFieldCache;
    private Map<String, XFormPresentationModel> presentations;
    private boolean presentationStage;
    private static final String CURRENT_PACKAGE = "oracle.bpm.xobject.presentationmodel.XForm";

    public FormLoader45() {
        this(false);
    }

    public FormLoader45(boolean startInPresentationStage) {
        this.presentationStage = startInPresentationStage;
        this.pModelFieldCache = new HashMap<String, Field>();
    }

    public boolean isPresentationStage() {
        return this.presentationStage;
    }

    public Map<String, XFormPresentationModel> getPresentations() {
        return this.presentations;
    }

    public void setPresentationStage(boolean presentationStage) {
        this.presentationStage = presentationStage;
    }

    public DefaultHandler createDefaultHandler(final String fileName) {
        return new DefaultHandler(){

            @Override
            public void characters(char[] ch, int start, int length) {
                FormLoader45.this.managePresentationCharacters(ch, start, length);
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                FormLoader45.this.managePresentationEndElement(qName, fileName);
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                FormLoader45.this.managePresentationStartElement(qName, attributes, null);
            }
        };
    }

    protected void managePresentationStartElement(String name, Attributes amap, ObjectTypeDescription currentObject) {
        if (!this.presentationStage) {
            return;
        }
        if ("presentation".equalsIgnoreCase(name)) {
            if (this.currentElement == null) {
                this.currentElement = new Stack();
            }
            this.pModel = new XFormPresentationModel(currentObject);
        }
        String newClass = CURRENT_PACKAGE + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
        try {
            Class<?> newOneClass = Class.forName(newClass);
            XFormXMLObject newOne = (XFormXMLObject)newOneClass.newInstance();
            if (this.currentElement.empty()) {
                this.currentElement.push(newOne);
                Field field = this.pModelFieldCache.get(name);
                if (field == null) {
                    field = FormLoader45.getFieldForName(this.pModel.getClass(), name);
                    this.pModelFieldCache.put(name, field);
                }
                field.set(this.pModel, newOne);
                newOne.setParent(this.pModel);
            } else {
                Field field;
                XFormXMLObject lastElement = this.currentElement.peek();
                this.currentElement.push(newOne);
                newOne.setParent(lastElement);
                Class<?> lastElementClass = lastElement.getClass();
                try {
                    field = FormLoader45.getFieldForName(lastElementClass, name);
                }
                catch (NoSuchFieldException nsfe) {
                    try {
                        field = lastElement.getClass().getField(name + "_entities_d");
                    }
                    catch (NoSuchFieldException nsfe3) {
                        field = lastElement.getClass().getField(name + "_entity_d");
                    }
                }
                if (field.getType().isArray()) {
                    if (field.getType().getComponentType().equals(newOneClass)) {
                        XFormXMLObject[] val = (XFormXMLObject[])field.get(lastElement);
                        if (val == null) {
                            val = (XFormXMLObject[])Array.newInstance(field.getType().getComponentType(), 0);
                        }
                        Object newArray = Array.newInstance(field.getType().getComponentType(), val.length + 1);
                        System.arraycopy(val, 0, newArray, 0, val.length);
                        Array.set(newArray, val.length, newOne);
                        field.set(lastElement, newArray);
                    }
                } else {
                    field.set(lastElement, newOne);
                }
            }
            for (int i = 0; i < amap.getLength(); ++i) {
                Field field;
                String qname = amap.getQName(i);
                try {
                    field = FormLoader45.getFieldForName(newOne.getClass(), qname);
                }
                catch (NoSuchFieldException nsfe) {
                    Log.logDebug(nsfe.getMessage());
                    continue;
                }
                Class<?> fieldType = field.getType();
                String fieldName = fieldType.toString();
                String[] eachValue = amap.getValue(i);
                if (eachValue.trim().length() == 0) continue;
                if ("int".equals(fieldName)) {
                    field.setInt(newOne, Integer.parseInt((String)eachValue));
                    continue;
                }
                if ("boolean".equals(fieldName)) {
                    field.setBoolean(newOne, Boolean.parseBoolean((String)eachValue));
                    continue;
                }
                if ("double".equals(fieldName)) {
                    field.setDouble(newOne, Double.parseDouble((String)eachValue));
                    continue;
                }
                if (fieldType.isEnum()) {
                    Field aField;
                    try {
                        aField = fieldType.getField((String)eachValue);
                    }
                    catch (NoSuchFieldException e) {
                        aField = fieldType.getField(FormLoader45.migrateFontStyle((String)eachValue));
                    }
                    field.set(newOne, aField.get(null));
                    continue;
                }
                Object[] objectValue = eachValue;
                if (fieldType.isArray()) {
                    Class<?> type = fieldType.getComponentType();
                    if (String.class.equals(type)) {
                        objectValue = FormLoader45.getValuesAsArray((String)eachValue);
                    } else if (Integer.TYPE.equals(type)) {
                        String[] stringValues = FormLoader45.getValuesAsArray((String)eachValue);
                        int[] values = new int[stringValues.length];
                        for (int j = 0; j < values.length; ++j) {
                            values[j] = Integer.parseInt(stringValues[j]);
                        }
                        objectValue = values;
                    }
                }
                field.set(newOne, objectValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void managePresentationEndElement(String name, String currentFileName) {
        if (!this.presentationStage) {
            return;
        }
        XFormXMLObject poped = this.currentElement.pop();
        if ("presentation".equalsIgnoreCase(name)) {
            String id;
            if (this.presentations == null) {
                this.presentations = new HashMap<String, XFormPresentationModel>();
            }
            if ((id = this.pModel.presentation_d.id) == null) {
                throw new IllegalStateException("Presentation without id in  : " + currentFileName);
            }
            this.pModel.migrate();
            this.pModel.name_d = id;
            this.presentations.put(id, this.pModel);
            this.pModel = null;
            this.currentElement = new Stack();
        } else {
            poped.init();
        }
    }

    protected void managePresentationCharacters(char[] ch, int start, int length) {
        if (!this.presentationStage) {
            return;
        }
        String content = new String(ch, start, length);
        XFormXMLObject poped = this.currentElement.peek();
        if (poped instanceof XFormValue) {
            try {
                Field field = poped.getClass().getField("value_d");
                String tmp = (String)field.get(poped);
                field.set(poped, tmp + content.trim());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Field getFieldForName(Class<?> cl, String qName) throws NoSuchFieldException {
        Field field;
        try {
            field = cl.getField(qName);
        }
        catch (NoSuchFieldException nsfe) {
            field = cl.getField(qName + "_d");
        }
        return field;
    }

    private static String migrateFontStyle(String eachValue) {
        String f = "PLAIN";
        String lowerValue = eachValue.toLowerCase();
        boolean isBold = lowerValue.contains("bold");
        boolean isItalic = lowerValue.contains("italic");
        if (isBold && isItalic) {
            f = "BOLD_ITALIC";
        } else if (isBold) {
            f = "BOLD";
        } else if (isItalic) {
            f = "ITALIC";
        }
        return f;
    }

    private static String[] getValuesAsArray(String val) {
        int fistComma = val.indexOf(44) + 1;
        val = val.substring(fistComma, val.length() - 1);
        return val.split(",");
    }
}

