/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.ArrayList;
import oracle.bpm.lang.AbstractTypeUUID;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.observers.ObjectRelationListener;
import oracle.bpm.type.BpmObjectDynamicRef;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.IdentifiableType;
import oracle.bpm.type.TypeObserver;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.UnknownType;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicRef
implements TypeRef,
IdentifiableType {
    private ComponentCatalog catalog;
    private String componentType;
    @NotNull
    private String name;
    private String uniqueId;
    public static final String DEFAULT_NAME = "DynamicRef";
    private static final char ISO_ESCAPE = '#';
    private static final char UNICODE_ESCAPE = '&';
    private static final char FIELD_SEPARATOR = ',';

    public DynamicRef(@NotNull ObjectTypeDescription otd, @NotNull ComponentCatalog catalog) {
        if (otd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DynamicRef.<init> must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/DynamicRef.<init> must not be null");
        }
        this(otd.getComponentType(), otd.getId(), otd.getName(), catalog);
    }

    public DynamicRef(@NotNull String componentType, @NotNull String uniqueId, @NotNull ComponentCatalog catalog) {
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DynamicRef.<init> must not be null");
        }
        if (uniqueId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/DynamicRef.<init> must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/type/DynamicRef.<init> must not be null");
        }
        this(componentType, uniqueId, null, catalog);
    }

    public DynamicRef(@NotNull XmlUUID uniqueId, @Nullable String name, @NotNull ComponentCatalog catalog) {
        if (uniqueId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DynamicRef.<init> must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/type/DynamicRef.<init> must not be null");
        }
        this.setName(name);
        this.setComponentType(ComponentType.XML.getText());
        this.setId(uniqueId.getId());
        this.setCatalog(catalog);
    }

    public DynamicRef(@NotNull String componentType, @NotNull String uniqueId, @Nullable String name, @NotNull ComponentCatalog catalog) {
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DynamicRef.<init> must not be null");
        }
        if (uniqueId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/DynamicRef.<init> must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/type/DynamicRef.<init> must not be null");
        }
        this.setName(name);
        this.setComponentType(componentType);
        this.setId(uniqueId);
        this.setCatalog(catalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static DynamicRef parse(@NotNull String text, @NotNull ComponentCatalog catalog) {
        DynamicRef type;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DynamicRef.parse must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/DynamicRef.parse must not be null");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        int len = (text = text.trim()).length();
        if (len == 0) {
            throw new IllegalArgumentException("text cannot be empty");
        }
        if (len < 3 || text.charAt(0) != '{' || text.charAt(len - 1) != '}') {
            throw new IllegalArgumentException("Malformed string: " + text);
        }
        ComponentCatalog componentCatalog = catalog;
        synchronized (componentCatalog) {
            type = catalog.getLazyRef(text);
            if (type == null) {
                String[] elements = DynamicRef.split(text = text.substring(1, len - 1), ',');
                if (elements.length < 2 || elements.length > 3) {
                    throw new IllegalArgumentException("Malformed string: " + text);
                }
                String componentType = DynamicRef.unescape(elements[0]);
                String id = DynamicRef.unescape(elements[1]);
                String name = elements.length == 3 ? DynamicRef.unescape(elements[2]) : DEFAULT_NAME;
                type = new DynamicRef(componentType, id, name, catalog);
                catalog.putLazyRef(text, type);
            }
        }
        return type;
    }

    public static String unescape(String src) {
        int len = src.length();
        StringBuffer buf = new StringBuffer(len);
        int escape = 0;
        int current = 0;
        block4: for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (escape > 0) {
                int digit = Character.digit(c, 16);
                if (digit >= 0 && digit < 16) {
                    current <<= 4;
                    current |= digit;
                    if (--escape != 0) continue;
                    buf.append((char)current);
                    continue;
                }
                escape = 0;
                buf.append(c);
                continue;
            }
            switch (c) {
                case '#': {
                    escape = 2;
                    current = 0;
                    continue block4;
                }
                case '&': {
                    escape = 4;
                    current = 0;
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    @Override
    public ComponentCatalog getCatalog() {
        return this.catalog;
    }

    @Override
    public boolean isFromCatalog(ComponentCatalog catalog) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getComponentType() {
        String string = this.componentType;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/DynamicRef.getComponentType must not return null");
        }
        return string;
    }

    @Override
    public int getKind() {
        return this.get().getKind();
    }

    @Override
    public long getLastModifiedTime() {
        return 0L;
    }

    @Override
    public long getModifiers() {
        return 0L;
    }

    @Override
    public TypeRef getRef() {
        return this;
    }

    @Override
    public String getText() {
        TypeRef ref = this.find();
        if (ref != null) {
            return this.getRealType(ref).getText();
        }
        AbstractTypeUUID typeUUID = UUIDFactory.parseUUID(this.uniqueId);
        if (typeUUID != null) {
            return typeUUID.getQName().toString();
        }
        return this.componentType + "::" + this.uniqueId;
    }

    @Override
    public TypeDescription get() {
        TypeRef ref = this.find();
        if (ref != null) {
            return this.getRealType(ref);
        }
        UnknownType unknownType = UnknownType.create(this.name, this.getCatalog(), this.componentType + "::" + this.uniqueId);
        unknownType.setId(this.uniqueId);
        return unknownType;
    }

    @Override
    public void addObserver(TypeObserver observer) {
    }

    @Override
    public void removeObserver(TypeObserver observer) {
    }

    @Override
    @Nullable
    public String getName() {
        TypeRef ref = this.find();
        if (ref != null) {
            return ref.getName();
        }
        return this.name;
    }

    @Override
    public void addPropertyObserver(String propertyName, ObjectPropertyListener observer) {
    }

    @Override
    public void removePropertyObserver(String propertyName, ObjectPropertyListener observer) {
    }

    @Override
    public void addRelationObserver(String relationPropertyName, ObjectRelationListener observer) {
    }

    @Override
    public void removeRelationObserver(String relationPropertyName, ObjectRelationListener observer) {
    }

    public void setId(@NotNull String uniqueId) {
        if (uniqueId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DynamicRef.setId must not be null");
        }
        this.uniqueId = uniqueId;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getId() {
        String string = this.uniqueId;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/DynamicRef.getId must not return null");
        }
        return string;
    }

    public void setComponentType(@NotNull String componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DynamicRef.setComponentType must not be null");
        }
        this.componentType = componentType;
    }

    public void setName(@Nullable String name) {
        this.name = Str.isEmpty(name) ? DEFAULT_NAME : Identifier.classname(name);
    }

    public void setCatalog(ComponentCatalog catalog) {
        this.catalog = catalog;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            if (o instanceof BpmObjectDynamicRef && this.componentType.equals(ComponentType.XML.getText())) {
                BpmObjectDynamicRef that = (BpmObjectDynamicRef)o;
                return this.catalog.equals(that.getCatalog()) && this.uniqueId.equals(that.getId());
            }
            return false;
        }
        DynamicRef that = (DynamicRef)o;
        return this.catalog.equals(that.catalog) && this.componentType.equals(that.componentType) && this.uniqueId.equals(that.uniqueId);
    }

    public int hashCode() {
        int result = this.catalog.hashCode();
        result = 31 * result + this.componentType.hashCode();
        result = 31 * result + this.uniqueId.hashCode();
        return result;
    }

    protected TypeRef find() {
        return this.getCatalog().findById(this.getComponentType(), this.getId());
    }

    private static String[] split(String src, char fieldSeparator) {
        ArrayList<String> list = new ArrayList<String>();
        int len = src.length();
        int last = 0;
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (c != fieldSeparator) continue;
            list.add(src.substring(last, i));
            last = i + 1;
        }
        if (last != len) {
            list.add(src.substring(last, len));
        } else {
            list.add("");
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private TypeDescription getRealType(@NotNull TypeRef ref) {
        TypeRef realType;
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/DynamicRef.getRealType must not be null");
        }
        TypeDescription typeDescription = ref.get();
        if (typeDescription.isXmlObject() && (realType = (TypeRef)typeDescription.asObject().getTransientProperty("real.type")) != null) {
            typeDescription = realType.get();
        }
        TypeDescription typeDescription2 = typeDescription;
        if (typeDescription2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/DynamicRef.getRealType must not return null");
        }
        return typeDescription2;
    }
}

