/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.Variable;
import org.jetbrains.annotations.NonNls;

public class Argument
extends Variable {
    protected String defaultValue;
    protected String holder;
    protected String javaType;
    protected long modifiers;
    protected int number;
    protected Map<String, String> properties;
    protected int state;
    public static final String RETURN_ARGUMENT = "return";
    @NonNls
    private static final String INVOCABLE_SIGNATURE = 'L' + Invokeable.class.getName() + ';';
    public static final long IN = 1L;
    public static final long OUT = 2L;
    public static final long INOUT = 3L;
    public static final long RETVAL = 16L;
    public static final long ATTRIBUTE = 32L;
    public static final long EXTERNAL = 2048L;
    public static final long OPTIONAL = 0x80000000L;
    public static final long VALID_MODIFIERS_MASK = 0x80000833L;
    public static final String HAS_METADATA_ANNOTATIONS = "hasMetadataAnnotations";
    public static final String LVALUE_ARGNAME = "value$0";

    public Argument(@NonNls String name, TypeRef type, long modifiers) {
        this(name, type, modifiers, 0, null);
    }

    public Argument(String name, TypeRef type, long modifiers, int number, String javaType) {
        super(name, type);
        this.setModifiers(modifiers);
        this.number = number;
        this.javaType = javaType;
    }

    public final void setProperty(String name, String value) {
        if (value == null) {
            this.getProperties().remove(name);
        } else {
            this.getProperties().put(name, value);
        }
    }

    public final String getProperty(String name) {
        return this.properties != null ? this.properties.get(name) : null;
    }

    public boolean isArgument() {
        return (this.modifiers & 0x20L) == 0L && (this.modifiers & 0x10L) == 0L;
    }

    public boolean isAttribute() {
        return (this.modifiers & 0x20L) != 0L;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setExternal(boolean external) {
        this.modifiers = external ? (this.modifiers |= 0x800L) : (this.modifiers &= 0xFFFFFFFFFFFFF7FFL);
    }

    public boolean isExternal() {
        return (this.modifiers & 0x800L) != 0L;
    }

    public void setHolderJavaType(String holder) {
        this.holder = holder;
    }

    public String getHolderJavaType() {
        if (this.isOut() && this.holder == null) {
            TypeDescription holderType = this.getType().getHolderType();
            return holderType.getDefaultHolder();
        }
        return this.holder;
    }

    public void setIn(boolean in) {
        this.modifiers = in ? (this.modifiers |= 1L) : (this.modifiers &= 0xFFFFFFFFFFFFFFFEL);
    }

    public boolean isIn() {
        return (this.modifiers & 1L) != 0L;
    }

    public String getJavaSignature() {
        if (this.isOut()) {
            return 'L' + this.getHolderJavaType() + ';';
        }
        TypeDescription type = this.getType();
        if (this.javaType != null) {
            boolean isArray = type.isArray() || type.isBinary() && "byte[]".equals(this.javaType);
            boolean isGroupArray = this.javaType.contains("GroupArray");
            boolean isPrimitive = JavaClass.isPrimitiveType(this.javaType);
            if (this.isExternal() && !isPrimitive && !isArray || isGroupArray) {
                return 'L' + this.javaType + ';';
            }
        }
        if (type.isInvokeable()) {
            return INVOCABLE_SIGNATURE;
        }
        return type.getJavaSignature();
    }

    public void setJavaType(String javaType) {
        assert (!"".equals(javaType)) : "Attempt to set empty javaType to " + this + ". It must be null or a valid java type.";
        this.javaType = javaType;
    }

    public String getJavaType() {
        if (this.javaType == null) {
            return this.getType().getJavaType();
        }
        return this.javaType;
    }

    public void setModifiers(long mods) {
        this.modifiers = mods;
    }

    public void setModifiers(String mods) {
        this.setModifiers(Modifier.getModifiers(mods));
    }

    public long getModifiers() {
        return this.modifiers;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isOptional() {
        return (this.modifiers & 0x80000000L) != 0L;
    }

    public void setOut(boolean out) {
        this.modifiers = out ? (this.modifiers |= 2L) : (this.modifiers &= 0xFFFFFFFFFFFFFFFDL);
    }

    public boolean isOut() {
        return (this.modifiers & 2L) != 0L;
    }

    public void setProperties(Map<String, String> props) {
        this.properties = props;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new TreeMap<String, String>();
        }
        return this.properties;
    }

    public boolean isReturnValue() {
        return (this.modifiers & 0x10L) != 0L;
    }

    public void clearModifier(long modifier) {
        this.setModifiers(this.getModifiers() & (modifier ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public Argument copy() {
        Argument argument = (Argument)this.clone();
        if (this.properties != null) {
            argument.properties = new TreeMap<String, String>(this.properties);
        }
        return argument;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Argument arg = (Argument)obj;
        if (this.getModifiers() != arg.getModifiers()) {
            return false;
        }
        TypeRef typeA = this.getTypeRef();
        TypeRef typeB = arg.getTypeRef();
        return !(typeA instanceof TypeDescription) || !(typeB instanceof TypeDescription) || typeA.equals(typeB);
    }

    @Override
    public int hashCode() {
        long modifiers = this.getModifiers();
        return 31 * super.hashCode() + (int)(modifiers ^ modifiers >>> 32);
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public boolean match(Argument arg, boolean checkName) {
        long argModifiers;
        if (arg == null) {
            return false;
        }
        if (checkName && !this.getName().equals(arg.getName())) {
            return false;
        }
        long modifiers = this.getModifiers() & 0xFFFFFFFFFFFFF7FFL;
        if (modifiers != (argModifiers = arg.getModifiers() & 0xFFFFFFFFFFFFF7FFL)) {
            return false;
        }
        TypeRef typeA = this.getTypeRef();
        TypeRef typeB = arg.getTypeRef();
        if (typeA instanceof TypeDescription && typeB instanceof TypeDescription) {
            TypeDescription a = typeA.get();
            TypeDescription b = typeB.get();
            return a.equals(b.primitiveEquivalent(a.isPrimitive()));
        }
        return typeA.getText().equals(typeB.getText());
    }

    @Override
    public String toString() {
        return this.name + '(' + Modifier.getText(this.modifiers) + ',' + this.number + ") :: " + this.type;
    }
}

