/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.UnknownType;
import oracle.bpm.util.ArrayUtils;

public class AmbiguousTypeNameException
extends TypeCatalogException {
    private TypeRef[] possibleTypes;
    private String typeName;
    private static final String FUEGO_PREFIX = "Fuego.";
    private static final String JAVA_PREFIX = "Java.";
    static final long serialVersionUID = 2764063639671257167L;
    static final long serialCheck = 4214015621127034427L;

    public AmbiguousTypeNameException(ComponentCatalog loader, String typeName, TypeRef[] possibleTypes) {
        super(loader, typeName);
        assert (possibleTypes.length > 1) : ArrayUtils.toString(possibleTypes);
        this.typeName = typeName;
        this.possibleTypes = possibleTypes;
        this.loader = loader;
    }

    public AmbiguousTypeNameException(ComponentCatalog loader, String typeName, List<TypeRef> possibleTypes) {
        this(loader, typeName, possibleTypes.toArray(TypeRef.TYPE_REF_ARRAY));
    }

    public boolean hasAnyHiddenType() {
        for (TypeRef possibleType : Arrays.asList(this.possibleTypes)) {
            TypeDescription type = possibleType.get();
            if (!type.isHidden() && !type.isSynthesized()) continue;
            return true;
        }
        return false;
    }

    public TypeDescription getHighest45PrecedenceType() {
        ArrayList<TypeRef> types = new ArrayList<TypeRef>(Arrays.asList(this.possibleTypes));
        Iterator it = types.iterator();
        while (it.hasNext()) {
            TypeRef possibleType = (TypeRef)it.next();
            TypeDescription type = possibleType.get();
            if (!this.isModule(type.asObject()) && !type.isInnerType() && !type.isHidden() && !type.isSynthesized()) continue;
            it.remove();
        }
        int length = types.size();
        if (length == 1) {
            TypeRef ref = (TypeRef)types.get(0);
            return ref.get();
        }
        if (length == 0 || length > 2) {
            return null;
        }
        TypeRef refA = (TypeRef)types.get(0);
        TypeRef refB = (TypeRef)types.get(1);
        ObjectTypeDescription a = refA.get().asObject();
        ObjectTypeDescription b = refB.get().asObject();
        String textA = a.getText();
        String textB = b.getText();
        boolean aIsJava = textA.startsWith(JAVA_PREFIX);
        boolean bIsJava = textB.startsWith(JAVA_PREFIX);
        ObjectTypeDescription result = null;
        if (aIsJava && !bIsJava) {
            result = b;
        } else if (bIsJava && !aIsJava) {
            result = a;
        } else {
            boolean aIsFuego = textA.startsWith(FUEGO_PREFIX);
            boolean bIsFuego = textB.startsWith(FUEGO_PREFIX);
            if (aIsFuego && !bIsFuego) {
                result = b;
            } else if (bIsFuego && !aIsFuego) {
                result = a;
            }
        }
        return result;
    }

    @Override
    public Msg getKey() {
        return this.getMsg();
    }

    @Override
    public Msg getMsg() {
        return CoreMsg.AMBIGUOUSTYPE(this.typeName, this.getModules());
    }

    public ObjectTypeDescription getMalformedType() {
        return UnknownType.create(this.typeName, this.loader, this);
    }

    @Override
    public String getMessage() {
        return this.getMsg().getString();
    }

    @Override
    public String getMessage(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public String getModules() {
        StringBuffer buffer = new StringBuffer();
        String[] modules = this.getPossibleModuleNames();
        for (int i = 0; i < modules.length; ++i) {
            String module = modules[i];
            buffer.append(module);
            if (i + 1 >= modules.length) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public String[] getPossibleModuleNames() {
        String[] moduleNames = new String[this.possibleTypes.length];
        for (int i = 0; i < this.possibleTypes.length; ++i) {
            String text = this.possibleTypes[i].getText();
            int lastDot = text.lastIndexOf(46);
            moduleNames[i] = lastDot > 0 ? text.substring(0, lastDot) : text;
        }
        return moduleNames;
    }

    public TypeRef[] getPossibleTypes() {
        return this.possibleTypes;
    }

    public String getTypeName() {
        return this.typeName;
    }

    private boolean isModule(ObjectTypeDescription type) {
        return type.getComponentType().equals("object") || type.getInnerTypeCount() > 0 && !type.isBpmObject();
    }
}

